/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.marc4j.MarcException;
import org.marc4j.MarcSplitStreamWriter;
import org.marc4j.MarcWriter;
import org.marc4j.marc.DataField;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.SubfieldImpl;
import org.marc4j.util.RawRecord;
import org.marc4j.util.RawRecordReader;
import org.marc4j.util.StringNaturalCompare;

public class MarcPatcher {
    private String inputFile = null;
    private String changedRecordFileName = null;
    private String changedLocationFileName = null;
    private String locationFileName = null;
    private String boundWithFileName = null;
    private MarcWriter writerAll = null;
    private MarcWriter writerChanged = null;
    private PrintStream writerDeleted = null;
    private RawRecordReader rawReader = null;
    private PrintStream out;
    private String locationRecordIDMapper = null;
    private String mapPattern = null;
    private String mapReplace = null;
    private String[] locationFileLine = null;
    private String currentLocationID = null;
    private LinkedHashMap<String, String> boundWithIds = null;
    protected Properties configProps;
    protected String configToUse = null;
    protected boolean permissiveReader;
    protected String defaultEncoding;
    protected String encoding = "per_record";
    private StringNaturalCompare compare = null;
    private boolean handleAllLocs = false;
    private MarcFactory factory = MarcFactory.newInstance();
    private Record placeHolderRecordToDelete = this.factory.newRecord();
    private boolean showInputFile;

    public MarcPatcher(String inputFile, String locationFile, String changedLocationFile, String boundWithFile, String changedOutputFile, PrintStream out, boolean handleAllLocs) {
        this.out = out;
        this.inputFile = inputFile;
        this.locationFileName = locationFile;
        this.changedRecordFileName = changedOutputFile;
        this.boundWithFileName = boundWithFile;
        this.changedLocationFileName = changedLocationFile;
        this.handleAllLocs = handleAllLocs;
    }

    protected void initLocal() {
        InputStream in = null;
        try {
            in = this.inputFile == null || this.inputFile.equals("-") ? System.in : new FileInputStream(this.inputFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.rawReader = new RawRecordReader(in);
        this.mapPattern = "u?([0-9]*).*";
        this.mapReplace = "u$1";
        this.boundWithIds = null;
        if (this.boundWithIds == null && this.boundWithFileName != null) {
            this.boundWithIds = new LinkedHashMap();
            try {
                String line;
                BufferedReader addnlIdsReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.boundWithFileName)));
                while ((line = addnlIdsReader.readLine()) != null) {
                    String[] linepts = line.split("\\|", 2);
                    linepts[0] = linepts[0].replaceFirst(this.mapPattern, this.mapReplace);
                    String existing = this.boundWithIds.get(linepts[0]);
                    if (existing != null) continue;
                    this.boundWithIds.put(linepts[0], linepts[1]);
                }
                addnlIdsReader.close();
            }
            catch (IllegalArgumentException addnlIdsReader) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.compare = new StringNaturalCompare();
    }

    public int handleAll() {
        int recordCounter = 0;
        BufferedReader locationReader = null;
        try {
            locationReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.locationFileName)), "ISO-8859-1"));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedReader changedLocationReader = null;
        if (this.changedLocationFileName != null) {
            try {
                changedLocationReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(this.changedLocationFileName))));
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
        }
        if (this.writerAll == null && this.out != null && this.changedRecordFileName != null) {
            this.writerAll = new MarcSplitStreamWriter(this.out, this.encoding, 70000, "999");
        }
        if (this.writerChanged == null && this.changedRecordFileName != null) {
            try {
                File changedRecordFile = new File(this.changedRecordFileName);
                FileOutputStream changedRecordStream = new FileOutputStream(changedRecordFile);
                this.writerChanged = new MarcSplitStreamWriter(changedRecordStream, this.encoding, 70000, "999");
                File deletedRecordFile = new File(this.changedRecordFileName.replaceAll("[.][Mm][Rr][Cc]", ".del"));
                changedRecordStream = new FileOutputStream(changedRecordFile);
                this.writerDeleted = new PrintStream(new FileOutputStream(deletedRecordFile));
            }
            catch (FileNotFoundException e) {
                this.writerChanged = null;
                this.changedRecordFileName = null;
                e.printStackTrace();
            }
        } else if (this.writerChanged == null && this.changedRecordFileName == null && this.out != null) {
            this.writerChanged = new MarcSplitStreamWriter(this.out, this.encoding, 70000, "999");
        }
        while (this.rawReader != null && this.rawReader.hasNext()) {
            ++recordCounter;
            try {
                RawRecord record = this.rawReader.next();
                Record patchedRecord = this.patchRecord(record, locationReader, changedLocationReader);
                if (this.writerAll != null && patchedRecord != this.placeHolderRecordToDelete) {
                    if (patchedRecord != null) {
                        this.writerAll.write(patchedRecord);
                    } else {
                        this.out.write(record.getRecordBytes());
                    }
                }
                if (patchedRecord != null && this.writerChanged != null) {
                    if (patchedRecord == this.placeHolderRecordToDelete) {
                        if (this.writerDeleted != null) {
                            this.writerDeleted.println(record.getRecordId());
                        }
                    } else {
                        this.writerChanged.write(patchedRecord);
                    }
                }
                if (this.out == null) continue;
                this.out.flush();
            }
            catch (MarcException me) {
                System.err.println("Error reading Marc Record: " + me.getMessage());
                return 1;
            }
            catch (IOException me) {
                System.err.println("Error Writing Raw Marc Record: " + me.getMessage());
                return 1;
            }
        }
        if (this.writerAll != null) {
            this.writerAll.close();
        }
        if (this.writerChanged != null) {
            this.writerChanged.close();
        }
        if (this.writerDeleted != null) {
            this.writerDeleted.close();
        }
        return 0;
    }

    private Record patchRecord(RawRecord rawRecord, BufferedReader locationReader, BufferedReader changedlocationReader) {
        boolean patched = false;
        Record record = null;
        String recId = rawRecord.getRecordId();
        if (this.locationFileLine == null) {
            this.locationFileLine = this.getNextLocationLine(locationReader, changedlocationReader);
        }
        while (this.locationFileLine != null && this.compare.compare(this.locationFileLine[0], recId) < 0) {
            this.locationFileLine = this.getNextLocationLine(locationReader, changedlocationReader);
        }
        if (this.locationFileLine != null && this.compare.compare(this.locationFileLine[0], recId) == 0) {
            record = rawRecord.getAsRecord(true, false, "999", "MARC8");
            List<VariableField> fields999 = record.getVariableFields("999");
            while (this.locationFileLine != null && this.compare.compare(this.locationFileLine[0], recId) == 0) {
                patched |= this.patchRecordWithLine(record, fields999, this.locationFileLine);
                this.locationFileLine = this.getNextLocationLine(locationReader, changedlocationReader);
            }
            if (this.handleAllLocs) {
                fields999 = record.getVariableFields("999");
                Iterator<VariableField> fieldIter = fields999.iterator();
                while (fieldIter.hasNext()) {
                    VariableField vf = fieldIter.next();
                    if (vf.getId() != null) continue;
                    record.removeVariableField(vf);
                    fieldIter.remove();
                    patched = true;
                }
            }
        } else if (this.locationFileLine != null && this.compare.compare(this.locationFileLine[0], recId) > 0) {
            if (this.boundWithIds != null && this.boundWithIds.containsKey(recId)) {
                return null;
            }
            if (changedlocationReader == null) {
                return this.placeHolderRecordToDelete;
            }
        }
        return patched ? record : null;
    }

    private String[] getNextLocationLine(BufferedReader locationReader, BufferedReader changedLocationReader) {
        String[] result2;
        String line = null;
        do {
            try {
                line = locationReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (line == null) {
                return null;
            }
            result2 = new String[8];
            String[] first = line.split("\\|", 2);
            result2[0] = first[0];
            result2[1] = first[1].substring(0, 16);
            String[] rest = first[1].substring(17).split("\\|");
            System.arraycopy(rest, 0, result2, 2, 6);
            if (changedLocationReader == null) break;
            while (this.currentLocationID == null || this.compare.compare(this.currentLocationID, result2[0]) < 0) {
                try {
                    this.currentLocationID = changedLocationReader.readLine();
                    if (this.currentLocationID != null) continue;
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } while (!result2[0].equals(this.currentLocationID));
        result2[0] = result2[0].replaceFirst(this.mapPattern, this.mapReplace);
        result2[1] = result2[1].trim();
        return result2;
    }

    private boolean patchRecordWithLine(Record record, List<VariableField> fields999, String[] locationFileLine2) {
        boolean changed = false;
        boolean barcodeFound = false;
        DataField closestMatch = null;
        int minEditDistance = 100;
        for (VariableField f999 : fields999) {
            int curEditDistance;
            Subfield barcode;
            DataField df999 = (DataField)f999;
            List<Subfield> multi_i = null;
            multi_i = df999.getSubfields('i');
            if (multi_i.size() > 1) {
                Subfield first_i = multi_i.get(0);
                Subfield second_i = multi_i.get(1);
                Subfield loc_k = df999.getSubfield('k');
                if (loc_k != null) {
                    if (loc_k.getData().equals(second_i.getData())) {
                        df999.removeSubfield(second_i);
                    } else if (first_i.getData().equals(locationFileLine2[1])) {
                        second_i.setCode('k');
                    }
                    loc_k.setCode('l');
                } else if (second_i.getData().equals(locationFileLine2[1])) {
                    df999.removeSubfield(first_i);
                }
                changed = true;
            }
            if ((barcode = df999.getSubfield('i')) != null && barcode.getData().equals(locationFileLine2[1])) {
                Subfield libraryName;
                barcodeFound = true;
                df999.setId(new Long(1L));
                Subfield curLoc = df999.getSubfield('k');
                Subfield homeLoc = df999.getSubfield('l');
                if (curLoc == null) {
                    if (!locationFileLine2[2].equals(locationFileLine2[3])) {
                        List<Subfield> subfields = df999.getSubfields();
                        int index = 0;
                        for (Subfield sf : subfields) {
                            if (sf.getCode() == 'l') break;
                            ++index;
                        }
                        df999.addSubfield(index, new SubfieldImpl('k', locationFileLine2[2]));
                        changed = true;
                    }
                } else if (!locationFileLine2[2].equals(curLoc.getData())) {
                    if (locationFileLine2[2].equals(locationFileLine2[3])) {
                        df999.removeSubfield(curLoc);
                    } else {
                        curLoc.setData(locationFileLine2[2]);
                    }
                    changed = true;
                }
                if (homeLoc != null && !locationFileLine2[3].equals(homeLoc.getData())) {
                    libraryName = df999.getSubfield('m');
                    String newLibraryName = locationFileLine2[4];
                    homeLoc.setData(locationFileLine2[3]);
                    if (newLibraryName != null && !newLibraryName.equals(libraryName.getData())) {
                        libraryName.setData(newLibraryName);
                    }
                    changed = true;
                }
                if ((libraryName = df999.getSubfield('m')) == null || locationFileLine2[4].equals(libraryName.getData())) continue;
                String newLibraryName = locationFileLine2[4];
                libraryName.setData(newLibraryName);
                changed = true;
                continue;
            }
            if (this.handleAllLocs && locationFileLine2.length >= 8 || !this.handleAllLocs || barcodeFound || barcode == null || (curEditDistance = MarcPatcher.getLevenshteinDistance(barcode.getData(), locationFileLine2[1])) >= minEditDistance) continue;
            minEditDistance = curEditDistance;
            closestMatch = df999;
        }
        if (!(barcodeFound || closestMatch == null && locationFileLine2.length < 8)) {
            DataField df = this.factory.newDataField();
            df.addSubfield(new SubfieldImpl('a', closestMatch != null ? closestMatch.getSubfield('a').getData() : locationFileLine2[7]));
            df.addSubfield(new SubfieldImpl('w', closestMatch != null ? closestMatch.getSubfield('w').getData() : locationFileLine2[6]));
            df.addSubfield(new SubfieldImpl('i', locationFileLine2[1]));
            if (!locationFileLine2[2].equals(locationFileLine2[3])) {
                df.addSubfield(new SubfieldImpl('k', locationFileLine2[2]));
            }
            df.addSubfield(new SubfieldImpl('l', locationFileLine2[3]));
            df.addSubfield(new SubfieldImpl('m', locationFileLine2[4]));
            df.addSubfield(new SubfieldImpl('t', closestMatch != null ? closestMatch.getSubfield('t').getData() : locationFileLine2[5]));
            df.setId(new Long(2L));
            df.setTag(closestMatch != null ? closestMatch.getTag() : "999");
            df.setIndicator1(closestMatch != null ? (char)closestMatch.getIndicator1() : (char)' ');
            df.setIndicator2(closestMatch != null ? (char)closestMatch.getIndicator2() : (char)' ');
            record.addVariableField(df);
            changed = true;
        }
        return changed;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static void main(String[] args2) throws FileNotFoundException {
        MarcPatcher marcPatcher = null;
        Object pOut = null;
        String inputFile = args2[0];
        String locationFile = null;
        String boundWithFile = null;
        String changedLocationFile = null;
        String changedFile = null;
        boolean changesOnly = false;
        boolean handleAllLocs = false;
        String outputFile = null;
        for (int i = 1; i < args2.length; ++i) {
            if (args2[i].endsWith(".txt") && locationFile == null) {
                locationFile = args2[i];
                continue;
            }
            if (args2[i].contains("BoundWithIds") && locationFile != null) {
                boundWithFile = args2[i];
                continue;
            }
            if (args2[i].endsWith(".txt") && locationFile != null) {
                changedLocationFile = args2[i];
                continue;
            }
            if (args2[i].equals("handleAllLocs")) {
                handleAllLocs = true;
                continue;
            }
            if (args2[i].equals("changesOnly")) {
                changesOnly = true;
                continue;
            }
            if (args2[i].endsWith(".mrc") && changedFile == null) {
                changedFile = args2[i];
                continue;
            }
            if (!args2[i].endsWith(".mrc") || changedFile == null) continue;
            outputFile = args2[i];
        }
        try {
            pOut = changesOnly ? (changedFile != null ? new PrintStream(new FileOutputStream(new File(changedFile))) : System.out) : (outputFile != null && outputFile.startsWith("none") ? null : (outputFile != null ? new PrintStream(new FileOutputStream(new File(outputFile))) : System.out));
            marcPatcher = new MarcPatcher(inputFile, locationFile, changedLocationFile, boundWithFile, changedFile, (PrintStream)pOut, handleAllLocs);
            marcPatcher.initLocal();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        int exitCode = marcPatcher.handleAll();
        if (pOut != null) {
            ((PrintStream)pOut).flush();
        }
        System.exit(exitCode);
    }
}

