/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Map;
import org.marc4j.marc.Record;
import org.marc4j.util.DiffColorize;
import org.marc4j.util.MarcPatcher;
import org.marc4j.util.RawRecord;
import org.marc4j.util.RawRecordReader;
import org.marc4j.util.StringNaturalCompare;

public class MarcDiff {
    static boolean verbose = false;
    static boolean noCompare = false;
    static boolean cntOnly = false;
    static String writeDifferentRecords = null;
    static String color = null;
    static String[] colors = null;
    static int cntMissing = 0;
    static int cntNew = 0;
    static int cntBoth = 0;
    static int cntDiffRough = 0;
    static int cntDiffFine = 0;
    static int cntSameWhenNormalized = 0;
    static int cntSameWhenLigature = 0;
    static int cntDiffLeaderOnly = 0;
    static int cntDiffLeaderLengthOnly = 0;
    static int cntMissingFields = 0;
    static int cntNewFields = 0;
    static int cntMissingFieldsOnly = 0;
    static int cntNewFieldsOnly = 0;
    static int cntMissingAndNewFieldsOnly = 0;
    static int cntNumSignificantDiff = 0;
    static int fixCnt = 0;

    public static void main(String[] args2) {
        int i = 0;
        if (args2.length == 0) {
            MarcDiff.usage(null, 0);
        }
        while (i < args2.length && args2[i].startsWith("-") && args2[i].length() > 1) {
            if (args2[i].equals("-v")) {
                verbose = true;
                System.err.println("Verbose = true");
                ++i;
                continue;
            }
            if (args2[i].startsWith("-mrc")) {
                writeDifferentRecords = args2[0].substring(1);
                ++i;
                continue;
            }
            if (args2[i].startsWith("-color")) {
                color = args2[++i];
                colors = color.split(":");
                ++i;
                continue;
            }
            if (args2[i].startsWith("-nc")) {
                noCompare = true;
                ++i;
                continue;
            }
            if (args2[i].startsWith("-cnt")) {
                cntOnly = true;
                ++i;
                continue;
            }
            if (args2[i].startsWith("-usage")) {
                MarcDiff.usage(null, 0);
                continue;
            }
            MarcDiff.usage("Unknown command-line option" + args2[i], 1);
        }
        if (i + 1 >= args2.length) {
            System.err.println("Error: Must provide two files for program to diff ");
            System.exit(1);
        }
        if (i + 2 < args2.length) {
            System.err.println("Error: Must provide no more than two files for program to diff ");
            System.exit(1);
        }
        String fileStr1 = args2[i];
        File file1 = new File(fileStr1);
        String fileStr2 = args2[i + 1];
        File file2 = new File(fileStr2);
        RawRecordReader reader1 = null;
        if (fileStr1.equals("-") && fileStr2.equals("-")) {
            System.err.println("Error: Both input files mapped from stdin");
            System.exit(1);
        }
        if (fileStr1.equals("-")) {
            reader1 = new RawRecordReader(System.in);
        } else {
            try {
                reader1 = new RawRecordReader(new FileInputStream(file1));
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: Opening input file: " + file2.getAbsolutePath());
                System.exit(1);
            }
        }
        RawRecordReader reader2 = null;
        if (fileStr2.equals("-")) {
            reader2 = new RawRecordReader(System.in);
        } else {
            try {
                reader2 = new RawRecordReader(new FileInputStream(file2));
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: Opening input file: " + file2.getAbsolutePath());
                System.exit(1);
            }
        }
        RawRecord rec1 = null;
        RawRecord rec2 = null;
        StringNaturalCompare comp = new StringNaturalCompare();
        try {
            if (reader1.hasNext()) {
                rec1 = reader1.next();
            }
            if (reader2.hasNext()) {
                rec2 = reader2.next();
            }
            while (rec1 != null && rec2 != null) {
                int compVal;
                int n = compVal = noCompare ? 0 : comp.compare(rec1.getRecordId(), rec2.getRecordId());
                if (compVal == 0) {
                    byte[] rec2bytes;
                    byte[] rec1bytes = rec1.getRecordBytes();
                    if (!Arrays.equals(rec1bytes, rec2bytes = rec2.getRecordBytes())) {
                        MarcDiff.writeRecord(writeDifferentRecords, verbose, rec1, rec2);
                        ++cntDiffRough;
                    }
                    if (cntDiffRough != cntDiffFine + fixCnt) {
                        boolean fixit = false;
                        int length = Math.min(rec1bytes.length, rec2bytes.length);
                        for (int r1 = 0; r1 < length; ++r1) {
                            if (rec1bytes[r1] == rec2bytes[r1]) continue;
                            fixit = true;
                        }
                        if (rec1bytes.length != rec2bytes.length) {
                            fixit = true;
                        }
                        Record r1 = rec1.getAsRecord(true, true, "999", "MARC8");
                        Record r2 = rec2.getAsRecord(true, true, "999", "MARC8");
                        String str1 = r1.toString();
                        String str2 = r2.toString();
                        if (fixit) {
                            ++fixCnt;
                        }
                    }
                    rec1 = reader1.hasNext() ? reader1.next() : null;
                    rec2 = reader2.hasNext() ? reader2.next() : null;
                    ++cntBoth;
                    continue;
                }
                if (compVal < 0) {
                    MarcDiff.writeRecord(writeDifferentRecords, verbose, rec1, null);
                    rec1 = reader1.hasNext() ? reader1.next() : null;
                    ++cntMissing;
                    continue;
                }
                if (compVal <= 0) continue;
                MarcDiff.writeRecord(writeDifferentRecords, verbose, null, rec2);
                rec2 = reader2.hasNext() ? reader2.next() : null;
                ++cntNew;
            }
            while (rec1 != null) {
                MarcDiff.writeRecord(writeDifferentRecords, verbose, rec1, null);
                rec1 = reader1.hasNext() ? reader1.next() : null;
                ++cntMissing;
            }
            while (rec2 != null) {
                MarcDiff.writeRecord(writeDifferentRecords, verbose, null, rec2);
                rec2 = reader2.hasNext() ? reader2.next() : null;
                ++cntNew;
            }
        }
        catch (IOException ioe) {
            System.err.println("Error: Trouble writing to stdout, can this even happen?");
        }
        if (cntOnly) {
            System.out.println("" + cntMissing + " records in file1 but not in file2");
            System.out.println("" + cntNew + " records in file2 but not in file1");
            System.out.println("" + cntBoth + " records in both files");
            System.out.println("" + (cntBoth - (cntDiffFine + cntMissingFieldsOnly + cntNewFieldsOnly + cntMissingAndNewFieldsOnly)) + " are the same in both files");
            System.out.println("" + cntMissingFields + " have missing fields");
            System.out.println("  " + cntMissingFieldsOnly + " of those are otherwise are the same");
            System.out.println("" + cntNewFields + " have new fields");
            System.out.println("  " + cntNewFieldsOnly + " of those are otherwise are the same");
            System.out.println("  " + cntMissingAndNewFieldsOnly + " have both missing fields and new fields but are otherwise are the same");
            System.out.println("" + cntDiffRough + " are different");
            System.out.println("" + cntDiffFine + " have different field contents");
            System.out.println("  " + cntDiffLeaderLengthOnly + " of these only differ in the lengths in the leader");
            System.out.println("  " + cntDiffLeaderOnly + " of these only differ in the other fields in the leader");
            System.out.println("  " + cntSameWhenNormalized + " of these are the same when accented characters are normalized");
            System.out.println("  " + cntSameWhenLigature + " of these are the same when two part combining characters are fixed");
            System.out.println("  " + cntNumSignificantDiff + " have significant differences");
            System.out.println("  " + (cntDiffRough - cntDiffFine) + " have no detectable differences");
        }
    }

    private static void usage(String error, int exitcode) {
        if (error != null) {
            System.err.println("Error: " + error);
        }
        System.err.println("Usage: marcdiff  [-options] <file1.mrc> <file2.mrc>");
        System.err.println("       -v      Write verbose output");
        System.err.println("       -mrc    Write out binary MARC records that are different from one file to the other");
        System.err.println("       -mrc1   Write out binary MARC records from the first file only that are new or different from the corresponding record in file 2");
        System.err.println("       -mrc2   Write out binary MARC records from the second file only that are new or different from the corresponding record in file 1");
        System.err.println("       -nc     Simply compare files based on the position of binary MARC records, rather than checking for correspondence of record ids");
        System.err.println("       -cnt    Simply count the differences between the files without showing them");
        System.err.println("       -usage = this message");
        System.exit(exitcode);
    }

    private static void writeRecord(String writeDifferentRecords, boolean verbose, RawRecord rec1, RawRecord rec2) throws IOException {
        if (writeDifferentRecords != null) {
            if (rec1 != null && rec2 != null) {
                if (writeDifferentRecords.equals("mrc") || writeDifferentRecords.startsWith("mrc2")) {
                    System.out.write(rec2.getRecordBytes());
                } else if (writeDifferentRecords.startsWith("mrc1")) {
                    System.out.write(rec1.getRecordBytes());
                }
            } else if (writeDifferentRecords.contains("1") && rec1 != null) {
                System.out.write(rec1.getRecordBytes());
            } else if (writeDifferentRecords.contains("2") && rec2 != null) {
                System.out.write(rec2.getRecordBytes());
            }
            System.out.flush();
        } else if (rec1 != null && rec2 != null) {
            Record r1 = rec1.getAsRecord(true, true, "999", "MARC8");
            Record r2 = rec2.getAsRecord(true, true, "999", "MARC8");
            String str1 = r1.toString();
            String str2 = r2.toString();
            if (!verbose && !cntOnly) {
                System.out.println("record with id: " + rec1.getRecordId() + " different in file1 and file2");
            }
            if (!str1.equals(str2)) {
                if (!cntOnly) {
                    MarcDiff.showDiffs(System.out, str1, str2, verbose, null);
                } else {
                    MarcDiff.cntDiffs(str1, str2, verbose);
                }
            }
        } else if (rec1 != null) {
            if (!cntOnly) {
                System.out.println("record with id: " + rec1.getRecordId() + " found in file1 but not in file2");
            }
            if (verbose && !cntOnly) {
                Record rec = rec1.getAsRecord(true, true, "999", "MARC8");
                System.out.println(rec.toString());
            }
        } else {
            if (!cntOnly) {
                System.out.println("record with id: " + rec2.getRecordId() + " found in file2 but not in file1");
            }
            if (verbose && !cntOnly) {
                Record rec = rec2.getAsRecord(true, true, "999", "MARC8");
                System.out.println(rec.toString());
            }
        }
    }

    private static void cntDiffs(String str1, String str2, boolean verbose) {
        boolean incrementStillDiffWhenNormalized = false;
        boolean incrementStillDiffWhenLigature = false;
        boolean incrementDiffLeaderImpt = false;
        boolean incrementDiffLeaderLength = false;
        boolean incrementNewFields = false;
        boolean incrementMissingFields = false;
        boolean incrementDiff = false;
        String[] str1Lines = str1.split("\n");
        String[] str2Lines = str2.split("\n");
        int index1 = 0;
        int index2 = 0;
        while (index1 < str1Lines.length && index2 < str2Lines.length) {
            if (str1Lines[index1].equals(str2Lines[index2])) {
                ++index1;
                ++index2;
                continue;
            }
            if (MarcDiff.hasMatch(str2Lines, index2 + 1, str1Lines[index1])) {
                incrementNewFields = true;
                ++index2;
                continue;
            }
            if (MarcDiff.hasMatch(str1Lines, index1 + 1, str2Lines[index2])) {
                incrementMissingFields = true;
                ++index1;
                continue;
            }
            String s1 = str1Lines[index1];
            String s2 = str2Lines[index2];
            String s1Norm = Normalizer.normalize(s1, Normalizer.Form.NFC);
            String s2Norm = Normalizer.normalize(s2, Normalizer.Form.NFC);
            String s1Ligature = MarcDiff.ligatureNormalize(s1Norm);
            String s2Ligature = MarcDiff.ligatureNormalize(s2Norm);
            if (s1.startsWith("LEADER") && s2.startsWith("LEADER")) {
                String s2Leader;
                String s1Leader = s1.replaceFirst("(LEADER )(.....)(.......)(.....)(.......)", "$1XXXXX$3XXXXX$5");
                if (!s1Leader.equals(s2Leader = s2.replaceFirst("(LEADER )(.....)(.......)(.....)(.......)", "$1XXXXX$3XXXXX$5"))) {
                    incrementDiffLeaderImpt = true;
                } else {
                    incrementDiffLeaderLength = true;
                }
            } else {
                incrementDiff = true;
                if (!s1Norm.equals(s2Norm)) {
                    incrementStillDiffWhenNormalized = true;
                }
                if (!s1Ligature.equals(s2Ligature)) {
                    incrementStillDiffWhenLigature = true;
                }
            }
            ++index1;
            ++index2;
        }
        while (index1 < str1Lines.length) {
            incrementMissingFields = true;
            ++index1;
        }
        while (index2 < str2Lines.length) {
            incrementNewFields = true;
            ++index2;
        }
        if (incrementDiff && incrementStillDiffWhenNormalized && incrementStillDiffWhenLigature) {
            if (verbose) {
                MarcDiff.showDiffs(System.out, str1, str2, verbose, null);
            }
            ++cntNumSignificantDiff;
        }
        if (incrementDiff && !incrementStillDiffWhenNormalized) {
            ++cntSameWhenNormalized;
        }
        if (incrementDiff && incrementStillDiffWhenNormalized && !incrementStillDiffWhenLigature) {
            ++cntSameWhenLigature;
        }
        if (incrementDiffLeaderImpt && !incrementMissingFields && !incrementNewFields) {
            ++cntDiffLeaderOnly;
        }
        if (incrementDiffLeaderLength && !incrementDiff && !incrementMissingFields && !incrementNewFields) {
            ++cntDiffLeaderLengthOnly;
        }
        if (!incrementDiff && incrementMissingFields && !incrementNewFields) {
            ++cntMissingFieldsOnly;
        }
        if (!incrementDiff && incrementNewFields && !incrementMissingFields) {
            ++cntNewFieldsOnly;
        }
        if (!incrementDiff && incrementMissingFields && incrementNewFields) {
            ++cntMissingAndNewFieldsOnly;
        }
        if (incrementMissingFields) {
            ++cntMissingFields;
        }
        if (incrementNewFields) {
            ++cntNewFields;
        }
        if (incrementDiff) {
            ++cntDiffFine;
        } else {
            ++index2;
        }
        if (!(incrementDiff || incrementMissingFields || incrementNewFields || incrementDiffLeaderImpt || incrementDiffLeaderLength)) {
            incrementDiff = !incrementDiff;
        }
    }

    private static String ligatureNormalize(String str) {
        while (str.matches("(.*)\ufe20(.)\ufe21(.*)")) {
            str = str.replaceFirst("(.*)\ufe20(.)\ufe21(.*)", "$1\u0361$2$3");
        }
        while (str.matches("(.*)\ufe22(.)\ufe23(.*)")) {
            str = str.replaceFirst("(.*)\ufe22(.)\ufe23(.*)", "$1\u0360$2$3");
        }
        return str;
    }

    public static void showDiffs(PrintStream out, String strNorm, String strPerm, boolean verbose, Map<Character, String> map) {
        if (strNorm != null) {
            String[] normLines = strNorm.split("\n");
            String[] permLines = strPerm.split("\n");
            int index1 = 0;
            int index2 = 0;
            while (index1 < normLines.length && index2 < permLines.length) {
                if (normLines[index1].equals(permLines[index2])) {
                    if (verbose) {
                        out.println("   " + normLines[index1]);
                    }
                    ++index1;
                    ++index2;
                    continue;
                }
                if (MarcDiff.hasMatch(permLines, index2 + 1, normLines[index1])) {
                    out.println("+++" + permLines[index2]);
                    ++index2;
                    continue;
                }
                if (MarcDiff.hasMatch(normLines, index1 + 1, permLines[index2])) {
                    out.println("---" + normLines[index1]);
                    ++index1;
                    continue;
                }
                String s1 = normLines[index1];
                String s2 = permLines[index2];
                String s1Norm = Normalizer.normalize(s1, Normalizer.Form.NFC);
                String s2Norm = Normalizer.normalize(s2, Normalizer.Form.NFC);
                String s1Ligature = MarcDiff.ligatureNormalize(s1Norm);
                String s2Ligature = MarcDiff.ligatureNormalize(s2Norm);
                String label1 = ">>>";
                String label2 = "<<<";
                if (s1.startsWith("LEADER") && s2.startsWith("LEADER")) {
                    String s2Leader;
                    String s1Leader = s1.replaceFirst("(LEADER )(.....)(.......)(.....)(.......)", "$1XXXXX$3XXXXX$5");
                    if (s1Leader.equals(s2Leader = s2.replaceFirst("(LEADER )(.....)(.......)(.....)(.......)", "$1XXXXX$3XXXXX$5"))) {
                        label1 = " > ";
                        label2 = " < ";
                    }
                } else if (s1Norm.equals(s2Norm)) {
                    label1 = " > ";
                    label2 = " < ";
                } else if (s1Ligature.equals(s2Ligature)) {
                    label1 = " >>";
                    label2 = " <<";
                } else {
                    label1 = ">>>";
                    label2 = "<<<";
                }
                if (color != null) {
                    DiffColorize.ReturnStructure rs = DiffColorize.stringSimilarity(normLines[index1], permLines[index2], colors[0], colors[1], colors.length > 3 ? colors[2] : colors[0], colors.length > 3 ? colors[3] : colors[1], 50);
                    out.println(label2 + rs.s1);
                    out.println(label1 + rs.s2);
                } else {
                    out.println(label2 + normLines[index1]);
                    out.println(label1 + permLines[index2]);
                }
                ++index1;
                ++index2;
            }
            while (index1 < normLines.length) {
                out.println("---" + normLines[index1]);
                ++index1;
            }
            while (index2 < permLines.length) {
                out.println("+++" + permLines[index2]);
                ++index2;
            }
        } else {
            String[] permLines = strPerm.split("\n");
            for (int i = 0; i < permLines.length; ++i) {
                if (!verbose) continue;
                out.println("   " + permLines[i]);
            }
        }
    }

    private static boolean hasMatch(String[] lines, int index, String string) {
        int i;
        for (i = index; i < lines.length; ++i) {
            if (!lines[i].equals(string)) continue;
            return true;
        }
        for (i = index; i < lines.length; ++i) {
            if (!string.substring(0, 3).equals(lines[i].substring(0, 3))) continue;
            int lDist = MarcPatcher.getLevenshteinDistance(lines[i], string);
            int minLen = Math.min(lines[i].length(), string.length());
            if (lDist >= 10 && !((double)lDist / (0.0 + (double)minLen) < 0.4)) continue;
            return true;
        }
        return false;
    }
}

