/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.marc4j.MarcError;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.ControlFieldImpl;
import org.marc4j.marc.impl.Verifier;

public class RecordImpl
implements Record {
    private static final long serialVersionUID = -4751021372496524250L;
    private Long id;
    private Leader leader;
    protected List<ControlField> controlFields = new ArrayList<ControlField>();
    protected List<DataField> dataFields = new ArrayList<DataField>();
    protected List<MarcError> errors = null;
    protected int maxSeverity;
    private String type;

    @Override
    public void setType(String type2) {
        this.type = type2;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setLeader(Leader leader) {
        this.leader = leader;
    }

    @Override
    public Leader getLeader() {
        return this.leader;
    }

    @Override
    public void addVariableField(VariableField field) {
        String tag = field.getTag();
        if (field instanceof ControlField) {
            ControlField controlField = (ControlField)field;
            if (!Verifier.isLeaderField(tag)) {
                if (Verifier.isControlNumberField(tag)) {
                    if (Verifier.hasControlNumberField(this.controlFields)) {
                        this.controlFields.set(0, controlField);
                    } else {
                        this.controlFields.add(0, controlField);
                    }
                } else {
                    this.controlFields.add(controlField);
                }
            }
        } else {
            this.dataFields.add((DataField)field);
        }
    }

    @Override
    public void removeVariableField(VariableField field) {
        String tag = field.getTag();
        if (Verifier.isControlField(tag)) {
            this.controlFields.remove(field);
        } else {
            this.dataFields.remove(field);
        }
    }

    @Override
    public ControlField getControlNumberField() {
        if (Verifier.hasControlNumberField(this.controlFields)) {
            return this.controlFields.get(0);
        }
        return null;
    }

    @Override
    public List<ControlField> getControlFields() {
        return this.controlFields;
    }

    @Override
    public List<DataField> getDataFields() {
        return this.dataFields;
    }

    @Override
    public VariableField getVariableField(String tag) {
        List<VariableField> fields2 = this.getVariableFieldsWithLeader();
        for (VariableField field : fields2) {
            if (!this.fieldMatches(field, tag)) continue;
            return field;
        }
        return null;
    }

    private boolean fieldMatches(VariableField field, String tag) {
        DataField df;
        Subfield link;
        if (field.getTag().equals(tag)) {
            return true;
        }
        return tag.startsWith("LNK") && field.getTag().equals("880") && (link = (df = (DataField)field).getSubfield('6')) != null && link.getData().equals(tag.substring(3));
    }

    @Override
    public List<VariableField> getVariableFields(String tag) {
        ArrayList<VariableField> result2 = new ArrayList<VariableField>();
        List<VariableField> fields2 = this.getVariableFieldsWithLeader();
        for (VariableField field : fields2) {
            if (!this.fieldMatches(field, tag)) continue;
            result2.add(field);
        }
        return result2;
    }

    @Override
    public List<VariableField> getVariableFields() {
        ArrayList<VariableField> fields2 = new ArrayList<VariableField>();
        fields2.addAll(this.controlFields);
        fields2.addAll(this.dataFields);
        return fields2;
    }

    @Override
    public List<VariableField> getVariableFieldsWithLeader() {
        ArrayList<VariableField> fields2 = new ArrayList<VariableField>();
        ControlFieldImpl leaderAsField = new ControlFieldImpl("000", this.getLeader().toString());
        fields2.add(leaderAsField);
        fields2.addAll(this.controlFields);
        fields2.addAll(this.dataFields);
        return fields2;
    }

    @Override
    public String getControlNumber() {
        ControlField f = this.getControlNumberField();
        if (f == null || f.getData() == null) {
            return null;
        }
        return f.getData();
    }

    @Override
    public List<VariableField> getVariableFields(String[] tags) {
        ArrayList<VariableField> result2 = new ArrayList<VariableField>();
        List<VariableField> fields2 = this.getVariableFieldsWithLeader();
        block0: for (VariableField field : fields2) {
            for (String tag : tags) {
                if (!this.fieldMatches(field, tag)) continue;
                result2.add(field);
                continue block0;
            }
        }
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LEADER ");
        sb.append(this.getLeader().toString());
        sb.append('\n');
        for (VariableField field : this.getVariableFields()) {
            sb.append(field.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<VariableField> find(String pattern) {
        ArrayList<VariableField> result2 = new ArrayList<VariableField>();
        for (VariableField variableField : this.controlFields) {
            if (!variableField.find(pattern)) continue;
            result2.add(variableField);
        }
        for (VariableField variableField : this.dataFields) {
            if (!variableField.find(pattern)) continue;
            result2.add(variableField);
        }
        return result2;
    }

    @Override
    public List<VariableField> find(String tag, String pattern) {
        ArrayList<VariableField> result2 = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result2.add(field);
        }
        return result2;
    }

    @Override
    public List<VariableField> find(String[] tag, String pattern) {
        ArrayList<VariableField> result2 = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result2.add(field);
        }
        return result2;
    }

    public boolean hasMatch(String[] tag, String pattern) {
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void addError(String field, String subfield, int severity, String message) {
        if (this.errors == null) {
            this.errors = new LinkedList<MarcError>();
        }
        this.errors.add(new MarcError(field, subfield, severity, message));
        if (severity > this.maxSeverity) {
            this.maxSeverity = severity;
        }
    }

    @Override
    public void addErrors(List<MarcError> newErrors) {
        if (newErrors == null || newErrors.size() == 0) {
            return;
        }
        if (this.errors == null) {
            this.errors = new LinkedList<MarcError>();
        }
        for (MarcError err : newErrors) {
            this.errors.add(err);
            if (err.severity <= this.maxSeverity) continue;
            this.maxSeverity = err.severity;
        }
    }

    @Override
    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    @Override
    public List<MarcError> getErrors() {
        return this.errors;
    }
}

