/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.marc4j.marc.DataField;
import org.marc4j.marc.IllegalAddException;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.SubfieldImpl;
import org.marc4j.marc.impl.VariableFieldImpl;

public class DataFieldImpl
extends VariableFieldImpl
implements DataField {
    private static final long serialVersionUID = -9010227887211125868L;
    private Long id;
    private char ind1;
    private char ind2;
    private final List<Subfield> subfields = new ArrayList<Subfield>();

    DataFieldImpl() {
    }

    public DataFieldImpl(String tag, char ind1, char ind2) {
        super(tag);
        this.setIndicator1(ind1);
        this.setIndicator2(ind2);
    }

    @Override
    public void setIndicator1(char ind1) {
        this.ind1 = ind1;
    }

    @Override
    public char getIndicator1() {
        return this.ind1;
    }

    @Override
    public void setIndicator2(char ind2) {
        this.ind2 = ind2;
    }

    @Override
    public char getIndicator2() {
        return this.ind2;
    }

    @Override
    public void addSubfield(Subfield subfield) {
        if (!(subfield instanceof SubfieldImpl)) {
            throw new IllegalAddException("Supplied Subfield isn't an instance of SubfieldImpl");
        }
        this.subfields.add(subfield);
    }

    @Override
    public void addSubfield(int index, Subfield subfield) {
        this.subfields.add(index, subfield);
    }

    @Override
    public void removeSubfield(Subfield subfield) {
        this.subfields.remove(subfield);
    }

    @Override
    public List<Subfield> getSubfields() {
        return this.subfields;
    }

    @Override
    public List<Subfield> getSubfields(char code) {
        ArrayList<Subfield> result2 = new ArrayList<Subfield>();
        for (Subfield sf : this.subfields) {
            if (sf.getCode() != code) continue;
            result2.add(sf);
        }
        return result2;
    }

    @Override
    public List<Subfield> getSubfields(String sfSpec) {
        ArrayList<Subfield> sfData = new ArrayList<Subfield>();
        if (sfSpec == null || sfSpec.length() == 0) {
            for (Subfield sf : this.getSubfields()) {
                sfData.add(sf);
            }
        } else if (sfSpec.contains("[")) {
            Pattern sfPattern = null;
            try {
                sfPattern = Pattern.compile(sfSpec);
                for (Subfield sf : this.getSubfields()) {
                    Matcher m = sfPattern.matcher("" + sf.getCode());
                    if (!m.matches()) continue;
                    sfData.add(sf);
                }
            }
            catch (PatternSyntaxException details) {
                throw new PatternSyntaxException(details.getDescription() + " in subfield pattern " + sfSpec, details.getPattern(), details.getIndex());
            }
        } else {
            for (Subfield sf : this.getSubfields()) {
                if (!sfSpec.contains(String.valueOf(sf.getCode()))) continue;
                sfData.add(sf);
            }
        }
        return sfData;
    }

    @Override
    public String getSubfieldsAsString(String sfSpec) {
        List<Subfield> sfList = this.getSubfields(sfSpec);
        if (sfList.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Subfield sf : sfList) {
            buf.append(sf.getData());
        }
        return buf.toString();
    }

    @Override
    public Subfield getSubfield(char code) {
        for (Subfield sf : this.subfields) {
            if (sf.getCode() != code) continue;
            return sf;
        }
        return null;
    }

    @Override
    public boolean find(String pattern) {
        for (Subfield sf : this.subfields) {
            if (!sf.find(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(' ');
        sb.append(this.getIndicator1());
        sb.append(this.getIndicator2());
        for (Subfield sf : this.subfields) {
            sb.append(sf.toString());
        }
        return sb.toString();
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }
}

