/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.lang.reflect.Constructor;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Vector;
import org.marc4j.ConverterErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTable;
import org.marc4j.converter.impl.CodeTableInterface;
import org.marc4j.converter.impl.FixDoubleWidth;
import org.marc4j.converter.impl.UnicodeUtils;
import org.marc4j.converter.impl.UnimarcCommon;
import org.marc4j.converter.impl.UnimarcConstants;

public class UnimarcToUnicode
extends CharConverter
implements UnimarcConstants {
    protected CodeTableInterface ct = this.loadGeneratedTable();
    protected CodeTracker altCodeTracker = null;
    protected boolean translateNCR = false;
    protected boolean composeUnicode = false;
    protected ConverterErrorHandler errorHandler = null;

    public boolean shouldTranslateNCR() {
        return this.translateNCR;
    }

    public void setTranslateNCR(boolean translateNCR) {
        this.translateNCR = translateNCR;
    }

    public boolean shouldComposeUnicode() {
        return this.composeUnicode;
    }

    public void setComposeUnicode(boolean composeUnicode) {
        this.composeUnicode = composeUnicode;
    }

    public UnimarcToUnicode() {
    }

    public UnimarcToUnicode(ConverterErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private CodeTableInterface loadGeneratedTable() {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.UnimarcCodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object ct = cons.newInstance(new Object[0]);
            return (CodeTableInterface)ct;
        }
        catch (Exception e) {
            return new CodeTable(this.getClass().getResourceAsStream("resources/unimarc.xml"));
        }
    }

    private void checkMode(char[] data2, CodeTracker cdt) {
        block18: while (cdt.offset < data2.length) {
            cdt.multibyte = false;
            if (data2[cdt.offset] == '\u000f') {
                cdt.g0 = cdt.workingG0;
                ++cdt.offset;
                cdt.multibyte = cdt.isG0multibyte;
                continue;
            }
            if (data2[cdt.offset] == '\u000e') {
                cdt.g0 = cdt.workingG1;
                ++cdt.offset;
                cdt.multibyte = cdt.isG1multibyte;
                continue;
            }
            if (!UnimarcToUnicode.isEscape(data2[cdt.offset])) break;
            block0 : switch (data2[cdt.offset + 1]) {
                case '~': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.g1 = cdt.workingG1;
                    cdt.offset += 2;
                    cdt.multibyte = cdt.isG1multibyte;
                    continue block18;
                }
                case 'n': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.g0 = cdt.workingG2;
                    cdt.offset += 2;
                    cdt.multibyte = cdt.isG2multibyte;
                    continue block18;
                }
                case '}': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.g1 = cdt.workingG2;
                    cdt.offset += 2;
                    cdt.multibyte = cdt.isG2multibyte;
                    continue block18;
                }
                case 'o': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.g0 = cdt.workingG3;
                    cdt.offset += 2;
                    cdt.multibyte = cdt.isG3multibyte;
                    continue block18;
                }
                case '|': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.g1 = cdt.workingG3;
                    cdt.offset += 2;
                    cdt.multibyte = cdt.isG3multibyte;
                    continue block18;
                }
                case '(': 
                case ',': {
                    if (cdt.offset + 3 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.workingG0 = data2[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.isG0multibyte = false;
                    continue block18;
                }
                case ')': 
                case '-': {
                    if (cdt.offset + 3 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.workingG1 = data2[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.isG1multibyte = false;
                    continue block18;
                }
                case '*': 
                case '.': {
                    if (cdt.offset + 3 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.workingG2 = data2[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.isG2multibyte = false;
                    continue block18;
                }
                case '+': 
                case '/': {
                    if (cdt.offset + 3 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.workingG3 = data2[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.isG3multibyte = false;
                    continue block18;
                }
                case '$': {
                    if (cdt.offset + 2 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    switch (data2[cdt.offset + 2]) {
                        case ',': {
                            if (cdt.offset + 4 >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                } else {
                                    throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                }
                            }
                            cdt.workingG0 = data2[cdt.offset + 3];
                            cdt.offset += 4;
                            cdt.isG0multibyte = true;
                            break block0;
                        }
                        case ')': 
                        case '-': {
                            if (cdt.offset + 4 >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                } else {
                                    throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                }
                            }
                            cdt.workingG1 = data2[cdt.offset + 3];
                            cdt.offset += 4;
                            cdt.isG1multibyte = true;
                            break block0;
                        }
                        case '*': 
                        case '.': {
                            if (cdt.offset + 4 >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                } else {
                                    throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                }
                            }
                            cdt.workingG2 = data2[cdt.offset + 3];
                            cdt.offset += 4;
                            cdt.isG2multibyte = true;
                            break block0;
                        }
                        case '+': 
                        case '/': {
                            if (cdt.offset + 4 >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                } else {
                                    throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                }
                            }
                            cdt.workingG3 = data2[cdt.offset + 3];
                            cdt.offset += 4;
                            cdt.isG3multibyte = true;
                            break block0;
                        }
                    }
                    if (cdt.offset + 3 >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        } else {
                            throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        }
                    }
                    cdt.workingG0 = data2[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.isG0multibyte = true;
                }
            }
            ++cdt.offset;
            if (this.errorHandler != null) {
                this.errorHandler.addError(2, "Unknown character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                continue;
            }
            throw new MarcException("Unknown character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
        }
    }

    public void resetDefaultGX() {
        this.altCodeTracker = null;
    }

    public void setDefaultGX(String altG0Code, String altG1Code, String altG2Code, String altG3Code) {
        this.altCodeTracker = new CodeTracker();
        int iso = UnimarcCommon.determineCharSet(altG0Code);
        if (iso > 0) {
            this.altCodeTracker.g0 = iso;
            this.altCodeTracker.isG0multibyte = false;
            this.altCodeTracker.workingG0 = iso;
        }
        if ((iso = UnimarcCommon.determineCharSet(altG1Code)) > 0) {
            this.altCodeTracker.g1 = iso;
            this.altCodeTracker.isG1multibyte = false;
            this.altCodeTracker.workingG1 = iso;
        }
        if ((iso = UnimarcCommon.determineCharSet(altG2Code)) > 0) {
            this.altCodeTracker.isG2multibyte = false;
            this.altCodeTracker.workingG2 = iso;
        }
        if ((iso = UnimarcCommon.determineCharSet(altG3Code)) > 0) {
            this.altCodeTracker.isG3multibyte = false;
            this.altCodeTracker.workingG3 = iso;
        }
    }

    @Override
    public String convert(char[] data2) {
        StringBuilder sb = new StringBuilder();
        int len = data2.length;
        CodeTracker cdt = new CodeTracker(this.altCodeTracker);
        this.checkMode(data2, cdt);
        Queue diacritics = new Queue();
        boolean unrecognizedUnicode = false;
        while (cdt.offset < data2.length) {
            if (this.ct.isCombining(data2[cdt.offset], cdt.g0, cdt.g1) && UnimarcToUnicode.hasNext(cdt.offset, len)) {
                while (this.ct.isCombining(data2[cdt.offset], cdt.g0, cdt.g1) && UnimarcToUnicode.hasNext(cdt.offset, len)) {
                    diacritics.put(Character.valueOf(this.getChar(data2[cdt.offset], cdt.g0, cdt.g1)));
                    ++cdt.offset;
                    this.checkMode(data2, cdt);
                }
                char c2 = this.getChar(data2[cdt.offset], cdt.g0, cdt.g1);
                ++cdt.offset;
                this.checkMode(data2, cdt);
                sb.append(c2);
                while (!diacritics.isEmpty()) {
                    char c1 = ((Character)diacritics.get()).charValue();
                    sb.append(c1);
                }
            } else if (cdt.multibyte) {
                sb.append(this.ct.getChar(this.makeMultibyte(new String(data2).substring(cdt.offset, cdt.offset + 4).toCharArray()), cdt.g0));
                cdt.offset += 3;
            } else {
                char c = this.getChar(data2[cdt.offset], cdt.g0, cdt.g1);
                if (c != '\u0000') {
                    sb.append(c);
                } else {
                    String val = UnicodeUtils.convertUnicodeToUnicodeBNF(Character.valueOf(data2[cdt.offset]));
                    if (this.translateNCR) {
                        val = val.substring(0, 3) + '>' + val.substring(3);
                        unrecognizedUnicode = true;
                    }
                    sb.append(val);
                }
                ++cdt.offset;
            }
            if (!UnimarcToUnicode.hasNext(cdt.offset, len)) continue;
            this.checkMode(data2, cdt);
        }
        if (this.translateNCR) {
            UnicodeUtils.convertNCRToUnicode(sb);
            FixDoubleWidth.removeInvalidSecondHalf(sb);
        }
        String dataElement = sb.toString();
        if (unrecognizedUnicode) {
            dataElement = dataElement.replaceAll("<U\\+>", "<U+");
        }
        if (this.shouldComposeUnicode()) {
            return Normalizer.normalize(dataElement, Normalizer.Form.NFC);
        }
        return dataElement;
    }

    private int makeMultibyte(char[] data2) {
        int[] chars = new int[]{data2[0] << 16, data2[1] << 8, data2[2]};
        return chars[0] | chars[1] | chars[2];
    }

    private char getChar(int ch, int g0, int g1) {
        if (ch <= 126) {
            return this.ct.getChar(ch, g0);
        }
        return this.ct.getChar(ch, g1);
    }

    private static boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private static boolean isEscape(int i) {
        return i == 27;
    }

    class CodeTracker {
        int offset = 0;
        int g0 = 64;
        int g1 = 80;
        int workingG0 = 64;
        int workingG1 = 80;
        int workingG2 = 0;
        int workingG3 = 0;
        boolean multibyte = false;
        boolean isG0multibyte = false;
        boolean isG1multibyte = false;
        boolean isG2multibyte = false;
        boolean isG3multibyte = false;

        CodeTracker() {
        }

        CodeTracker(CodeTracker tracker) {
            if (tracker != null) {
                this.g0 = tracker.g0;
                this.g1 = tracker.g1;
                this.workingG0 = tracker.workingG0;
                this.workingG1 = tracker.workingG1;
                this.workingG2 = tracker.workingG2;
                this.workingG3 = tracker.workingG3;
                this.multibyte = tracker.multibyte;
                this.isG0multibyte = tracker.isG0multibyte;
                this.isG1multibyte = tracker.isG1multibyte;
                this.isG2multibyte = tracker.isG2multibyte;
                this.isG3multibyte = tracker.isG3multibyte;
            }
        }

        public String toString() {
            return "Offset: " + this.offset + " G0: " + Integer.toHexString(this.g0) + " G1: " + Integer.toHexString(this.g1) + " Multibyte: " + this.multibyte;
        }
    }

    class Queue
    extends Vector {
        Queue() {
        }

        public Object put(Object item) {
            this.addElement(item);
            return item;
        }

        public Object get() {
            Object obj = this.peek();
            this.removeElementAt(0);
            return obj;
        }

        public Object peek() {
            return this.elementAt(0);
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }
}

