/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.converter.impl.ReverseCodeTable;
import org.marc4j.converter.impl.ReverseCodeTableHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class UnimarcReverseCodeTableHash
extends ReverseCodeTable {
    protected static Hashtable<Character, Hashtable<Integer, char[]>> charsets = null;
    protected static Vector<Character> combining = null;

    @Override
    public boolean isCombining(Character c) {
        return combining.contains(c);
    }

    @Override
    public Hashtable<Integer, char[]> getCharTable(Character c) {
        return charsets.get(c);
    }

    public UnimarcReverseCodeTableHash(InputStream byteStream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(byteStream);
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
            System.err.println("Exception: " + exc);
        }
    }

    public UnimarcReverseCodeTableHash(String filename) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File(filename);
            InputSource src = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
            System.err.println("Exception: " + exc);
        }
    }

    public UnimarcReverseCodeTableHash(URI uri) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            InputSource src = new InputSource(uri.toURL().openStream());
            ReverseCodeTableHandler saxUms = new ReverseCodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            combining = saxUms.getCombiningChars();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
            System.err.println("Exception: " + exc);
        }
    }
}

