/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.util.Collections;
import java.util.Formatter;
import org.marc4j.Marc4jConfig;
import org.marc4j.NCR_FORMAT;

public final class UnicodeUtils {
    private UnicodeUtils() {
    }

    public static void convertNCRToUnicode(StringBuilder buffer) {
        String val;
        int pos = buffer.indexOf("&#x");
        while (pos >= 0 && buffer.length() >= pos + 8 && buffer.charAt(pos + 7) == ';') {
            val = buffer.substring(pos + 3, pos + 7);
            try {
                char ch = (char)Integer.parseInt(val, 16);
                buffer.delete(pos, pos + 8);
                buffer.insert(pos, ch);
            }
            catch (NumberFormatException ch) {
                // empty catch block
            }
            pos = buffer.indexOf("&#x", pos + 1);
        }
        pos = buffer.indexOf("<U+");
        while (pos >= 0 && buffer.length() >= pos + 8 && buffer.charAt(pos + 7) == '>') {
            val = buffer.substring(pos + 3, pos + 7);
            try {
                char ch = (char)Integer.parseInt(val, 16);
                buffer.delete(pos, pos + 8);
                buffer.insert(pos, ch);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pos = buffer.indexOf("<U+", pos + 1);
        }
    }

    public static String convertUnicodeToNCR(Character ch) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String format = Marc4jConfig.getNCR_format() == NCR_FORMAT.MARC8_NCR ? "&#x%04X;" : "<U+%04X>";
        f.format(format, Collections.singletonList(Integer.valueOf(ch.charValue())).toArray());
        return sb.toString();
    }

    public static String convertUnicodeToUnicodeBNF(Character ch) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("<U+%04X>", Collections.singletonList(Integer.valueOf(ch.charValue())).toArray());
        return sb.toString();
    }
}

