/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CodeTableHandler
extends DefaultHandler {
    private HashMap<Integer, HashMap<Integer, Character>> sets;
    private HashMap<Integer, Character> charset;
    private HashMap<Integer, Vector<Integer>> combiningchars;
    private Integer isocode;
    private Integer marc;
    private Character ucs;
    private boolean useAlt = false;
    private boolean iscombining;
    private Vector<Integer> combining;
    private StringBuffer data;
    protected Locator locator;

    public HashMap<Integer, HashMap<Integer, Character>> getCharSets() {
        return this.sets;
    }

    public HashMap<Integer, Vector<Integer>> getCombiningChars() {
        return this.combiningchars;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.charset = new HashMap();
            this.isocode = Integer.valueOf(atts.getValue("ISOcode"), 16);
            this.combining = new Vector();
        } else if (name.equals("marc")) {
            this.data = new StringBuffer();
        } else if (name.equals("codeTables")) {
            this.sets = new HashMap();
            this.combiningchars = new HashMap();
        } else if (name.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (name.equals("alt")) {
            this.data = new StringBuffer();
        } else if (name.equals("isCombining")) {
            this.data = new StringBuffer();
        } else if (name.equals("code")) {
            this.iscombining = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.data != null) {
            this.data.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXParseException {
        if (name.equals("characterSet")) {
            this.sets.put(this.isocode, this.charset);
            this.combiningchars.put(this.isocode, this.combining);
            this.combining = null;
            this.charset = null;
        } else if (name.equals("marc")) {
            this.marc = Integer.valueOf(this.data.toString(), 16);
        } else if (name.equals("ucs")) {
            this.ucs = this.data.length() > 0 ? new Character((char)Integer.parseInt(this.data.toString(), 16)) : null;
        } else if (name.equals("alt")) {
            if (this.useAlt && this.data.length() > 0) {
                this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
                this.useAlt = false;
            }
        } else if (name.equals("code")) {
            if (this.iscombining) {
                this.combining.add(this.marc);
            }
            this.charset.put(this.marc, this.ucs);
        } else if (name.equals("isCombining") && this.data.toString().equals("true")) {
            this.iscombining = true;
        }
        this.data = null;
    }

    public static void main(String[] args2) {
        HashMap<Integer, HashMap<Integer, Character>> charsets = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser saxParser = factory.newSAXParser();
            XMLReader rdr = saxParser.getXMLReader();
            File file = new File("C:\\Documents and Settings\\ckeith\\Desktop\\Projects\\Code Tables\\codetables.xml");
            InputSource src = new InputSource(new FileInputStream(file));
            CodeTableHandler saxUms = new CodeTableHandler();
            rdr.setContentHandler(saxUms);
            rdr.parse(src);
            charsets = saxUms.getCharSets();
            System.out.println(saxUms.getCombiningChars());
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }
}

