/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Vector;
import org.marc4j.ConverterErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTable;
import org.marc4j.converter.impl.CodeTableInterface;
import org.marc4j.converter.impl.FixDoubleWidth;
import org.marc4j.converter.impl.UnicodeUtils;

public class AnselToUnicode
extends CharConverter {
    protected CodeTableInterface ct;
    protected boolean loadedMultibyte = false;
    protected static final int DEFAULT_G0 = 66;
    protected static final int DEFAULT_G1 = 69;
    protected CodeTracker altCodeTracker = null;
    protected boolean translateNCR = false;
    protected boolean composeUnicode = false;
    protected ConverterErrorHandler errorHandler = null;

    public boolean shouldTranslateNCR() {
        return this.translateNCR;
    }

    public void setTranslateNCR(boolean translateNCR) {
        this.translateNCR = translateNCR;
    }

    public boolean shouldComposeUnicode() {
        return this.composeUnicode;
    }

    public void setComposeUnicode(boolean composeUnicode) {
        this.composeUnicode = composeUnicode;
    }

    @Override
    public boolean outputsUnicode() {
        return true;
    }

    public AnselToUnicode() {
        this.ct = this.loadGeneratedTable(false);
    }

    public AnselToUnicode(boolean loadMultibyte) {
        this.ct = this.loadGeneratedTable(loadMultibyte);
    }

    public AnselToUnicode(ConverterErrorHandler errorHandler) {
        this.ct = this.loadGeneratedTable(false);
        this.errorHandler = errorHandler;
    }

    private CodeTableInterface loadGeneratedTable(boolean loadMultibyte) {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.CodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object ct = cons.newInstance(new Object[0]);
            this.loadedMultibyte = true;
            return (CodeTableInterface)ct;
        }
        catch (Exception e) {
            CodeTable ct = loadMultibyte ? new CodeTable(AnselToUnicode.class.getResourceAsStream("resources/codetables.xml")) : new CodeTable(AnselToUnicode.class.getResourceAsStream("resources/codetablesnocjk.xml"));
            this.loadedMultibyte = loadMultibyte;
            return ct;
        }
    }

    public AnselToUnicode(String pathname) {
        this.ct = new CodeTable(pathname);
        this.loadedMultibyte = true;
    }

    public AnselToUnicode(InputStream in) {
        this.ct = new CodeTable(in);
        this.loadedMultibyte = true;
    }

    private void loadMultibyte() {
        this.ct = new CodeTable(this.getClass().getResourceAsStream("resources/codetables.xml"));
    }

    private void checkMode(char[] data2, CodeTracker cdt) throws MarcException {
        int extra = 0;
        int extra2 = 0;
        block14: while (cdt.offset + extra + extra2 < data2.length && AnselToUnicode.isEscape(data2[cdt.offset])) {
            if (cdt.offset + extra + extra2 + 1 == data2.length) {
                ++cdt.offset;
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Escape character found at end of field, discarding it. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                    break;
                }
                throw new MarcException("Escape character found at end of field. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            }
            switch (data2[cdt.offset + 1 + extra]) {
                case '(': 
                case ',': {
                    this.set_cdt(cdt, 0, data2, 2 + extra, false);
                    continue block14;
                }
                case ')': 
                case '-': {
                    this.set_cdt(cdt, 1, data2, 2 + extra, false);
                    continue block14;
                }
                case '$': {
                    int switchOffset;
                    if (!this.loadedMultibyte) {
                        this.loadMultibyte();
                        this.loadedMultibyte = true;
                    }
                    if ((switchOffset = cdt.offset + 2 + extra + extra2) >= data2.length) {
                        ++cdt.offset;
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                            continue block14;
                        }
                        throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                    }
                    switch (data2[switchOffset]) {
                        case ')': 
                        case '-': {
                            int offset2d = 3 + extra + extra2;
                            if (cdt.offset + offset2d >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                    continue block14;
                                }
                                throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                            }
                            this.set_cdt(cdt, 1, data2, offset2d, true);
                            continue block14;
                        }
                        case ',': {
                            int offset2c = 3 + extra + extra2;
                            if (cdt.offset + offset2c >= data2.length) {
                                ++cdt.offset;
                                if (this.errorHandler != null) {
                                    this.errorHandler.addError(2, "Incomplete character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                                    continue block14;
                                }
                                throw new MarcException("Incomplete character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                            }
                            this.set_cdt(cdt, 0, data2, offset2c, true);
                            continue block14;
                        }
                        case '1': {
                            cdt.g0 = data2[cdt.offset + 2 + extra + extra2];
                            cdt.offset += 3 + extra + extra2;
                            cdt.multibyte = true;
                            continue block14;
                        }
                        case ' ': {
                            ++extra2;
                            continue block14;
                        }
                    }
                    ++cdt.offset;
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(2, "Unknown character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                        continue block14;
                    }
                    throw new MarcException("Unknown character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                }
                case 'b': 
                case 'g': 
                case 'p': {
                    cdt.g0 = data2[cdt.offset + 1 + extra];
                    cdt.offset += 2 + extra;
                    cdt.multibyte = false;
                    continue block14;
                }
                case 's': {
                    cdt.g0 = 66;
                    cdt.offset += 2 + extra;
                    cdt.multibyte = false;
                    continue block14;
                }
                case ' ': {
                    if (this.errorHandler == null) {
                        throw new MarcException("Extraneous space character found within MARC8 character set escape sequence. At offset " + cdt.offset + ":" + Arrays.toString(data2));
                    }
                    ++extra;
                    continue block14;
                }
            }
            if (this.errorHandler == null) {
                throw new MarcException("Unknown character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            }
            this.errorHandler.addError(2, "Unknown character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            return;
        }
        if (this.errorHandler != null && (extra != 0 || extra2 != 0)) {
            this.errorHandler.addError(1, "" + (extra + extra2) + " extraneous space characters found within MARC8 character set escape sequence. At offset " + cdt.offset + ":" + Arrays.toString(data2));
        }
    }

    private void set_cdt(CodeTracker cdt, int g0_or_g1, char[] data2, int aAddnlOffset, boolean multibyte) {
        int addnlOffset = aAddnlOffset;
        if (data2[cdt.offset + addnlOffset] == '!' && data2[cdt.offset + addnlOffset + 1] == 'E') {
            ++addnlOffset;
        } else if (data2[cdt.offset + addnlOffset] == ' ') {
            if (this.errorHandler == null) {
                throw new MarcException("Extraneous space character found within MARC8 character set escape sequence At offset " + cdt.offset + ":" + Arrays.toString(data2));
            }
            this.errorHandler.addError(1, "Extraneous space character found within MARC8 character set escape sequence. Skipping over space. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            ++addnlOffset;
        } else if ("(,)-$!".indexOf(data2[cdt.offset + addnlOffset]) != -1) {
            if (this.errorHandler == null) {
                throw new MarcException("Extraneaous intermediate character found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            }
            this.errorHandler.addError(2, "Extraneaous intermediate character found following escape character. Discarding intermediate character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            ++addnlOffset;
        }
        if ("34BE1NQS2".indexOf(data2[cdt.offset + addnlOffset]) == -1) {
            if (this.errorHandler == null) {
                throw new MarcException("Unknown character set code found following escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            }
            this.errorHandler.addError(2, "Unknown character set code found following escape character. Discarding escape character. At offset " + cdt.offset + ":" + Arrays.toString(data2));
            if (g0_or_g1 == 0) {
                cdt.g0 = data2[cdt.offset + addnlOffset];
            } else {
                cdt.g1 = data2[cdt.offset + addnlOffset];
            }
            cdt.offset += 1 + addnlOffset;
            cdt.multibyte = multibyte;
        } else {
            if (g0_or_g1 == 0) {
                cdt.g0 = data2[cdt.offset + addnlOffset];
            } else {
                cdt.g1 = data2[cdt.offset + addnlOffset];
            }
            cdt.offset += 1 + addnlOffset;
            cdt.multibyte = multibyte;
        }
    }

    public void resetDefaultG0AndG1() {
        this.altCodeTracker = null;
    }

    public void setDefaultG0AndG1(String altG0Code, String altG1Code) {
        char escape = '\u001b';
        this.altCodeTracker = new CodeTracker();
        if (altG0Code != null && altG0Code.length() > 0) {
            altG0Code = "" + escape + altG0Code;
            this.checkMode(altG0Code.toCharArray(), this.altCodeTracker);
            this.altCodeTracker.offset = 0;
        }
        if (altG1Code != null && altG1Code.length() > 0) {
            altG1Code = "" + escape + altG1Code;
            this.checkMode(altG1Code.toCharArray(), this.altCodeTracker);
            this.altCodeTracker.offset = 0;
        }
    }

    @Override
    public String convert(char[] data2) {
        StringBuilder sb = new StringBuilder();
        int len = data2.length;
        CodeTracker cdt = new CodeTracker();
        if (this.altCodeTracker != null) {
            cdt.g0 = this.altCodeTracker.g0;
            cdt.g1 = this.altCodeTracker.g1;
            cdt.multibyte = this.altCodeTracker.multibyte;
        }
        this.checkMode(data2, cdt);
        Queue diacritics = new Queue();
        boolean unrecognizedUnicode = false;
        while (cdt.offset < data2.length) {
            if (this.ct.isCombining(data2[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                while (cdt.offset < len && this.ct.isCombining(data2[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                    char c = this.getCharCDT(data2, cdt);
                    if (c != '\u0000') {
                        diacritics.put(Character.valueOf(c));
                    }
                    this.checkMode(data2, cdt);
                }
                if (cdt.offset >= len && this.errorHandler != null) {
                    this.errorHandler.addError(2, "Diacritic found at the end of field, without the character that it is supposed to decorate");
                    break;
                }
                char c2 = this.getCharCDT(data2, cdt);
                this.checkMode(data2, cdt);
                if (c2 != '\u0000') {
                    sb.append(c2);
                }
                while (!diacritics.isEmpty()) {
                    char c1 = ((Character)diacritics.get()).charValue();
                    sb.append(c1);
                }
            } else if (cdt.multibyte) {
                String mbstr = this.convertMultibyte(cdt, data2);
                sb.append(mbstr);
            } else {
                int offset = cdt.offset;
                char cdtchar = data2[offset];
                char c = this.getCharCDT(data2, cdt);
                boolean greekErrorFixed = false;
                if (c == '\r' || c == '\n') {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(2, "Subfield contains new line or carriage return, which are invalid, deleting them");
                    }
                    c = ' ';
                }
                if (this.errorHandler != null && cdt.g0 == 83 && data2[offset] > ' ' && data2[offset] < '@') {
                    if (c == '\u0000' && data2[offset] > ' ' && data2[offset] < '@') {
                        this.errorHandler.addError(2, "Unknown punctuation mark found in Greek character set, inserting change to default character set");
                        cdt.g0 = 66;
                        c = this.getChar(data2[offset], cdt.g0, cdt.g1);
                        if (c != '\u0000') {
                            sb.append(c);
                            greekErrorFixed = true;
                        }
                    } else if (offset + 1 < data2.length && data2[offset] >= '0' && data2[offset] <= '9' && data2[offset + 1] >= '0' && data2[offset + 1] <= '9') {
                        this.errorHandler.addError(2, "Unlikely sequence of punctuation mark found in Greek character set, it likely a number, inserting change to default character set");
                        cdt.g0 = 66;
                        char c1 = this.getChar(data2[offset], cdt.g0, cdt.g1);
                        if (c1 != '\u0000') {
                            sb.append(c1);
                            greekErrorFixed = true;
                        }
                    }
                }
                if (!greekErrorFixed) {
                    if (c != '\u0000') {
                        sb.append(c);
                    } else {
                        String val = UnicodeUtils.convertUnicodeToUnicodeBNF(Character.valueOf(cdtchar));
                        if (this.translateNCR) {
                            val = val.substring(0, 3) + '>' + val.substring(3);
                            unrecognizedUnicode = true;
                        }
                        sb.append(val);
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Unknown MARC8 character code " + val.substring(val.length() - 4, val.length()) + " found for code table: " + (char)cdt.g0 + " inserting <U+XXXX>");
                        }
                    }
                }
            }
            if (!AnselToUnicode.hasNext(cdt.offset, len)) continue;
            this.checkMode(data2, cdt);
        }
        if (this.translateNCR) {
            UnicodeUtils.convertNCRToUnicode(sb);
            FixDoubleWidth.removeInvalidSecondHalf(sb);
        }
        String dataElement = sb.toString();
        if (unrecognizedUnicode) {
            dataElement = dataElement.replaceAll("<U\\+>", "<U+");
        }
        if (this.shouldComposeUnicode()) {
            return Normalizer.normalize(dataElement, Normalizer.Form.NFC);
        }
        return dataElement;
    }

    private String convertMultibyte(CodeTracker cdt, char[] data2) {
        StringBuilder sb = new StringBuilder();
        int offset = cdt.offset;
        while (offset < data2.length && data2[offset] != '\u001b') {
            int length = this.getRawMBLength(data2, offset);
            int spaces = this.getNumSpacesInMBLength(data2, offset);
            boolean errorsPresent = false;
            if ((length - spaces) % 3 != 0) {
                errorsPresent = true;
            }
            if (data2[offset] == ' ') {
                sb.append(' ');
                ++offset;
                continue;
            }
            if (data2[offset] >= '\u0080') {
                char c2 = this.getChar(data2[offset], cdt.g0, cdt.g1);
                sb.append(c2);
                ++offset;
                continue;
            }
            if (this.errorHandler == null) {
                if (offset + 3 <= data2.length) {
                    char c = this.getMBChar(this.makeMultibyte(data2[offset], data2[offset + 1], data2[offset + 2]));
                    if (c != '\u0000') {
                        sb.append(c);
                        offset += 3;
                        continue;
                    }
                    sb.append(data2[offset]);
                    sb.append(data2[offset + 1]);
                    sb.append(data2[offset + 2]);
                    offset += 3;
                    continue;
                }
                while (offset < data2.length) {
                    sb.append(data2[offset++]);
                }
                continue;
            }
            if (!errorsPresent && offset + 3 <= data2.length && (this.errorHandler == null || data2[offset + 1] != ' ' && data2[offset + 2] != ' ') && this.getMBChar(this.makeMultibyte(data2[offset], data2[offset + 1], data2[offset + 2])) != '\u0000') {
                char c = this.getMBChar(this.makeMultibyte(data2[offset], data2[offset + 1], data2[offset + 2]));
                if (this.errorHandler != null && c == '\u0000') continue;
                sb.append(c);
                offset += 3;
                continue;
            }
            if (offset + 6 < data2.length && this.noneEquals(data2, offset, offset + 3, 32) && (this.getMBChar(this.makeMultibyte(data2[offset + 0], data2[offset + 1], data2[offset + 2])) == '\u0000' || this.getMBChar(this.makeMultibyte(data2[offset + 3], data2[offset + 4], data2[offset + 5])) == '\u0000') && this.getMBChar(this.makeMultibyte(data2[offset + 2], data2[offset + 3], data2[offset + 4])) != '\u0000' && this.noneEquals(data2, offset, offset + 5, 27) && this.noneInRange(data2, offset, offset + 5, 128, 255) && !this.nextEscIsMB(data2, offset, data2.length)) {
                String mbstr = this.getMBCharStr(this.makeMultibyte(data2[offset], '[', data2[offset + 1])) + this.getMBCharStr(this.makeMultibyte(data2[offset], ']', data2[offset + 1])) + this.getMBCharStr(this.makeMultibyte(data2[offset], data2[offset + 1], '[')) + this.getMBCharStr(this.makeMultibyte(data2[offset], data2[offset + 1], ']'));
                if (mbstr.length() == 1) {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(2, "Missing square brace character in MARC8 multibyte character, inserting one to create the only valid option");
                    }
                    sb.append(mbstr);
                    offset += 2;
                    continue;
                }
                if (mbstr.length() > 1) {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(3, "Missing square brace character in MARC8 multibyte character, inserting one to create a randomly chosen valid option");
                    }
                    sb.append(mbstr.subSequence(0, 1));
                    offset += 2;
                    continue;
                }
                if (mbstr.length() != 0) continue;
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Erroneous MARC8 multibyte character, Discarding bad character and continuing reading Multibyte characters");
                }
                sb.append("[?]");
                offset += 2;
                continue;
            }
            if (offset + 7 < data2.length && this.noneEquals(data2, offset, offset + 3, 32) && (this.getMBChar(this.makeMultibyte(data2[offset + 0], data2[offset + 1], data2[offset + 2])) == '\u0000' || this.getMBChar(this.makeMultibyte(data2[offset + 3], data2[offset + 4], data2[offset + 5])) == '\u0000') && this.getMBChar(this.makeMultibyte(data2[offset + 4], data2[offset + 5], data2[offset + 6])) != '\u0000' && this.noneEquals(data2, offset, offset + 6, 27) && this.noneInRange(data2, offset, offset + 6, 128, 255) && !this.nextEscIsMB(data2, offset, data2.length)) {
                String mbstr = this.getMBCharStr(this.makeMultibyte(data2[offset], '[', data2[offset + 1])) + this.getMBCharStr(this.makeMultibyte(data2[offset], ']', data2[offset + 1])) + this.getMBCharStr(this.makeMultibyte(data2[offset], data2[offset + 1], '[')) + this.getMBCharStr(this.makeMultibyte(data2[offset], data2[offset + 1], ']'));
                if (mbstr.length() == 1) {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(2, "Missing square brace character in MARC8 multibyte character, inserting one to create the only valid option");
                    }
                    sb.append(mbstr);
                    offset += 2;
                    continue;
                }
                if (mbstr.length() > 1) {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(3, "Missing square brace character in MARC8 multibyte character, inserting one to create a randomly chosen valid option");
                    }
                    sb.append(mbstr.subSequence(0, 1));
                    offset += 2;
                    continue;
                }
                if (mbstr.length() != 0) continue;
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Erroneous MARC8 multibyte character, Discarding bad character and continuing reading Multibyte characters");
                }
                sb.append("[?]");
                offset += 2;
                continue;
            }
            if (offset + 4 <= data2.length && data2[offset] > '\u007f' && this.getMBChar(this.makeMultibyte(data2[offset + 1], data2[offset + 2], data2[offset + 3])) != '\u0000') {
                if (this.errorHandler == null) continue;
                this.errorHandler.addError(2, "Erroneous character in MARC8 multibyte character, Copying bad character and continuing reading Multibyte characters");
                sb.append(this.getChar(data2[offset], 66, 69));
                ++offset;
                continue;
            }
            if (this.errorHandler != null && offset + 4 <= data2.length && (data2[offset + 1] == ' ' || data2[offset + 2] == ' ')) {
                int multiByte = this.makeMultibyte(data2[offset], data2[offset + 1] != ' ' ? data2[offset + 1] : data2[offset + 2], data2[offset + 3]);
                char c = this.getMBChar(multiByte);
                if (c != '\u0000') {
                    if (this.errorHandler != null) {
                        this.errorHandler.addError(1, "Extraneous space found within MARC8 multibyte character");
                    }
                    sb.append(c);
                    sb.append(' ');
                    offset += 4;
                    continue;
                }
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Erroneous MARC8 multibyte character, inserting change to default character set");
                }
                cdt.multibyte = false;
                cdt.g0 = 66;
                cdt.g1 = 69;
                break;
            }
            if (offset + 3 > data2.length || offset + 3 == data2.length && (data2[offset + 1] == ' ' || data2[offset + 2] == ' ')) {
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Partial MARC8 multibyte character, inserting change to default character set");
                }
                cdt.multibyte = false;
                cdt.g0 = 66;
                cdt.g1 = 69;
                break;
            }
            if (offset + 3 <= data2.length && this.getMBChar(this.makeMultibyte(data2[offset + 0], data2[offset + 1], data2[offset + 2])) != '\u0000') {
                char c = this.getMBChar(this.makeMultibyte(data2[offset], data2[offset + 1], data2[offset + 2]));
                if (this.errorHandler != null && c == '\u0000') continue;
                sb.append(c);
                offset += 3;
                continue;
            }
            if (this.errorHandler != null) {
                this.errorHandler.addError(2, "Erroneous MARC8 multibyte character, inserting change to default character set");
            }
            cdt.multibyte = false;
            cdt.g0 = 66;
            cdt.g1 = 69;
            break;
        }
        cdt.offset = offset;
        return sb.toString();
    }

    private boolean nextEscIsMB(char[] data2, int start, int length) {
        for (int offset = start; offset < length - 1; ++offset) {
            if (data2[offset] != '\u001b') continue;
            if (data2[offset + 1] != '$') break;
            return true;
        }
        return false;
    }

    private boolean noneEquals(char[] data2, int start, int end, int val) {
        for (int offset = start; offset <= end; ++offset) {
            if (data2[offset] != (char)val) continue;
            return false;
        }
        return true;
    }

    private boolean noneInRange(char[] data2, int start, int end, int val1, int val2) {
        for (int offset = start; offset <= end; ++offset) {
            if (data2[offset] < (char)val1 || data2[offset] > (char)val2) continue;
            return false;
        }
        return true;
    }

    private int getRawMBLength(char[] data2, int offset) {
        int length = 0;
        while (offset < data2.length && data2[offset] != '\u001b') {
            ++offset;
            ++length;
        }
        return length;
    }

    private int getNumSpacesInMBLength(char[] data2, int offset) {
        int cnt = 0;
        while (offset < data2.length && data2[offset] != '\u001b') {
            if (data2[offset] == ' ') {
                ++cnt;
            }
            ++offset;
        }
        return cnt;
    }

    private char getCharCDT(char[] data2, CodeTracker cdt) {
        char c = this.getChar(data2[cdt.offset], cdt.g0, cdt.g1);
        if (this.translateNCR && (c == '&' || c == '<') && data2.length >= cdt.offset + 5) {
            boolean marc8NCR;
            boolean bl = marc8NCR = c == '&';
            if (marc8NCR && data2[cdt.offset + 1] == '#' && data2[cdt.offset + 2] == 'x' || !marc8NCR && data2[cdt.offset + 1] == 'U' && data2[cdt.offset + 2] == '+') {
                int len = 0;
                while (cdt.offset + 3 + len < data2.length) {
                    char c1 = data2[cdt.offset + 3 + len];
                    if (!(c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f')) {
                        if (len >= 1 && (marc8NCR && c1 == ';' || !marc8NCR && c1 == '>')) {
                            c = this.getCharFromCodePoint(new String(data2, cdt.offset + 3, len));
                            cdt.offset += len + 4;
                            if ((c == '\r' || c == '\n') && this.errorHandler != null) {
                                this.errorHandler.addError(2, "Subfield contains Unicode Numeric Character Reference for new line or carriage return, which are invalid");
                            }
                            return c;
                        }
                        if (len == 0 && (marc8NCR && c1 == ';' || !marc8NCR && c1 == '>')) {
                            if (this.errorHandler != null) {
                                this.errorHandler.addError(3, "Subfield contains missing Unicode Numeric Character Reference : " + new String(data2, cdt.offset, 4));
                            }
                            cdt.offset += 4;
                            c = this.getCharCDT(data2, cdt);
                            return c;
                        }
                        if (marc8NCR && len >= 1 && c1 == '%' && data2.length > cdt.offset + len + 4 && data2[cdt.offset + 3 + len + 1] == 'x' && (data2.length == cdt.offset + len + 5 || data2[cdt.offset + 3 + len + 2] != ';')) {
                            c = this.getCharFromCodePoint(new String(data2, cdt.offset + 3, len));
                            if (this.errorHandler != null) {
                                this.errorHandler.addError(2, "Subfield contains malformed Unicode Numeric Character Reference : " + new String(data2, cdt.offset, len + 5));
                            }
                            cdt.offset += len + 5;
                            return c;
                        }
                        if (marc8NCR && len >= 1 && c1 == '%' && data2.length > cdt.offset + len + 5 && data2[cdt.offset + 3 + len + 1] == 'x' && data2[cdt.offset + 3 + len + 2] == ';') {
                            c = this.getCharFromCodePoint(new String(data2, cdt.offset + 3, len));
                            if (this.errorHandler != null) {
                                this.errorHandler.addError(2, "Subfield contains malformed Unicode Numeric Character Reference : " + new String(data2, cdt.offset, len + 6));
                            }
                            cdt.offset += len + 6;
                            return c;
                        }
                        if (this.errorHandler != null) {
                            this.errorHandler.addError(2, "Subfield contains malformed Unicode Numeric Character Reference : " + new String(data2, cdt.offset, len + 3));
                        }
                        ++cdt.offset;
                        return c;
                    }
                    ++len;
                }
                if (this.errorHandler != null) {
                    this.errorHandler.addError(2, "Subfield contains unterminated Unicode Numeric Character Reference : " + new String(data2, cdt.offset, len + 3));
                }
                c = this.getCharFromCodePoint(new String(data2, cdt.offset + 3, len));
                cdt.offset += len + 3;
                return c;
            }
            ++cdt.offset;
        } else {
            ++cdt.offset;
        }
        return c;
    }

    private char getCharFromCodePoint(String charCodePoint) {
        int charNum = Integer.parseInt(charCodePoint, 16);
        return (char)charNum;
    }

    public int makeMultibyte(char c1, char c2, char c3) {
        int[] chars = new int[]{c1 << 16, c2 << 8, c3};
        return chars[0] | chars[1] | chars[2];
    }

    private char getChar(int ch, int g0, int g1) {
        if (ch <= 126) {
            return this.ct.getChar(ch, g0);
        }
        return this.ct.getChar(ch, g1);
    }

    public char getMBChar(int ch) {
        return this.ct.getChar(ch, 49);
    }

    public String getMBCharStr(int ch) {
        char c = this.ct.getChar(ch, 49);
        if (c == '\u0000') {
            return "";
        }
        return "" + c;
    }

    private static boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private static boolean isEscape(int i) {
        return i == 27;
    }

    class CodeTracker {
        int offset = 0;
        int g0 = 66;
        int g1 = 69;
        boolean multibyte;

        CodeTracker() {
        }

        public String toString() {
            return "Offset: " + this.offset + " G0: " + Integer.toHexString(this.g0) + " G1: " + Integer.toHexString(this.g1) + " Multibyte: " + this.multibyte;
        }
    }

    class Queue
    extends Vector<Character> {
        private static final long serialVersionUID = 1L;

        Queue() {
        }

        public Object put(Character item) {
            this.addElement(item);
            return item;
        }

        public Object get() {
            Object obj = this.peek();
            this.removeElementAt(0);
            return obj;
        }

        public Object peek() {
            return this.elementAt(0);
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }
}

