/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.callnum;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.callnum.AbstractCallNumber;
import org.marc4j.callnum.Utils;

public class DeweyCallNumber
extends AbstractCallNumber {
    protected String classification = null;
    protected String classDigits = null;
    protected String classDecimal = null;
    protected String cutter = null;
    protected String cutterSuffix = null;
    protected String shelfKey = null;
    public static final String CLASS_REGEX = "(\\d+)(\\.\\d+)?";
    protected static Pattern classPattern = Pattern.compile("((\\d+)(\\.\\d+)?)(.*)?");
    public static final String CUTTER_REGEX = "[A-Z]\\d{1,3}(?:[A-Z]+)?";
    public static Pattern cutterPattern = Pattern.compile(" *\\.?([A-Z]\\d{1,3}(?:[A-Z]+)?) *(.+)?");

    public DeweyCallNumber(String callNumber) {
        this.parse(callNumber);
    }

    public DeweyCallNumber() {
    }

    protected void init() {
        this.rawCallNum = null;
        this.classification = null;
        this.classDigits = null;
        this.classDecimal = null;
        this.cutter = null;
        this.cutterSuffix = null;
        this.shelfKey = null;
    }

    @Override
    public void parse(String call) {
        this.init();
        this.rawCallNum = call;
        this.parse();
    }

    protected void parse() {
        this.parseCallNumber();
        this.buildShelfKey();
    }

    protected void parseCallNumber() {
        if (this.rawCallNum == null || this.rawCallNum.length() == 0) {
            return;
        }
        Matcher m = classPattern.matcher(this.rawCallNum);
        if (!m.matches()) {
            this.cutterSuffix = this.rawCallNum;
        } else {
            this.classification = m.group(1);
            this.classDigits = m.group(2);
            this.classDecimal = m.group(3);
            String everythingElse = m.group(4);
            Matcher mCut = cutterPattern.matcher(everythingElse);
            if (!mCut.matches()) {
                this.cutterSuffix = everythingElse;
            } else {
                this.cutter = mCut.group(1);
                this.cutterSuffix = mCut.group(2);
            }
        }
    }

    public String getClassification() {
        return this.classification;
    }

    public String getClassificationNormalized() {
        if (this.classDigits == null || this.classDigits.length() >= 3) {
            return this.classification;
        }
        StringBuilder norm = new StringBuilder();
        switch (this.classDigits.length()) {
            case 1: {
                norm.append("00");
                break;
            }
            case 2: {
                norm.append("0");
                break;
            }
        }
        norm.append(this.classDigits);
        if (this.classDecimal != null) {
            norm.append(this.classDecimal);
        }
        return norm.toString();
    }

    public String getClassDigits() {
        return this.classDigits;
    }

    public String getClassDecimal() {
        return this.classDecimal;
    }

    public String getCutter() {
        return this.cutter;
    }

    public String getSuffix() {
        return this.cutterSuffix;
    }

    @Override
    public String getShelfKey() {
        return this.shelfKey;
    }

    protected void buildShelfKey() {
        StringBuilder keyBuf = new StringBuilder();
        if (this.rawCallNum == null) {
            this.shelfKey = null;
        } else {
            if (this.classDigits != null) {
                Utils.appendSortableNumber(keyBuf, this.classDigits);
            }
            if (this.classDecimal != null) {
                keyBuf.append(this.classDecimal);
            }
            if (this.cutter != null) {
                if (keyBuf.length() > 0) {
                    keyBuf.append(' ');
                }
                keyBuf.append(this.cutter);
            }
            if (this.cutterSuffix != null) {
                if (keyBuf.length() > 0) {
                    keyBuf.append(' ');
                }
                Utils.appendNumericallySortable(keyBuf, this.cutterSuffix);
            }
            this.shelfKey = keyBuf.toString();
        }
    }

    @Override
    public boolean isValid() {
        return this.classDigits != null;
    }

    public String toString() {
        return this.rawCallNum;
    }
}

