/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.LinkedHashMap;
import java.util.Map;

public class Mrk8TranslationTable {
    private static Map<String, String> mrk8Map = null;
    private static final String[][] mrk8Table = new String[][]{{"{0}", "30x"}, {"{00}", "00x"}, {"{01}", "01x"}, {"{02}", "02x"}, {"{03}", "03x"}, {"{04}", "04x"}, {"{05}", "05x"}, {"{06}", "06x"}, {"{07}", "07x"}, {"{08}", "08x"}, {"{09}", "09x"}, {"{0A}", "0Ax"}, {"{0B}", "0Bx"}, {"{0C}", "0Cx"}, {"{0D}", "0Dx"}, {"{0E}", "0Ex"}, {"{0F}", "0Fx"}, {"{1}", "31x"}, {"{10}", "10x"}, {"{11}", "11x"}, {"{12}", "12x"}, {"{13}", "13x"}, {"{14}", "14x"}, {"{15}", "15x"}, {"{16}", "16x"}, {"{17}", "17x"}, {"{18}", "18x"}, {"{19}", "19x"}, {"{1A}", "1Ax"}, {"{1B}", "1Bx"}, {"{1C}", "1Cx"}, {"{1D}", "1Dx"}, {"{1E}", "1Ex"}, {"{1F}", "1Fx"}, {"{2}", "32x"}, {"{20}", "20x"}, {"{21}", "21x"}, {"{22}", "22x"}, {"{23}", "23x"}, {"{24}", "24x"}, {"{25}", "25x"}, {"{26}", "26x"}, {"{27}", "27x"}, {"{28}", "28x"}, {"{29}", "29x"}, {"{2A}", "2Ax"}, {"{2B}", "2Bx"}, {"{2C}", "2Cx"}, {"{2D}", "2Dx"}, {"{2E}", "2Ex"}, {"{2F}", "2Fx"}, {"{3}", "33x"}, {"{30}", "30x"}, {"{31}", "31x"}, {"{32}", "32x"}, {"{33}", "33x"}, {"{34}", "34x"}, {"{35}", "35x"}, {"{36}", "36x"}, {"{37}", "37x"}, {"{38}", "38x"}, {"{39}", "39x"}, {"{3A}", "3Ax"}, {"{3B}", "3Bx"}, {"{3C}", "3Cx"}, {"{3D}", "3Dx"}, {"{3E}", "3Ex"}, {"{3F}", "3Fx"}, {"{4}", "34x"}, {"{40}", "40x"}, {"{41}", "41x"}, {"{42}", "42x"}, {"{43}", "43x"}, {"{44}", "44x"}, {"{45}", "45x"}, {"{46}", "46x"}, {"{47}", "47x"}, {"{48}", "48x"}, {"{49}", "49x"}, {"{4A}", "4Ax"}, {"{4B}", "4Bx"}, {"{4C}", "4Cx"}, {"{4D}", "4Dx"}, {"{4E}", "4Ex"}, {"{4F}", "4Fx"}, {"{5}", "35x"}, {"{50}", "50x"}, {"{51}", "51x"}, {"{52}", "52x"}, {"{53}", "53x"}, {"{54}", "54x"}, {"{55}", "55x"}, {"{56}", "56x"}, {"{57}", "57x"}, {"{58}", "58x"}, {"{59}", "59x"}, {"{5A}", "5Ax"}, {"{5B}", "5Bx"}, {"{5C}", "5Cx"}, {"{5D}", "5Dx"}, {"{5E}", "5Ex"}, {"{5F}", "5Fx"}, {"{6}", "36x"}, {"{60}", "60x"}, {"{61}", "61x"}, {"{62}", "62x"}, {"{63}", "63x"}, {"{64}", "64x"}, {"{65}", "65x"}, {"{66}", "66x"}, {"{67}", "67x"}, {"{68}", "68x"}, {"{69}", "69x"}, {"{6A}", "6Ax"}, {"{6B}", "6Bx"}, {"{6C}", "6Cx"}, {"{6D}", "6Dx"}, {"{6E}", "6Ex"}, {"{6F}", "6Fx"}, {"{7}", "37x"}, {"{70}", "70x"}, {"{71}", "71x"}, {"{72}", "72x"}, {"{73}", "73x"}, {"{74}", "74x"}, {"{75}", "75x"}, {"{76}", "76x"}, {"{77}", "77x"}, {"{78}", "78x"}, {"{79}", "79x"}, {"{7A}", "7Ax"}, {"{7B}", "7Bx"}, {"{7C}", "7Cx"}, {"{7D}", "7Dx"}, {"{7E}", "7Ex"}, {"{7F}", "7Fx"}, {"{8}", "38x"}, {"{80}", "80x"}, {"{81}", "81x"}, {"{82}", "82x"}, {"{83}", "83x"}, {"{84}", "84x"}, {"{85}", "85x"}, {"{86}", "86x"}, {"{87}", "87x"}, {"{88}", "88x"}, {"{89}", "89x"}, {"{8A}", "8Ax"}, {"{8B}", "8Bx"}, {"{8C}", "8Cx"}, {"{8D}", "8Dx"}, {"{8E}", "8Ex"}, {"{8F}", "8Fx"}, {"{9}", "39x"}, {"{90}", "90x"}, {"{91}", "91x"}, {"{92}", "92x"}, {"{93}", "93x"}, {"{94}", "94x"}, {"{95}", "95x"}, {"{96}", "96x"}, {"{97}", "97x"}, {"{98}", "98x"}, {"{99}", "99x"}, {"{9A}", "9Ax"}, {"{9B}", "9Bx"}, {"{9C}", "9Cx"}, {"{9D}", "9Dx"}, {"{9E}", "9Ex"}, {"{9F}", "9Fx"}, {"{A}", "41x"}, {"{a}", "61x"}, {"{A0}", "A0x"}, {"{A1}", "A1x"}, {"{A2}", "A2x"}, {"{A3}", "A3x"}, {"{A4}", "A4x"}, {"{A5}", "A5x"}, {"{A6}", "A6x"}, {"{A7}", "A7x"}, {"{A8}", "A8x"}, {"{A9}", "A9x"}, {"{AA}", "AAx"}, {"{Aacute}", "E2x 41x"}, {"{aacute}", "E2x 61x"}, {"{AB}", "ABx"}, {"{Abreve}", "E6x 41x"}, {"{abreve}", "E6x 61x"}, {"{AC}", "ACx"}, {"{Acirc}", "E3x 41x"}, {"{acirc}", "E3x 61x"}, {"{acute}", "E2x"}, {"{Acy}", "41x"}, {"{acy}", "61x"}, {"{AD}", "ADx"}, {"{AE}", "AEx"}, {"{AElig}", "A5x"}, {"{aelig}", "B5x"}, {"{AF}", "AFx"}, {"{agr}", "61x"}, {"{Agrave}", "E1x 41x"}, {"{agrave}", "E1x 61x"}, {"{alif}", "AEx"}, {"{amp}", "26x"}, {"{Aogon}", "F1x 41x"}, {"{aogon}", "F1x 61x"}, {"{apos}", "27x"}, {"{arab}", "28x 33x"}, {"{Aring}", "EAx 41x"}, {"{aring}", "EAx 61x"}, {"{ast}", "2Ax"}, {"{asuper}", "61x"}, {"{Atilde}", "E4x 41x"}, {"{atilde}", "E4x 61x"}, {"{Auml}", "E8x 41x"}, {"{auml}", "E8x 61x"}, {"{ayn}", "B0x"}, {"{B}", "42x"}, {"{b}", "62x"}, {"{B0}", "B0x"}, {"{B1}", "B1x"}, {"{B2}", "B2x"}, {"{B3}", "B3x"}, {"{B4}", "B4x"}, {"{B5}", "B5x"}, {"{B6}", "B6x"}, {"{B7}", "B7x"}, {"{B8}", "B8x"}, {"{B9}", "B9x"}, {"{BA}", "BAx"}, {"{BB}", "BBx"}, {"{BC}", "BCx"}, {"{bcy}", "62x"}, {"{Bcy}", "42x"}, {"{BD}", "BDx"}, {"{BE}", "BEx"}, {"{BF}", "BFx"}, {"{bgr}", "62x"}, {"{breve}", "E6x"}, {"{breveb}", "F9x"}, {"{brvbar}", "7Cx"}, {"{bsol}", "5Cx"}, {"{bull}", "2Ax"}, {"{C}", "43x"}, {"{c}", "63x"}, {"{C0}", "C0x"}, {"{C1}", "C1x"}, {"{C2}", "C2x"}, {"{C3}", "C3x"}, {"{C4}", "C4x"}, {"{C5}", "C5x"}, {"{C6}", "C6x"}, {"{C7}", "C7x"}, {"{C8}", "C8x"}, {"{C9}", "C9x"}, {"{CA}", "CAx"}, {"{Cacute}", "E2x 43x"}, {"{cacute}", "E2x 63x"}, {"{candra}", "EFx"}, {"{caron}", "E9x"}, {"{CB}", "CBx"}, {"{CC}", "CCx"}, {"{Ccaron}", "E9x 43x"}, {"{ccaron}", "E9x 63x"}, {"{Ccedil}", "F0x 43x"}, {"{ccedil}", "F0x 63x"}, {"{CD}", "CDx"}, {"{CE}", "CEx"}, {"{cedil}", "F0x"}, {"{cent}", "63x"}, {"{CF}", "CFx"}, {"{CHcy}", "43x 68x"}, {"{chcy}", "63x 68x"}, {"{circ}", "E3x"}, {"{circb}", "F4x"}, {"{cjk}", "24x 31x"}, {"{colon}", "3Ax"}, {"{comma}", "2Cx"}, {"{commaa}", "FEx"}, {"{commab}", "F7x"}, {"{commat}", "40x"}, {"{copy}", "C3x"}, {"{curren}", "2Ax"}, {"{cyril}", "28x 4Ex"}, {"{D}", "44x"}, {"{d}", "64x"}, {"{D0}", "D0x"}, {"{D1}", "D1x"}, {"{D2}", "D2x"}, {"{D3}", "D3x"}, {"{D4}", "D4x"}, {"{D5}", "D5x"}, {"{D6}", "D6x"}, {"{D7}", "D7x"}, {"{D8}", "D8x"}, {"{D9}", "D9x"}, {"{DA}", "DAx"}, {"{Dagger}", "7Cx"}, {"{dagger}", "7Cx"}, {"{DB}", "DBx"}, {"{dblac}", "EEx"}, {"{dbldotb}", "F3x"}, {"{dblunder}", "F5x"}, {"{DC}", "DCx"}, {"{Dcaron}", "E9x 44x"}, {"{dcaron}", "E9x 64x"}, {"{Dcy}", "44x"}, {"{dcy}", "64x"}, {"{DD}", "DDx"}, {"{DE}", "DEx"}, {"{deg}", "C0x"}, {"{DF}", "DFx"}, {"{diaer}", "E8x"}, {"{divide}", "2Fx"}, {"{djecy}", "B3x"}, {"{DJEcy}", "A3x"}, {"{dollar}", "24x"}, {"{dot}", "E7x"}, {"{dotb}", "F2x"}, {"{Dstrok}", "A3x"}, {"{dstrok}", "B3x"}, {"{DZEcy}", "44x 7Ax"}, {"{dzecy}", "64x 7Ax"}, {"{DZHEcy}", "44x E9x 7Ax"}, {"{dzhecy}", "64x E9x 7Ax"}, {"{E}", "45x"}, {"{e}", "65x"}, {"{E0}", "E0x"}, {"{E1}", "E1x"}, {"{E2}", "E2x"}, {"{E3}", "E3x"}, {"{E4}", "E4x"}, {"{E5}", "E5x"}, {"{E6}", "E6x"}, {"{E7}", "E7x"}, {"{E8}", "E8x"}, {"{E9}", "E9x"}, {"{EA}", "EAx"}, {"{ea}", "eax"}, {"{Eacute}", "E2x 45x"}, {"{eacute}", "E2x 65x"}, {"{EB}", "EBx"}, {"{EC}", "ECx"}, {"{Ecaron}", "E9x 45x"}, {"{ecaron}", "E9x 65x"}, {"{Ecirc}", "E3x 45x"}, {"{ecirc}", "E3x 65x"}, {"{Ecy}", "E7x 44x"}, {"{ecy}", "E7x 65x"}, {"{ED}", "EDx"}, {"{EE}", "EEx"}, {"{EF}", "EFx"}, {"{Egrave}", "E1x 45x"}, {"{egrave}", "E1x 65x"}, {"{Ehookr}", "F1x 45x"}, {"{ehookr}", "F1x 65x"}, {"{Eogon}", "F1x 45x"}, {"{eogon}", "F1x 65x"}, {"{equals}", "3Dx"}, {"{esc}", "1Bx"}, {"{eth}", "BAx"}, {"{ETH}", "A3x"}, {"{Euml}", "E8x 45x"}, {"{euml}", "E8x 65x"}, {"{excl}", "21x"}, {"{F}", "46x"}, {"{f}", "66x"}, {"{F0}", "F0x"}, {"{F1}", "F1x"}, {"{F2}", "F2x"}, {"{F3}", "F3x"}, {"{F4}", "F4x"}, {"{F5}", "F5x"}, {"{F6}", "F6x"}, {"{F7}", "F7x"}, {"{F8}", "F8x"}, {"{F9}", "F9x"}, {"{FA}", "FAx"}, {"{FB}", "FBx"}, {"{FC}", "FCx"}, {"{Fcy}", "46x"}, {"{fcy}", "66x"}, {"{FD}", "FDx"}, {"{FE}", "FEx"}, {"{FF}", "FFx"}, {"{flat}", "A9x"}, {"{fnof}", "66x"}, {"{frac12}", "31x 2Fx 32x"}, {"{frac14}", "31x 2Fx 34x"}, {"{frac34}", "33x 2Fx 34x"}, {"{G}", "47x"}, {"{g}", "67x"}, {"{Gcy}", "47x"}, {"{gcy}", "67x"}, {"{GEcy}", "47x"}, {"{gecy}", "67x"}, {"{ggr}", "67x"}, {"{GHcy}", "47x"}, {"{ghcy}", "67x"}, {"{GJEcy}", "E2x 47x"}, {"{gjecy}", "E2x 67x"}, {"{grave}", "E1x"}, {"{greek}", "67x"}, {"{gs}", "1Dx"}, {"{gt}", "3Ex"}, {"{H}", "48x"}, {"{h}", "68x"}, {"{HARDcy}", "B7x"}, {"{hardcy}", "B7x"}, {"{hardsign}", "B7x"}, {"{Hcy}", "48x"}, {"{hcy}", "68x"}, {"{hebrew}", "28x 32x"}, {"{hellip}", "2Ex 2Ex 2Ex"}, {"{hooka}", "E0x"}, {"{hookl}", "F7x"}, {"{hookr}", "F1x"}, {"{hyphen}", "2Dx"}, {"{I}", "49x"}, {"{i}", "69x"}, {"{Iacute}", "E2x 49x"}, {"{iacute}", "E2x 69x"}, {"{Icaron}", "E9x 49x"}, {"{icaron}", "E9x 69x"}, {"{Icirc}", "E3x 49x"}, {"{icirc}", "E3x 69x"}, {"{Icy}", "49x"}, {"{icy}", "69x"}, {"{Idot}", "E7x 49x"}, {"{IEcy}", "EBx 49x ECx 45x"}, {"{iecy}", "EBx 69x ECx 65x"}, {"{iexcl}", "C6x"}, {"{Igrave}", "E1x 49x"}, {"{igrave}", "E1x 69x"}, {"{IJlig}", "49x 4Ax"}, {"{ijlig}", "69x 6Ax"}, {"{inodot}", "B8x"}, {"{IOcy}", "EBx 49x ECx 4Fx"}, {"{iocy}", "EBx 69x ECx 6Fx"}, {"{iquest}", "C5x"}, {"{Iuml}", "E8x 49x"}, {"{iuml}", "E8x 69x"}, {"{Iumlcy}", "E8x 49x"}, {"{iumlcy}", "E8x 69x"}, {"{IYcy}", "59x"}, {"{iycy}", "79x"}, {"{J}", "4Ax"}, {"{j}", "6Ax"}, {"{Jcy}", "E6x 49x"}, {"{jcy}", "E6x 69x"}, {"{JEcy}", "4Ax"}, {"{jecy}", "6Ax"}, {"{JIcy}", "E8x 49x"}, {"{jicy}", "E8x 69x"}, {"{joiner}", "8Dx"}, {"{K}", "4Bx"}, {"{k}", "6Bx"}, {"{Kcy}", "4Bx"}, {"{kcy}", "6Bx"}, {"{KHcy}", "4Bx 68x"}, {"{khcy}", "6Bx 68x"}, {"{KJEcy}", "E2x 4Bx"}, {"{kjecy}", "E2x 6Bx"}, {"{L}", "4Cx"}, {"{l}", "6Cx"}, {"{Lacute}", "E2x 4Cx"}, {"{lacute}", "E2x 6Cx"}, {"{laquo}", "22x"}, {"{latin}", "28x 42x"}, {"{lcub}", "7Bx"}, {"{Lcy}", "4Cx"}, {"{lcy}", "6Cx"}, {"{ldbltil}", "FAx"}, {"{ldquo}", "22x"}, {"{LJEcy}", "4Cx 6Ax"}, {"{ljecy}", "6Cx 6Ax"}, {"{llig}", "EBx"}, {"{lpar}", "28x"}, {"{lsqb}", "5Bx"}, {"{lsquo}", "27x"}, {"{lsquor}", "27x"}, {"{Lstrok}", "A1x"}, {"{lstrok}", "B1x"}, {"{lt}", "3Cx"}, {"{M}", "4Dx"}, {"{m}", "6Dx"}, {"{macr}", "E5x"}, {"{Mcy}", "4Dx"}, {"{mcy}", "6Dx"}, {"{mdash}", "2Dx 2Dx"}, {"{middot}", "A8x"}, {"{mllhring}", "B0x"}, {"{mlprime}", "A7x"}, {"{mlPrime}", "B7x"}, {"{mlrhring}", "AEx"}, {"{N}", "4Ex"}, {"{n}", "6Ex"}, {"{Nacute}", "E2x 4Ex"}, {"{nacute}", "E2x 6Ex"}, {"{Ncaron}", "E9x 4Ex"}, {"{ncaron}", "E9x 6Ex"}, {"{Ncy}", "4Ex"}, {"{ncy}", "6Ex"}, {"{ndash}", "2Dx 2Dx"}, {"{NJEcy}", "4Ex 6Ax"}, {"{njecy}", "6Ex 6Ax"}, {"{No}", "4Ex 6Fx 2Ex"}, {"{nonjoin}", "8Ex"}, {"{Ntilde}", "E4x 4Ex"}, {"{ntilde}", "E4x 6Ex"}, {"{num}", "23x"}, {"{O}", "4Fx"}, {"{o}", "6Fx"}, {"{Oacute}", "E2x 4Fx"}, {"{oacute}", "E2x 6Fx"}, {"{Ocirc}", "E3x 4Fx"}, {"{ocirc}", "E3x 6Fx"}, {"{Ocy}", "4Fx"}, {"{ocy}", "6Fx"}, {"{Odblac}", "EEx 4Fx"}, {"{odblac}", "EEx 6Fx"}, {"{OElig}", "A6x"}, {"{oelig}", "B6x"}, {"{ogon}", "F1x"}, {"{Ograve}", "E1x 4Fx"}, {"{ograve}", "E1x 6Fx"}, {"{Ohorn}", "ACx"}, {"{ohorn}", "BCx"}, {"{ordf}", "61x"}, {"{ordm}", "6Fx"}, {"{Ostrok}", "A2x"}, {"{ostrok}", "B2x"}, {"{osuper}", "6Fx"}, {"{Otilde}", "E4x 4Fx"}, {"{otilde}", "E4x 6Fx"}, {"{Ouml}", "E8x 4Fx"}, {"{ouml}", "E8x 6Fx"}, {"{P}", "50x"}, {"{p}", "70x"}, {"{para}", "7Cx"}, {"{Pcy}", "50x"}, {"{pcy}", "70x"}, {"{percnt}", "25x"}, {"{period}", "2Ex"}, {"{phono}", "C2x"}, {"{pipe}", "7Cx"}, {"{plus}", "2Bx"}, {"{plusmn}", "ABx"}, {"{pound}", "B9x"}, {"{Q}", "51x"}, {"{q}", "71x"}, {"{quest}", "3Fx"}, {"{quot}", "22x"}, {"{R}", "52x"}, {"{r}", "72x"}, {"{Racute}", "E2x 52x"}, {"{racute}", "E2x 72x"}, {"{raquo}", "22x"}, {"{Rcaron}", "E9x 52x"}, {"{rcaron}", "E9x 72x"}, {"{rcedil}", "F8x"}, {"{rcommaa}", "EDx"}, {"{rcub}", "7Dx"}, {"{Rcy}", "52x"}, {"{rcy}", "72x"}, {"{rdbltil}", "FBx"}, {"{rdquofh}", "22x"}, {"{rdquor}", "22x"}, {"{reg}", "AAx"}, {"{ring}", "EAx"}, {"{ringb}", "F4x"}, {"{rlig}", "ECx"}, {"{rpar}", "29x"}, {"{rs}", "1Ex"}, {"{rsqb}", "5Dx"}, {"{rsquo}", "27x"}, {"{rsquor}", "27x"}, {"{S}", "53x"}, {"{s}", "73x"}, {"{Sacute}", "E2x 53x"}, {"{sacute}", "E2x 73x"}, {"{Scommab}", "F7x 53x"}, {"{scommab}", "F7x 73x"}, {"{scriptl}", "C1x"}, {"{Scy}", "53x"}, {"{scy}", "73x"}, {"{sect}", "7Cx"}, {"{semi}", "3Bx"}, {"{sharp}", "C4x"}, {"{SHCHcy}", "53x 68x 63x 68x"}, {"{shchcy}", "73x 68x 63x 68x"}, {"{SHcy}", "53x 68x"}, {"{shcy}", "73x 68x"}, {"{shy}", "2Dx"}, {"{SOFTcy}", "A7x"}, {"{softcy}", "A7x"}, {"{softsign}", "A7x"}, {"{sol}", "2Fx"}, {"{space}", "20x"}, {"{spcirc}", "5Ex"}, {"{spgrave}", "60x"}, {"{sptilde}", "7Ex"}, {"{spundscr}", "5Fx"}, {"{squf}", "7Cx"}, {"{sub}", "62x"}, {"{sup1}", "1Bx 70x 31x 1Bx 73x"}, {"{sup2}", "1Bx 70x 32x 1Bx 73x"}, {"{sup3}", "1Bx 70x 33x 1Bx 73x"}, {"{super}", "70x"}, {"{szlig}", "73x 73x"}, {"{T}", "54x"}, {"{t}", "74x"}, {"{Tcaron}", "E9x 54x"}, {"{tcaron}", "E9x 74x"}, {"{Tcommab}", "F7x 54x"}, {"{tcommab}", "F7x 74x"}, {"{Tcy}", "54x"}, {"{tcy}", "74x"}, {"{THORN}", "A4x"}, {"{thorn}", "B4x"}, {"{tilde}", "E4x"}, {"{times}", "78x"}, {"{trade}", "28x 54x 6Dx 29x"}, {"{TScy}", "EBx 54x ECx 53x"}, {"{tscy}", "EBx 74x ECx 73x"}, {"{TSHEcy}", "E2x 43x"}, {"{tshecy}", "E2x 63x"}, {"{U}", "55x"}, {"{u}", "75x"}, {"{Uacute}", "E2x 55x"}, {"{uacute}", "E2x 75x"}, {"{Ubrevecy}", "E6x 55x"}, {"{ubrevecy}", "E6x 75x"}, {"{Ucirc}", "E3x 55x"}, {"{ucirc}", "E3x 75x"}, {"{Ucy}", "55x"}, {"{ucy}", "75x"}, {"{Udblac}", "EEx 55x"}, {"{udblac}", "EEx 75x"}, {"{Ugrave}", "E1x 55x"}, {"{ugrave}", "E1x 75x"}, {"{Uhorn}", "ADx"}, {"{uhorn}", "BDx"}, {"{uml}", "E8x"}, {"{under}", "F6x"}, {"{Uring}", "EAx 55x"}, {"{uring}", "EAx 75x"}, {"{us}", "1Fx"}, {"{Uuml}", "E8x 55x"}, {"{uuml}", "E8x 75x"}, {"{V}", "56x"}, {"{v}", "76x"}, {"{Vcy}", "56x"}, {"{vcy}", "76x"}, {"{verbar}", "7Cx"}, {"{vlineb}", "F2x"}, {"{W}", "57x"}, {"{w}", "77x"}, {"{X}", "58x"}, {"{x}", "78x"}, {"{Y}", "59x"}, {"{y}", "79x"}, {"{Yacute}", "E2x 59x"}, {"{yacute}", "E2x 79x"}, {"{YAcy}", "EBx 49x ECx 41x"}, {"{yacy}", "EBx 69x ECx 61x"}, {"{Ycy}", "59x"}, {"{ycy}", "79x"}, {"{YEcy}", "45x"}, {"{yecy}", "65x"}, {"{yen}", "59x"}, {"{YIcy}", "49x"}, {"{yicy}", "69x"}, {"{YUcy}", "EBx 49x ECx 55x"}, {"{yucy}", "EBx 69x ECx 75x"}, {"{Z}", "5Ax"}, {"{z}", "7Ax"}, {"{Zacute}", "E2x 5Ax"}, {"{zacute}", "E2x 7Ax"}, {"{Zcy}", "5Ax"}, {"{zcy}", "7Ax"}, {"{Zdot}", "E7x 5Ax"}, {"{zdot}", "E7x 7Ax"}, {"{ZHcy}", "5Ax 68x"}, {"{zhcy}", "7Ax 68x"}, {"{ZHuacy}", "EBx 5Ax ECx 68x"}, {"{zhuacy}", "EBx 7Ax ECx 68x"}};

    public static String fromMrk8(String datafield) {
        if (datafield.indexOf(123) == -1) {
            return datafield;
        }
        StringBuilder sb = new StringBuilder();
        int len = datafield.length();
        int i = 0;
        while (i < len) {
            int j = datafield.indexOf(123, i);
            if (j == -1) {
                sb.append(datafield.substring(i));
                i = len;
                continue;
            }
            if (i < j) {
                sb.append(datafield.substring(i, j));
                i = j - 1;
            }
            int k = datafield.indexOf(125, j);
            String lookupVal = datafield.substring(j, k + 1);
            sb.append(Mrk8TranslationTable.lookup(lookupVal));
            i = k + 1;
        }
        return sb.toString();
    }

    public static String toMrk8(String datafield) {
        char[] chars = datafield.toCharArray();
        StringBuilder sb = new StringBuilder();
        block5: for (char c : chars) {
            switch (c) {
                case '$': {
                    sb.append("{dollar}");
                    continue block5;
                }
                case '{': {
                    sb.append("{lcub}");
                    continue block5;
                }
                case '}': {
                    sb.append("{rcub}");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String lookup(String toLookup) {
        String lookupVal;
        if (mrk8Map == null) {
            mrk8Map = new LinkedHashMap<String, String>();
            for (int i = 0; i < mrk8Table.length; ++i) {
                String translateVal = Mrk8TranslationTable.translate(mrk8Table[i][1]);
                mrk8Map.put(mrk8Table[i][0], translateVal);
            }
        }
        if ((lookupVal = mrk8Map.get(toLookup)) == null) {
            lookupVal = toLookup;
        }
        return lookupVal;
    }

    private static String translate(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); i += 4) {
            sb.append((char)(Mrk8TranslationTable.charToNibble(s.charAt(i)) * 16 + Mrk8TranslationTable.charToNibble(s.charAt(i + 1))));
        }
        return sb.toString();
    }

    private static int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return 0;
    }
}

