/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.Normalizer;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.MarcException;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.UnicodeUtils;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MarcXmlWriter
implements MarcWriter {
    protected static final String CONTROL_FIELD = "controlfield";
    protected static final String DATA_FIELD = "datafield";
    protected static final String SUBFIELD = "subfield";
    protected static final String COLLECTION = "collection";
    protected static final String RECORD = "record";
    protected static final String LEADER = "leader";
    private boolean indent = false;
    private TransformerHandler handler = null;
    private Writer writer = null;
    private String encoding = "UTF8";
    private CharConverter converter = null;
    private boolean normalize = false;
    private boolean checkNonXMLChars = false;
    static Pattern valid = Pattern.compile("[\\u0001-\\uD7FF\\uE000-\ufffd\\x{10000}-\\x{10FFFF}]");
    static Pattern ctrlChar = Pattern.compile("[\\u0001-\\u0008\\u000B-\\u000C\\u000E-\\u001F\\u007F-\\u0084\\u0086-\\u009F]");
    static Pattern discouraged = Pattern.compile("[\\uFDD0-\\uFDEF\\x{1FFFE}-\\x{1FFFF}\\x{2FFFE}-\\x{2FFFF}\\x{3FFFE}-\\x{3FFFF}\\x{4FFFE}-\\x{4FFFF}\\x{5FFFE}-\\x{5FFFF}\\x{6FFFE}-\\x{6FFFF}\\x{7FFFE}-\\x{7FFFF}\\x{8FFFE}-\\x{8FFFF}\\x{9FFFE}-\\x{9FFFF}\\x{AFFFE}-\\x{AFFFF}\\x{BFFFE}-\\x{BFFFF}\\x{CFFFE}-\\x{CFFFF}\\x{DFFFE}-\\x{DFFFF}\\x{EFFFE}-\\x{EFFFF}\\x{FFFFE}-\\x{FFFFF}\\x{10FFFE}-\\x{10FFFF}]");

    private MarcXmlWriter() {
    }

    public MarcXmlWriter(OutputStream out) {
        this(out, false);
    }

    public MarcXmlWriter(OutputStream out, boolean indent) {
        this(out, "UTF8", indent);
    }

    public MarcXmlWriter(OutputStream out, String encoding) {
        this(out, encoding, false);
    }

    public MarcXmlWriter(OutputStream out, String encoding, boolean indent) {
        this.encoding = encoding;
        if (out == null) {
            throw new NullPointerException("null OutputStream");
        }
        if (this.encoding == null) {
            throw new NullPointerException("null encoding");
        }
        try {
            this.setIndent(indent);
            this.writer = new OutputStreamWriter(out, encoding);
            this.writer = new BufferedWriter(this.writer);
            this.setHandler(new StreamResult(this.writer), null);
        }
        catch (UnsupportedEncodingException details) {
            throw new MarcException(details.getMessage(), details);
        }
        this.writeStartDocument();
    }

    public MarcXmlWriter(Result result2) {
        if (result2 == null) {
            throw new NullPointerException("null Result");
        }
        this.setHandler(result2, null);
        this.writeStartDocument();
    }

    public MarcXmlWriter(Result result2, String stylesheetUrl) {
        this(result2, new StreamSource(stylesheetUrl));
    }

    public MarcXmlWriter(Result result2, Source stylesheet) {
        if (stylesheet == null) {
            throw new NullPointerException("null Source");
        }
        if (result2 == null) {
            throw new NullPointerException("null Result");
        }
        this.setHandler(result2, stylesheet);
        this.writeStartDocument();
    }

    @Override
    public void close() {
        this.writeEndDocument();
        try {
            if (this.writer != null) {
                this.writer.write("\n");
                this.writer.close();
            }
        }
        catch (IOException details) {
            throw new MarcException(details.getMessage(), details);
        }
    }

    @Override
    public CharConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(CharConverter converter) {
        this.converter = converter;
    }

    public void setUnicodeNormalization(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean getUnicodeNormalization() {
        return this.normalize;
    }

    public void setCheckNonXMLChars(boolean checkNonXMLChars) {
        this.checkNonXMLChars = checkNonXMLChars;
    }

    public boolean getCheckNonXMLChars() {
        return this.checkNonXMLChars;
    }

    protected void setHandler(Result result2, Source stylesheet) throws MarcException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (!factory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new UnsupportedOperationException("SAXTransformerFactory is not supported");
            }
            SAXTransformerFactory saxFactory = (SAXTransformerFactory)factory;
            this.handler = stylesheet == null ? saxFactory.newTransformerHandler() : saxFactory.newTransformerHandler(stylesheet);
            this.handler.getTransformer().setOutputProperty("method", "xml");
            this.handler.setResult(result2);
        }
        catch (Exception details) {
            throw new MarcException(details.getMessage(), details);
        }
    }

    protected void writeStartDocument() {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.handler.startDocument();
            this.handler.startPrefixMapping("marc", "http://www.loc.gov/MARC21/slim");
            this.handler.startElement("http://www.loc.gov/MARC21/slim", COLLECTION, "marc:collection", atts);
        }
        catch (SAXException details) {
            throw new MarcException("SAX error occured while writing start document", details);
        }
    }

    protected void writeEndDocument() {
        try {
            if (this.indent) {
                this.handler.ignorableWhitespace("\n".toCharArray(), 0, 1);
            }
            this.handler.endElement("http://www.loc.gov/MARC21/slim", COLLECTION, "marc:collection");
            this.handler.endPrefixMapping("http://www.loc.gov/MARC21/slim");
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new MarcException("SAX error occured while writing end document", e);
        }
    }

    @Override
    public void write(Record record) {
        try {
            this.toXml(record);
        }
        catch (SAXException e) {
            throw new MarcException("SAX error occured while writing record", e);
        }
    }

    public static void writeSingleRecord(Record record, OutputStream stream) throws IOException {
        MarcXmlWriter.writeSingleRecord(record, stream, true, false);
    }

    public static void writeSingleRecord(Record record, OutputStream stream, boolean indent) throws IOException {
        MarcXmlWriter.writeSingleRecord(record, stream, true, indent);
    }

    public static void writeSingleRecord(Record record, OutputStream stream, boolean encode, boolean indent) throws IOException {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
            MarcXmlWriter writer = new MarcXmlWriter();
            if (encode) {
                writer.setConverter(new AnselToUnicode());
            }
            writer.setIndent(indent);
            writer.setUnicodeNormalization(true);
            writer.setHandler(new StreamResult(out), null);
            writer.handler.startDocument();
            writer.handler.startPrefixMapping("marc", "http://www.loc.gov/MARC21/slim");
            writer.toXml(record);
            if (indent) {
                writer.handler.ignorableWhitespace("\n".toCharArray(), 0, 1);
            }
            writer.handler.endPrefixMapping("http://www.loc.gov/MARC21/slim");
            writer.handler.endDocument();
            out.write("\n");
            out.close();
        }
        catch (SAXException details) {
            throw new MarcException("SAX error occured while writing record", details);
        }
        catch (UnsupportedEncodingException details) {
            throw new MarcException(details.getMessage(), details);
        }
    }

    public boolean hasIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    protected void toXml(Record record) throws SAXException {
        if (!MarcFactory.newInstance().validateRecord(record)) {
            throw new MarcException("Marc record didn't validate");
        }
        AttributesImpl atts = new AttributesImpl();
        if (this.indent) {
            this.handler.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
        }
        if (record.getType() != null) {
            AttributesImpl rAtts = new AttributesImpl();
            rAtts.addAttribute("", "type", "type", "", record.getType());
            this.handler.startElement("http://www.loc.gov/MARC21/slim", RECORD, "marc:record", rAtts);
        } else {
            this.handler.startElement("http://www.loc.gov/MARC21/slim", RECORD, "marc:record", atts);
        }
        if (this.indent) {
            this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
        }
        this.handler.startElement("http://www.loc.gov/MARC21/slim", LEADER, "marc:leader", atts);
        Leader leader = record.getLeader();
        char[] temp = this.getDataElement(leader.toString());
        this.handler.characters(temp, 0, temp.length);
        this.handler.endElement("http://www.loc.gov/MARC21/slim", LEADER, "marc:leader");
        for (ControlField controlField : record.getControlFields()) {
            atts = new AttributesImpl();
            atts.addAttribute("", "tag", "tag", "CDATA", this.getDataElementString(controlField.getTag()));
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.startElement("http://www.loc.gov/MARC21/slim", CONTROL_FIELD, "marc:controlfield", atts);
            temp = this.getDataElement(controlField.getData());
            this.handler.characters(temp, 0, temp.length);
            this.handler.endElement("http://www.loc.gov/MARC21/slim", CONTROL_FIELD, "marc:controlfield");
        }
        for (DataField dataField : record.getDataFields()) {
            atts = new AttributesImpl();
            atts.addAttribute("", "tag", "tag", "CDATA", this.getDataElementString(dataField.getTag()));
            atts.addAttribute("", "ind1", "ind1", "CDATA", this.getDataElementString(String.valueOf(dataField.getIndicator1())));
            atts.addAttribute("", "ind2", "ind2", "CDATA", this.getDataElementString(String.valueOf(dataField.getIndicator2())));
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.startElement("http://www.loc.gov/MARC21/slim", DATA_FIELD, "marc:datafield", atts);
            for (Subfield subfield : dataField.getSubfields()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "code", "code", "CDATA", this.getDataElementString(String.valueOf(subfield.getCode())));
                if (this.indent) {
                    this.handler.ignorableWhitespace("\n      ".toCharArray(), 0, 7);
                }
                this.handler.startElement("http://www.loc.gov/MARC21/slim", SUBFIELD, "marc:subfield", atts);
                temp = this.getDataElement(subfield.getData());
                this.handler.characters(temp, 0, temp.length);
                this.handler.endElement("http://www.loc.gov/MARC21/slim", SUBFIELD, "marc:subfield");
            }
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.endElement("http://www.loc.gov/MARC21/slim", DATA_FIELD, "marc:datafield");
        }
        if (this.indent) {
            this.handler.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
        }
        this.handler.endElement("http://www.loc.gov/MARC21/slim", RECORD, "marc:record");
    }

    protected String getDataElementString(String data2) {
        String dataElement = null;
        dataElement = this.converter == null ? data2 : this.converter.convert(data2);
        if (this.normalize) {
            dataElement = Normalizer.normalize(dataElement, Normalizer.Form.NFC);
        }
        if (this.checkNonXMLChars) {
            dataElement = this.CheckNonXMLChars(dataElement);
        }
        return dataElement;
    }

    protected char[] getDataElement(String data2) {
        return this.getDataElementString(data2).toCharArray();
    }

    protected String CheckNonXMLChars(String dataElement) {
        StringBuffer out = new StringBuffer(dataElement.length());
        for (char ch : dataElement.toCharArray()) {
            if (MarcXmlWriter.isInvalidXmlChar(ch)) {
                out.append(UnicodeUtils.convertUnicodeToUnicodeBNF(Character.valueOf(ch)));
                continue;
            }
            out.append(ch);
        }
        return out.toString();
    }

    private static boolean isInvalidXmlChar(char ch) {
        String s = Character.toString(ch);
        if (!valid.matcher(s).matches()) {
            return true;
        }
        if (ctrlChar.matcher(s).matches()) {
            return true;
        }
        return discouraged.matcher(s).matches();
    }

    @Override
    public boolean expectsUnicode() {
        return this.converter == null;
    }
}

