/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.OutputStream;
import org.marc4j.MarcJsonWriter;
import org.marc4j.MarcSplitStreamWriter;
import org.marc4j.MarcStreamWriter;
import org.marc4j.MarcTxtWriter;
import org.marc4j.MarcWriter;
import org.marc4j.MarcXmlWriter;
import org.marc4j.Mrk8StreamWriter;
import org.marc4j.converter.impl.UnicodeToAnsel;

public class MarcWriterFactory {
    public static MarcWriter makeWriterFromConvertString(String convertString, OutputStream out) {
        String[] convertParts;
        String convert = "text";
        boolean pretty = false;
        boolean normalize = false;
        boolean oversize = false;
        int splitAt = 0;
        for (String part : convertParts = convertString.split("[;:_, ]+")) {
            if (part.equalsIgnoreCase("text") || part.equalsIgnoreCase("ASCII")) {
                convert = "text";
                continue;
            }
            if (part.equalsIgnoreCase("errors")) {
                convert = "errors";
                continue;
            }
            if (part.equalsIgnoreCase("XML") || part.equalsIgnoreCase("MARCXML")) {
                convert = "xml";
                continue;
            }
            if (part.equalsIgnoreCase("MARC_IN_JSON") || part.equalsIgnoreCase("json")) {
                convert = "json";
                continue;
            }
            if (part.equalsIgnoreCase("MARC_JSON") || part.equalsIgnoreCase("json2")) {
                convert = "json2";
                continue;
            }
            if (part.equalsIgnoreCase("UTF8") || part.equalsIgnoreCase("UTF-8")) {
                convert = "utf8";
                continue;
            }
            if (part.equalsIgnoreCase("RAW") || part.equalsIgnoreCase("raw")) {
                convert = "raw";
                continue;
            }
            if (part.equalsIgnoreCase("MARC8")) {
                convert = "marc8";
                continue;
            }
            if (part.equalsIgnoreCase("MARC8NCR") || part.equalsIgnoreCase("NCR")) {
                convert = "marc8ncr";
                continue;
            }
            if (part.equalsIgnoreCase("MRK8") || part.equalsIgnoreCase("MARCEDIT")) {
                convert = "mrk8";
                continue;
            }
            if (part.matches("([0-9][0-9][0-9]|err)(:([0-9][0-9][0-9]|err))*")) {
                convert = part;
                continue;
            }
            if (part.equalsIgnoreCase("pretty") || part.equalsIgnoreCase("indent")) {
                pretty = true;
                continue;
            }
            if (part.equalsIgnoreCase("normalize") || part.equalsIgnoreCase("normalized")) {
                normalize = true;
                continue;
            }
            if (part.startsWith("split")) {
                splitAt = 70000;
                continue;
            }
            if (!part.equalsIgnoreCase("oversize")) continue;
            oversize = true;
        }
        return MarcWriterFactory.makeWriterFromConvertParm(convert, pretty, normalize, oversize, splitAt, out);
    }

    public static MarcWriter makeWriterFromConvertParm(String convert, boolean pretty, boolean normalize, boolean oversize, int splitAt, OutputStream out) {
        MarcWriter writer = null;
        if (convert.equalsIgnoreCase("text") || convert.equalsIgnoreCase("ASCII")) {
            writer = new MarcTxtWriter(out);
        } else if (convert.equalsIgnoreCase("errors")) {
            writer = new MarcTxtWriter(out, "001;err");
        } else if (convert.matches("([0-9][0-9][0-9]|err)(:([0-9][0-9][0-9]|err))*")) {
            writer = new MarcTxtWriter(out, convert);
        } else if (convert.equalsIgnoreCase("XML") || convert.equalsIgnoreCase("MARCXML")) {
            MarcXmlWriter xmlwriter = new MarcXmlWriter(out, "UTF8");
            if (pretty) {
                xmlwriter.setIndent(true);
            }
            if (normalize) {
                xmlwriter.setUnicodeNormalization(true);
            }
            writer = xmlwriter;
        } else if (convert.equalsIgnoreCase("MARC_IN_JSON") || convert.equalsIgnoreCase("json")) {
            MarcJsonWriter jsonwriter = new MarcJsonWriter(out, 0);
            if (pretty) {
                jsonwriter.setIndent(true);
            }
            if (normalize) {
                jsonwriter.setUnicodeNormalization(true);
            }
            writer = jsonwriter;
        } else if (convert.equalsIgnoreCase("MARC_JSON") || convert.equalsIgnoreCase("json2")) {
            MarcJsonWriter jsonwriter = new MarcJsonWriter(out, 1);
            if (pretty) {
                jsonwriter.setIndent(true);
            }
            if (normalize) {
                jsonwriter.setUnicodeNormalization(true);
            }
            writer = jsonwriter;
        } else if (convert.equalsIgnoreCase("UTF8") || convert.equalsIgnoreCase("UTF-8")) {
            MarcStreamWriter binwriter;
            if (splitAt == 0) {
                binwriter = new MarcStreamWriter(out, "UTF8", true);
                binwriter.setAllowOversizeEntry(oversize);
            } else {
                binwriter = new MarcSplitStreamWriter(out, splitAt, "UTF8");
            }
            writer = binwriter;
        } else if (convert.equalsIgnoreCase("raw")) {
            MarcStreamWriter binwriter;
            if (splitAt == 0) {
                binwriter = new MarcStreamWriter(out, "per_record", true);
                binwriter.setAllowOversizeEntry(oversize);
            } else {
                binwriter = new MarcSplitStreamWriter(out, splitAt, "UTF8");
            }
            writer = binwriter;
        } else if (convert.equalsIgnoreCase("MARC8") || convert.equalsIgnoreCase("MARC8NCR") || convert.equalsIgnoreCase("NCR")) {
            MarcStreamWriter binwriter;
            if (splitAt == 0) {
                binwriter = new MarcStreamWriter(out, "ISO8859_1", true);
                binwriter.setAllowOversizeEntry(oversize);
            } else {
                binwriter = new MarcSplitStreamWriter(out, splitAt, "ISO8859_1");
            }
            binwriter.setConverter(new UnicodeToAnsel(convert.contains("NCR")));
            writer = binwriter;
        } else if (convert.equalsIgnoreCase("MRK8")) {
            Mrk8StreamWriter mrkwriter = new Mrk8StreamWriter(out);
            writer = mrkwriter;
        } else {
            throw new IllegalArgumentException("Error : Unknown output format: " + convert);
        }
        return writer;
    }
}

