/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.InputStream;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.MarcXmlReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcUnprettyXmlReader
implements MarcReader {
    private MarcXmlReader reader = null;

    public MarcUnprettyXmlReader(InputStream input) {
        this.reader = new MarcXmlReader(input);
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Record next() {
        Record rec = this.reader.next();
        rec.getLeader().setCharCodingScheme('a');
        List<VariableField> varFields = rec.getVariableFields();
        for (VariableField f : varFields) {
            if (f instanceof ControlField) {
                ControlField cf = (ControlField)f;
                String data2 = cf.getData();
                if (!data2.contains("\n")) continue;
                data2 = data2.replaceAll("\\r?\\n[ \t]*", " ");
                data2 = data2.trim();
                cf.setData(data2);
                continue;
            }
            if (!(f instanceof DataField)) continue;
            DataField df = (DataField)f;
            List<Subfield> subFields = df.getSubfields();
            for (Subfield s : subFields) {
                Subfield sf = s;
                String data3 = sf.getData();
                if (!data3.contains("\n")) continue;
                data3 = data3.replaceAll("\\r?\\n[ \t]*", " ");
                data3 = data3.trim();
                sf.setData(data3);
            }
        }
        return rec;
    }
}

