/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.impl.Verifier;
import org.marc4j.util.Encoding;

public class MarcStreamReader
implements MarcReader {
    private DataInputStream input = null;
    private Record record;
    private final MarcFactory factory;
    private Encoding encoding = Encoding.ISO8859_1;
    private boolean override = false;
    private CharConverter converterAnsel = null;

    public MarcStreamReader(InputStream input) {
        this(input, null);
    }

    public MarcStreamReader(InputStream input, String encoding) {
        Encoding candidate;
        this.input = new DataInputStream(input.markSupported() ? input : new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        if (encoding != null && (candidate = Encoding.get(encoding)) != null) {
            this.encoding = candidate;
            this.override = true;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            this.input.mark(10);
            if (this.input.read() == -1) {
                return false;
            }
            this.input.reset();
        }
        catch (IOException e) {
            throw new MarcException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public Record next() {
        this.record = this.factory.newRecord();
        try {
            byte[] byteArray = new byte[24];
            this.input.readFully(byteArray);
            int recordLength = this.parseRecordLength(byteArray);
            byte[] recordBuf = new byte[recordLength - 24];
            this.input.readFully(recordBuf);
            this.parseRecord(this.record, byteArray, recordBuf, recordLength);
            return this.record;
        }
        catch (EOFException e) {
            throw new MarcException("Premature end of file encountered", e);
        }
        catch (IOException e) {
            throw new MarcException("an error occured reading input", e);
        }
    }

    private void parseRecord(Record record, byte[] aByteArray, byte[] recordBuf, int recordLength) {
        byte[] byteArray = aByteArray;
        Leader ldr = this.factory.newLeader();
        ldr.setRecordLength(recordLength);
        int directoryLength = 0;
        try {
            this.parseLeader(ldr, byteArray);
            directoryLength = ldr.getBaseAddressOfData() - 25;
        }
        catch (IOException e) {
            throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
        }
        catch (MarcException e) {
            throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
        }
        switch (ldr.getCharCodingScheme()) {
            case ' ': {
                if (this.override) break;
                this.encoding = Encoding.ISO8859_1;
                break;
            }
            case 'a': {
                if (this.override) break;
                this.encoding = Encoding.UTF8;
            }
        }
        record.setLeader(ldr);
        if (directoryLength % 12 != 0) {
            throw new MarcException("invalid directory");
        }
        DataInputStream inputrec = new DataInputStream(new ByteArrayInputStream(recordBuf));
        int size = directoryLength / 12;
        String[] tags = new String[size];
        int[] lengths = new int[size];
        int[] starts = new int[size];
        HashMap<Integer, Integer> unsortedStartIndex = new HashMap<Integer, Integer>();
        byte[] tag = new byte[3];
        byte[] length = new byte[4];
        byte[] start = new byte[5];
        try {
            int i;
            for (i = 0; i < size; ++i) {
                String tmp;
                inputrec.readFully(tag);
                tags[i] = tmp = new String(tag);
                inputrec.readFully(length);
                tmp = new String(length);
                lengths[i] = Integer.parseInt(tmp);
                inputrec.readFully(start);
                tmp = new String(start);
                starts[i] = Integer.parseInt(tmp);
                unsortedStartIndex.put(starts[i], i);
            }
            Arrays.sort(starts);
            if (inputrec.read() != 30) {
                throw new MarcException("expected field terminator at end of directory");
            }
            i = 0;
            for (int s = 0; s < size; ++s) {
                i = (Integer)unsortedStartIndex.get(starts[s]);
                this.getFieldLength(inputrec);
                if (Verifier.isControlField(tags[i])) {
                    byteArray = new byte[lengths[i] - 1];
                    inputrec.readFully(byteArray);
                    if (inputrec.read() != 30) {
                        throw new MarcException("expected field terminator at end of field");
                    }
                    ControlField field = this.factory.newControlField();
                    field.setTag(tags[i]);
                    field.setData(this.getDataAsString(byteArray));
                    record.addVariableField(field);
                    continue;
                }
                byteArray = new byte[lengths[i]];
                inputrec.readFully(byteArray);
                try {
                    record.addVariableField(this.parseDataField(tags[i], byteArray));
                    continue;
                }
                catch (IOException e) {
                    throw new MarcException("error parsing data field for tag: " + tags[i] + " with data: " + new String(byteArray), e);
                }
            }
            if (inputrec.read() != 29) {
                throw new MarcException("expected record terminator");
            }
        }
        catch (IOException e) {
            throw new MarcException("an error occured reading input", e);
        }
    }

    private DataField parseDataField(String tag, byte[] field) throws IOException {
        int readByte;
        ByteArrayInputStream bais = new ByteArrayInputStream(field);
        char ind1 = (char)bais.read();
        char ind2 = (char)bais.read();
        DataField dataField = this.factory.newDataField();
        dataField.setTag(tag);
        dataField.setIndicator1(ind1);
        dataField.setIndicator2(ind2);
        while ((readByte = bais.read()) >= 0) {
            switch (readByte) {
                case 31: {
                    int code = bais.read();
                    if (code < 0) {
                        throw new IOException("unexpected end of data field");
                    }
                    if (code == 30) break;
                    int size = this.getSubfieldLength(bais);
                    byte[] data2 = new byte[size];
                    bais.read(data2);
                    Subfield subfield = this.factory.newSubfield();
                    subfield.setCode((char)code);
                    subfield.setData(this.getDataAsString(data2));
                    dataField.addSubfield(subfield);
                    break;
                }
            }
        }
        return dataField;
    }

    private int getFieldLength(DataInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    throw new IOException("Field not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int getSubfieldLength(ByteArrayInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: 
                case 31: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    throw new IOException("subfield not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int parseRecordLength(byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(leaderData), "ISO-8859-1");
        int length = -1;
        char[] tmp = new char[5];
        isr.read(tmp);
        try {
            length = Integer.parseInt(new String(tmp));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse record length", e);
        }
        return length;
    }

    private void parseLeader(Leader ldr, byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(leaderData), "ISO-8859-1");
        char[] tmp = new char[5];
        isr.read(tmp);
        ldr.setRecordStatus((char)isr.read());
        ldr.setTypeOfRecord((char)isr.read());
        tmp = new char[2];
        isr.read(tmp);
        ldr.setImplDefined1(tmp);
        ldr.setCharCodingScheme((char)isr.read());
        char indicatorCount = (char)isr.read();
        char subfieldCodeLength = (char)isr.read();
        char[] baseAddr = new char[5];
        isr.read(baseAddr);
        tmp = new char[3];
        isr.read(tmp);
        ldr.setImplDefined2(tmp);
        tmp = new char[4];
        isr.read(tmp);
        ldr.setEntryMap(tmp);
        isr.close();
        try {
            ldr.setIndicatorCount(Integer.parseInt(String.valueOf(indicatorCount)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse indicator count", e);
        }
        try {
            ldr.setSubfieldCodeLength(Integer.parseInt(String.valueOf(subfieldCodeLength)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse subfield code length", e);
        }
        try {
            ldr.setBaseAddressOfData(Integer.parseInt(new String(baseAddr)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse base address of data", e);
        }
    }

    private String getDataAsString(byte[] bytes) {
        String dataElement = null;
        if (this.encoding.equals((Object)Encoding.UTF8) || this.encoding.equals((Object)Encoding.ISO8859_1)) {
            try {
                dataElement = new String(bytes, this.encoding.getStandardName());
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        if (this.encoding.equals((Object)Encoding.MARC8)) {
            if (this.converterAnsel == null) {
                this.converterAnsel = new AnselToUnicode();
            }
            dataElement = this.converterAnsel.convert(bytes);
        } else if (this.override) {
            try {
                dataElement = new String(bytes, this.encoding.getStandardName());
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        return dataElement;
    }
}

