/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.Properties;

public class MarcReaderConfig {
    private boolean permissiveReader;
    private String defaultEncoding;
    private boolean to_utf_8;
    private String combineConsecutiveRecordsFields = null;
    private String combineRecordsLeftField = null;
    private String combineRecordsRightField = null;
    private String unicodeNormalize = null;
    private String includeIfPresent = null;
    private String includeIfMissing = null;
    private String marcDeleteSubfields = null;
    private String marcRemapFile = null;

    public MarcReaderConfig(Properties configProps) {
        this.setCombineConsecutiveRecordsFields(configProps.getProperty("marc.combine_records"), configProps.getProperty("marc.combine_records.left_field"), configProps.getProperty("marc.combine_records.right_field"));
        this.setPermissiveReader(Boolean.parseBoolean(configProps.getProperty("marc.permissive")));
        this.setDefaultEncoding(configProps.getProperty("marc.default_encoding"));
        this.setToUtf8(Boolean.parseBoolean(configProps.getProperty("marc.to_utf_8")));
        this.setUnicodeNormalize(configProps.getProperty("marc.unicode_normalize"));
        this.setFilterParams(configProps.getProperty("marc.include_if_present"), configProps.getProperty("marc.include_if_missing"));
        this.setDeleteSubfieldSpec(configProps.getProperty("marc.delete_subfields"));
        this.setMarcRemapFilename(configProps.getProperty("marc.reader.remap"));
    }

    public MarcReaderConfig() {
        this.defaultEncoding = null;
        this.permissiveReader = false;
        this.to_utf_8 = false;
        this.combineConsecutiveRecordsFields = null;
        this.unicodeNormalize = null;
    }

    public boolean isPermissiveReader() {
        return this.permissiveReader;
    }

    public MarcReaderConfig setPermissiveReader(boolean permissiveReader) {
        this.permissiveReader = permissiveReader;
        return this;
    }

    public String getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            return this.isPermissiveReader() ? "BESTGUESS" : "MARC8";
        }
        return this.defaultEncoding;
    }

    public MarcReaderConfig setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding == null ? null : defaultEncoding.trim();
        return this;
    }

    public boolean toUtf8() {
        return this.to_utf_8;
    }

    public MarcReaderConfig setToUtf8(boolean to_utf_8) {
        this.to_utf_8 = to_utf_8;
        return this;
    }

    public String getCombineConsecutiveRecordsFields() {
        return this.combineConsecutiveRecordsFields;
    }

    public String getCombineRecordsLeftField() {
        return this.combineRecordsLeftField;
    }

    public String getCombineRecordsRightField() {
        return this.combineRecordsRightField;
    }

    public MarcReaderConfig setCombineConsecutiveRecordsFields(String combineConsecutiveRecordsFields, String leftField, String rightField) {
        this.combineConsecutiveRecordsFields = combineConsecutiveRecordsFields;
        if (combineConsecutiveRecordsFields != null && combineConsecutiveRecordsFields.length() == 0) {
            this.combineConsecutiveRecordsFields = null;
        }
        this.combineRecordsLeftField = leftField;
        this.combineRecordsRightField = rightField;
        return this;
    }

    public MarcReaderConfig setCombineConsecutiveRecordsFields(String combineConsecutiveRecordsFieldsStr) {
        if (combineConsecutiveRecordsFieldsStr == null || combineConsecutiveRecordsFieldsStr.isEmpty()) {
            return this.setCombineConsecutiveRecordsFields(null, null, null);
        }
        String[] combineParms = combineConsecutiveRecordsFieldsStr.split("::", 3);
        String fieldList = combineParms.length >= 1 ? combineParms[0] : null;
        String leftField = combineParms.length >= 2 ? combineParms[1] : null;
        String rightField = combineParms.length >= 3 ? combineParms[2] : null;
        return this.setCombineConsecutiveRecordsFields(fieldList, leftField, rightField);
    }

    public String getUnicodeNormalize() {
        return this.unicodeNormalize;
    }

    public MarcReaderConfig setUnicodeNormalize(String unicodeNormalizeStr) {
        this.unicodeNormalize = unicodeNormalizeStr == null ? null : (unicodeNormalizeStr.equalsIgnoreCase("KC") || unicodeNormalizeStr.equalsIgnoreCase("CompatibilityCompose") ? "KC" : (unicodeNormalizeStr.equalsIgnoreCase("C") || unicodeNormalizeStr.equalsIgnoreCase("Compose") || unicodeNormalizeStr.equalsIgnoreCase("true") ? "C" : (unicodeNormalizeStr.equalsIgnoreCase("D") || unicodeNormalizeStr.equalsIgnoreCase("Decompose") ? "D" : (unicodeNormalizeStr.equalsIgnoreCase("KD") || unicodeNormalizeStr.equalsIgnoreCase("CompatibiltyDecompose") ? "KD" : null))));
        return this;
    }

    public String getIncludeIfPresent() {
        return this.includeIfPresent;
    }

    public String getIncludeIfMissing() {
        return this.includeIfMissing;
    }

    public boolean shouldFilter() {
        return this.includeIfPresent != null || this.includeIfMissing != null;
    }

    public MarcReaderConfig setFilterParams(String ifPresent, String ifMissing) {
        this.includeIfPresent = ifPresent;
        this.includeIfMissing = ifMissing;
        return this;
    }

    public String getDeleteSubfieldSpec() {
        return this.marcDeleteSubfields;
    }

    public MarcReaderConfig setDeleteSubfieldSpec(String marcDeleteSubfields) {
        this.marcDeleteSubfields = marcDeleteSubfields != null ? (marcDeleteSubfields.equals("nomap") ? null : marcDeleteSubfields.trim()) : null;
        return this;
    }

    public String getMarcRemapFilename() {
        return this.marcRemapFile;
    }

    public MarcReaderConfig setMarcRemapFilename(String marcRemapFile) {
        this.marcRemapFile = marcRemapFile != null ? (marcRemapFile.equals("nomap") ? null : marcRemapFile.trim()) : null;
        return this;
    }
}

