/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marc4j.ConverterErrorHandler;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.Iso5426ToUnicode;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.Verifier;

public class MarcPermissiveStreamReader
implements MarcReader,
ConverterErrorHandler {
    private DataInputStream input = null;
    private Record record;
    private String currentField;
    private String currentSubfield;
    private final MarcFactory factory;
    private String encoding = "ISO8859_1";
    private String defaultEncoding = "ISO8859_1";
    private boolean convertToUTF8 = false;
    private boolean permissive = false;
    private boolean translateLosslessUnicodeNumericCodeReferencesEnabled = true;
    private int marc_file_lookahead_buffer = 200000;
    private AnselToUnicode converterAnsel = null;
    private CharConverter converterUnimarc = null;
    private String conversionCheck1 = null;
    private String conversionCheck2 = null;
    private String conversionCheck3 = null;
    private final ErrorHandler errors;
    static String validSubfieldCodes = "abcdefghijklmnopqrstuvwxyz0123456789";
    static String upperCaseSubfieldsProperty = "org.marc4j.MarcPermissiveStreamReader.upperCaseSubfields";
    static AnselToUnicode conv = null;
    static byte[] badEsc = new byte[]{98, 45, 27, 115};
    static byte[] overbar = new byte[]{-81};

    public MarcPermissiveStreamReader(InputStream input, boolean permissive, boolean convertToUTF8) {
        this.permissive = permissive;
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.errors = null;
        if (permissive) {
            this.defaultEncoding = "BESTGUESS";
        }
    }

    @Deprecated
    public MarcPermissiveStreamReader(InputStream input, ErrorHandler errors, boolean convertToUTF8) {
        if (errors != null) {
            this.permissive = true;
            this.defaultEncoding = "BESTGUESS";
        }
        this.input = new DataInputStream(input.markSupported() ? input : new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.errors = errors;
    }

    public MarcPermissiveStreamReader(InputStream input, boolean permissive, boolean convertToUTF8, String defaultEncoding) {
        this.permissive = permissive;
        this.input = new DataInputStream(input.markSupported() ? input : new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.defaultEncoding = defaultEncoding;
        this.errors = null;
    }

    @Deprecated
    public MarcPermissiveStreamReader(InputStream input, ErrorHandler errors, boolean convertToUTF8, String defaultEncoding) {
        this.permissive = true;
        this.input = new DataInputStream(new BufferedInputStream(input));
        this.factory = MarcFactory.newInstance();
        this.convertToUTF8 = convertToUTF8;
        this.defaultEncoding = defaultEncoding;
        this.errors = errors;
    }

    public boolean isTranslateLosslessUnicodeNumericCodeReferencesEnabled() {
        return this.translateLosslessUnicodeNumericCodeReferencesEnabled;
    }

    public void setTranslateLosslessUnicodeNumericCodeReferencesEnabled(boolean translateLosslessUnicodeNumericCodeReferencesEnabled) {
        this.translateLosslessUnicodeNumericCodeReferencesEnabled = translateLosslessUnicodeNumericCodeReferencesEnabled;
    }

    @Override
    public boolean hasNext() {
        try {
            this.input.mark(10);
            int byteread = this.input.read();
            if (byteread == -1) {
                return false;
            }
            int numBadBytes = 0;
            while (byteread < 48 || byteread > 57) {
                byteread = this.input.read();
                ++numBadBytes;
                if (byteread != -1) continue;
                return false;
            }
            this.input.reset();
            while (numBadBytes > 0) {
                byteread = this.input.read();
                --numBadBytes;
            }
        }
        catch (IOException e) {
            throw new MarcException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public Record next() {
        this.record = this.factory.newRecord();
        if (this.errors != null) {
            this.errors.reset();
        }
        try {
            byte[] byteArray = new byte[24];
            this.input.readFully(byteArray);
            int recordLength = this.parseRecordLength(byteArray);
            byte[] recordBuf = new byte[recordLength - 24];
            if (this.permissive) {
                this.input.mark(this.marc_file_lookahead_buffer);
                try {
                    this.input.readFully(recordBuf);
                }
                catch (EOFException e) {
                    this.input.reset();
                    this.input.mark(this.marc_file_lookahead_buffer);
                    int toRead = this.input.available();
                    recordBuf = new byte[toRead];
                    this.input.readFully(recordBuf);
                }
                if (recordBuf[recordBuf.length - 1] != 29) {
                    this.record.addError("n/a", "n/a", 3, "Record terminator character not found at end of record length");
                    recordBuf = this.rereadPermissively(this.record, this.input, recordBuf, recordLength);
                    recordLength = recordBuf.length + 24;
                }
            } else {
                this.input.readFully(recordBuf);
            }
            this.parseRecord(this.record, byteArray, recordBuf, recordLength);
            if (this.convertToUTF8) {
                Leader l = this.record.getLeader();
                l.setCharCodingScheme('a');
                this.record.setLeader(l);
            }
            if (this.errors != null && this.record.hasErrors()) {
                this.errors.addErrors(this.record.getControlNumber(), this.record.getErrors());
            }
            return this.record;
        }
        catch (EOFException e) {
            throw new MarcException("Premature end of file encountered", e);
        }
        catch (IOException e) {
            throw new MarcException("an error occured reading input", e);
        }
    }

    private byte[] rereadPermissively(Record record, DataInputStream input, byte[] recordBuf, int recordLength) throws IOException {
        int loc = this.arrayContainsAt(recordBuf, 29);
        if (loc != -1) {
            record.addError("n/a", "n/a", 3, "Record terminator appears before stated record length, using shorter record");
            recordLength = loc + 24;
            input.reset();
            recordBuf = new byte[recordLength - 24];
            input.readFully(recordBuf);
        } else {
            loc = recordLength - 24;
            boolean done = false;
            while (!done) {
                int c = 0;
                do {
                    c = input.read();
                } while (++loc < this.marc_file_lookahead_buffer - 24 && c != 29 && c != -1);
                if (c == 29) {
                    record.addError("n/a", "n/a", 3, "Record terminator appears after stated record length, reading extra bytes");
                    recordLength = loc + 24;
                    input.reset();
                    recordBuf = new byte[recordLength - 24];
                    input.readFully(recordBuf);
                    done = true;
                    continue;
                }
                if (c == -1) {
                    record.addError("n/a", "n/a", 3, "No Record terminator found, end of file reached, Terminator appended");
                    recordLength = loc + 24;
                    input.reset();
                    recordBuf = new byte[recordLength - 24 + 1];
                    input.readFully(recordBuf);
                    recordBuf[recordBuf.length - 1] = 29;
                    done = true;
                    continue;
                }
                record.addError("n/a", "n/a", 4, "No Record terminator found within " + this.marc_file_lookahead_buffer + " bytes of start of record, getting desperate.");
                input.reset();
                this.marc_file_lookahead_buffer *= 2;
                input.mark(this.marc_file_lookahead_buffer);
                loc = 0;
            }
        }
        return recordBuf;
    }

    private void parseRecord(Record record, byte[] byteArray, byte[] recordBuf, int recordLength) {
        String dirEntry;
        int i;
        Leader ldr;
        int directoryLength;
        block86: {
            int i2;
            String utfCheck;
            block85: {
                directoryLength = 0;
                ldr = this.factory.newLeader();
                ldr.setRecordLength(recordLength);
                this.conversionCheck1 = "";
                this.conversionCheck2 = "";
                this.conversionCheck3 = "";
                try {
                    this.parseLeader(ldr, byteArray);
                    directoryLength = ldr.getBaseAddressOfData() - 25;
                }
                catch (IOException e) {
                    throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                }
                catch (MarcException e) {
                    if (this.permissive) {
                        byte[] oldBody;
                        int offset;
                        if (recordBuf[recordBuf.length - 1] != 29 || recordBuf[recordBuf.length - 2] != 30) break block85;
                        record.addError("n/a", "n/a", 3, "Error parsing leader, trying to re-read leader either shorter or longer");
                        for (offset = 0; offset < recordBuf.length && recordBuf[offset] != 30; ++offset) {
                        }
                        if (offset % 12 == 1) {
                            record.addError("n/a", "n/a", 3, "Leader appears to be too short, moving one byte from record body to leader, and trying again");
                            oldBody = recordBuf;
                            recordBuf = new byte[oldBody.length - 1];
                            System.arraycopy(oldBody, 1, recordBuf, 0, oldBody.length - 1);
                            directoryLength = offset - 1;
                            ldr.setIndicatorCount(2);
                            ldr.setSubfieldCodeLength(2);
                            ldr.setImplDefined1(("" + (char)byteArray[7] + " ").toCharArray());
                            ldr.setImplDefined2(("" + (char)byteArray[18] + (char)byteArray[19] + (char)byteArray[20]).toCharArray());
                            ldr.setEntryMap("4500".toCharArray());
                            if (byteArray[10] == 32 || byteArray[10] == 97) {
                                ldr.setCharCodingScheme((char)byteArray[10]);
                            }
                        }
                        if (offset % 12 == 11) {
                            record.addError("n/a", "n/a", 3, "Leader appears to be too long, moving one byte from leader to record body, and trying again");
                            oldBody = recordBuf;
                            recordBuf = new byte[oldBody.length + 1];
                            System.arraycopy(oldBody, 0, recordBuf, 1, oldBody.length);
                            recordBuf[0] = 48;
                            directoryLength = offset + 1;
                            ldr.setIndicatorCount(2);
                            ldr.setSubfieldCodeLength(2);
                            ldr.setImplDefined1(("" + (char)byteArray[7] + " ").toCharArray());
                            ldr.setImplDefined2(("" + (char)byteArray[16] + (char)byteArray[17] + (char)byteArray[18]).toCharArray());
                            ldr.setEntryMap("4500".toCharArray());
                            if (byteArray[8] == 32 || byteArray[8] == 97) {
                                ldr.setCharCodingScheme((char)byteArray[10]);
                            }
                            if (byteArray[10] == 32 || byteArray[10] == 97) {
                                ldr.setCharCodingScheme((char)byteArray[10]);
                            }
                        }
                        record.addError("n/a", "n/a", 4, "error parsing leader with data: " + new String(byteArray));
                        throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                    }
                    throw new MarcException("error parsing leader with data: " + new String(byteArray), e);
                }
            }
            char[] tmp = ldr.getEntryMap();
            if (this.permissive && !("" + tmp[0] + tmp[1] + tmp[2] + tmp[3]).equals("4500")) {
                if (tmp[0] >= '0' && tmp[0] <= '9' && tmp[1] >= '0' && tmp[1] <= '9' && tmp[2] >= '0' && tmp[2] <= '9' && tmp[3] >= '0' && tmp[3] <= '9') {
                    record.addError("n/a", "n/a", 1, "Unusual character found at end of leader [ " + tmp[0] + tmp[1] + tmp[2] + tmp[3] + " ]");
                } else {
                    record.addError("n/a", "n/a", 1, "Erroneous character found at end of leader [ " + tmp[0] + tmp[1] + tmp[2] + tmp[3] + " ]; changing them to the standard \"4500\"");
                    ldr.setEntryMap("4500".toCharArray());
                }
            }
            switch (ldr.getCharCodingScheme()) {
                case 'a': {
                    this.encoding = "UTF8";
                    break;
                }
                case ' ': {
                    if (this.convertToUTF8) {
                        this.encoding = this.defaultEncoding;
                        break;
                    }
                    this.encoding = "ISO8859_1";
                    break;
                }
                default: {
                    if (this.convertToUTF8) {
                        if (this.permissive) {
                            record.addError("n/a", "n/a", 2, "Record character encoding should be 'a' or ' ' in this record it is '" + ldr.getCharCodingScheme() + "'. Attempting to guess the correct encoding.");
                            this.encoding = "BESTGUESS";
                            break;
                        }
                        this.encoding = this.defaultEncoding;
                        break;
                    }
                    this.encoding = "ISO8859_1";
                }
            }
            if (this.encoding.equalsIgnoreCase("BESTGUESS")) {
                try {
                    String marc8EscSeqCheck = new String(recordBuf, "ISO-8859-1");
                    if (marc8EscSeqCheck.split("\\e[-(,)$bsp]", 2).length > 1) {
                        this.encoding = "MARC8";
                        break block86;
                    }
                    boolean hasHighBitChars = false;
                    for (int i3 = 0; i3 < recordBuf.length; ++i3) {
                        if (recordBuf[i3] >= 0) continue;
                        hasHighBitChars = true;
                        break;
                    }
                    if (!hasHighBitChars) {
                        this.encoding = "ISO8859_1";
                        break block86;
                    }
                    utfCheck = new String(recordBuf, "UTF-8");
                    byte[] byteCheck = utfCheck.getBytes("UTF-8");
                    this.encoding = "UTF8";
                    if (recordBuf.length == byteCheck.length) {
                        for (i2 = 0; i2 < recordBuf.length; ++i2) {
                            if (byteCheck[i2] == recordBuf[i2]) continue;
                            this.encoding = "MARC8-Maybe";
                            break block86;
                        }
                        break block86;
                    }
                    this.encoding = "MARC8-Maybe";
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (this.permissive && this.encoding.equals("UTF8")) {
                try {
                    utfCheck = new String(recordBuf, "UTF-8");
                    byte[] byteCheck = utfCheck.getBytes("UTF-8");
                    if (recordBuf.length != byteCheck.length) {
                        boolean foundESC = false;
                        int minLen = recordBuf.length;
                        if (byteCheck.length < minLen) {
                            minLen = byteCheck.length;
                            record.addError("n/a", "n/a", 2, "Record claims to be UTF-8, but a possible bad encoding was found. It could be a different encoding, or it could be malformed UTF8 data.");
                        }
                        for (i2 = 0; i2 < minLen; ++i2) {
                            if (recordBuf[i2] == 27) {
                                record.addError("n/a", "n/a", 2, "Record claims to be UTF-8, but its not. Its probably MARC8.");
                                this.encoding = "MARC8-Maybe";
                                foundESC = true;
                                break;
                            }
                            if (byteCheck[i2] == recordBuf[i2]) continue;
                            this.encoding = "MARC8-Maybe";
                        }
                        int numUnknownCharacters = 0;
                        int numValidNonAsciiCharacters = 0;
                        for (int i4 = 0; i4 < utfCheck.length(); ++i4) {
                            if (utfCheck.charAt(i4) == '\ufffd') {
                                ++numUnknownCharacters;
                            }
                            if (utfCheck.charAt(i4) < '\u007f') continue;
                            ++numValidNonAsciiCharacters;
                        }
                        if (!foundESC && numUnknownCharacters < 5 && numUnknownCharacters * 10 < numValidNonAsciiCharacters) {
                            this.encoding = "UTF8";
                            record.addError("n/a", "n/a", 2, "Record claims to be UTF-8, but it has encoding errors, so it might not be ");
                        } else if (!foundESC) {
                            record.addError("n/a", "n/a", 2, "Record claims to be UTF-8, but its not. It may be MARC8, or maybe UNIMARC, or maybe raw ISO-8859-1 ");
                        }
                    }
                    if (utfCheck.contains("a$1!")) {
                        this.encoding = "MARC8-Broken";
                        record.addError("n/a", "n/a", 3, "Record claims to be UTF-8, but its not. It seems to be MARC8-encoded but with missing escape codes.");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (this.permissive && !this.encoding.equals("UTF8") && this.convertToUTF8) {
                try {
                    String marc8EscSeqCheck = new String(recordBuf, "ISO-8859-1");
                    boolean hasMarc8EscSeq = marc8EscSeqCheck.split("\\e[-(,)$bsp]", 2).length > 1;
                    utfCheck = new String(recordBuf, "UTF-8");
                    byte[] byteCheck = utfCheck.getBytes("UTF-8");
                    if (recordBuf.length != byteCheck.length) break block86;
                    for (i2 = 0; i2 < recordBuf.length; ++i2) {
                        if (recordBuf[i2] >= 0 && byteCheck[i2] == recordBuf[i2]) continue;
                        if (hasMarc8EscSeq) {
                            record.addError("n/a", "n/a", 2, "Record has MARC8 escape sequences, but also seem to have UTF8-encoded characters.");
                            this.encoding = "MARC8-Maybe";
                        } else {
                            record.addError("n/a", "n/a", 2, "Record claims not to be UTF-8, but it seems to be.");
                            this.encoding = "UTF8-Maybe";
                        }
                        break;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        record.setLeader(ldr);
        int size = directoryLength / 12;
        ArrayList<String> tags = new ArrayList<String>(size);
        ArrayList<Integer> lengths = new ArrayList<Integer>(size);
        ArrayList<Integer> offsets = new ArrayList<Integer>(size);
        HashMap<Integer, Integer> offsetsMap = new HashMap<Integer, Integer>();
        boolean unsortedOffsets = false;
        int offsetToFT = 0;
        if (directoryLength % 12 == 0 && recordBuf[directoryLength] == 30) {
            boolean doneWithDirectory = false;
            int totalOffset = 0;
            int offset = 0;
            i = 0;
            while (offset + 14 < recordBuf.length && !doneWithDirectory) {
                int increment = 12;
                int prevOffset = offset;
                dirEntry = new String(recordBuf, offsetToFT, 14);
                String tag = dirEntry.substring(0, 3);
                int length = Integer.parseInt(dirEntry.substring(3, 7));
                offset = Integer.parseInt(dirEntry.substring(7, 12));
                tags.add(tag);
                lengths.add(length);
                if (offset >= 99999) {
                    offset = prevOffset + length;
                }
                offsets.add(offset);
                if (recordBuf[offsetToFT += 12] == 30) {
                    doneWithDirectory = true;
                }
                offsetsMap.put(offset, i);
                if (offset != totalOffset && totalOffset < 99999) {
                    unsortedOffsets = true;
                }
                totalOffset += length;
                ++i;
            }
            size = tags.size();
        } else {
            int totalOffset = 0;
            boolean flaggedError1 = false;
            boolean flaggedError2 = false;
            boolean doneWithDirectory = false;
            int i5 = 0;
            while (!doneWithDirectory) {
                int increment = 12;
                dirEntry = new String(recordBuf, offsetToFT, 14);
                int ftIndex = dirEntry.indexOf(30);
                if (ftIndex > 0 && ftIndex < 12) {
                    record.addError("n/a", "n/a", 3, "Field terminator in the middle of a directory entry. Discarding entry and trying to continue.");
                    offsetToFT += dirEntry.indexOf(30);
                    break;
                }
                String tag = dirEntry.substring(0, 3);
                int length = Integer.parseInt(dirEntry.substring(3, 7));
                int offset = Integer.parseInt(dirEntry.substring(7, 12));
                if ((directoryLength - offsetToFT) % 12 == 11 && tag.charAt(1) != '0') {
                    String tagA = "0" + dirEntry.substring(0, 2);
                    int lengthA = Integer.parseInt(dirEntry.substring(2, 6));
                    int offsetA = Integer.parseInt(dirEntry.substring(6, 11));
                    if (recordBuf[directoryLength] == 30 && recordBuf[directoryLength + lengthA] == 30) {
                        record.addError("n/a", "n/a", 3, "Directory length is not a multiple of 12 bytes long.  Prepending a zero and trying to continue.");
                        tag = tagA;
                        length = lengthA;
                        offset = offsetA;
                        increment = 11;
                    }
                }
                if (totalOffset != offset && offset != 99999) {
                    try {
                        int offset1 = Integer.parseInt(dirEntry.substring(7, 13));
                        int offset2 = Integer.parseInt(dirEntry.substring(8, 13));
                        int length2 = Integer.parseInt(dirEntry.substring(3, 8));
                        if (offset1 == totalOffset) {
                            offset = offset1;
                            if (!flaggedError1) {
                                record.addError("n/a", "n/a", 3, "Offset as stored in directory entry has more than 5 digits. Trying to continue.");
                                flaggedError1 = true;
                            }
                            increment = 13;
                        } else if (offset2 == totalOffset && totalOffset > 0) {
                            offset = offset2;
                            length = length2;
                            if (!flaggedError2) {
                                record.addError("n/a", "n/a", 3, "Field is longer than 9999 bytes.  Field length has more than four digits. Trying to continue.");
                                flaggedError2 = true;
                            }
                            increment = 13;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                tags.add(tag);
                lengths.add(length);
                offsets.add(totalOffset);
                if (recordBuf[offsetToFT += increment] == 30) {
                    doneWithDirectory = true;
                }
                offsetsMap.put(offset, i5);
                if (totalOffset < 99999 && offset != totalOffset) {
                    record.addError("n/a", "n/a", 4, "Offsets to fields are out of order AND the directory is messed up. Unable to continue.");
                    throw new MarcException("Offsets to fields are out of order AND the directory is messed up");
                }
                totalOffset += length;
                ++i5;
            }
            size = tags.size();
        }
        if (directoryLength != offsetToFT) {
            record.addError("n/a", "n/a", 2, "Specified directory length not equal to actual directory length.");
        }
        if (size == 0) {
            record.addError("n/a", "n/a", 3, "Record comtains no directory or fields");
        }
        if (unsortedOffsets) {
            Collections.sort(offsets);
        }
        try {
            DataInputStream inputrec = new DataInputStream(new ByteArrayInputStream(recordBuf));
            inputrec.skip(offsetToFT + 1);
            int numBadLengths = 0;
            int totalLength = 0;
            i = 0;
            for (int s = 0; s < size; ++s) {
                i = unsortedOffsets ? (Integer)offsetsMap.get(offsets.get(s)) : s;
                int fieldLength = this.getFieldLength(inputrec);
                if (fieldLength + 1 != (Integer)lengths.get(i) && this.permissive && numBadLengths < 5 && totalLength + fieldLength < recordLength + 26) {
                    inputrec.mark(9999);
                    byteArray = new byte[((Integer)lengths.get(i)).intValue()];
                    inputrec.readFully(byteArray);
                    inputrec.reset();
                    if (fieldLength + 1 < (Integer)lengths.get(i) && byteArray[(Integer)lengths.get(i) - 1] == 30) {
                        record.addError("n/a", "n/a", 2, "Field Terminator character found in the middle of a field.");
                    } else {
                        ++numBadLengths;
                        lengths.set(i, fieldLength + 1);
                        record.addError("n/a", "n/a", 2, "Field length found in record different from length stated in the directory.");
                        if (fieldLength + 1 > 9999) {
                            record.addError("n/a", "n/a", 4, "Field length is greater than 9999, record cannot be represented as a binary Marc record.");
                        }
                    }
                }
                totalLength += ((Integer)lengths.get(i)).intValue();
                if (this.isControlField((String)tags.get(i))) {
                    byteArray = new byte[(Integer)lengths.get(i) - 1];
                    inputrec.readFully(byteArray);
                    if (inputrec.read() != 30) {
                        record.addError("n/a", "n/a", 4, "Expected field terminator at end of field. Unable to continue.");
                        throw new MarcException("expected field terminator at end of field");
                    }
                    ControlField field = this.factory.newControlField();
                    field.setTag((String)tags.get(i));
                    field.setData(this.getDataAsString(byteArray));
                    record.addVariableField(field);
                    continue;
                }
                byteArray = new byte[((Integer)lengths.get(i)).intValue()];
                inputrec.readFully(byteArray);
                try {
                    record.addVariableField(this.parseDataField(record, (String)tags.get(i), byteArray));
                    continue;
                }
                catch (IOException e) {
                    throw new MarcException("error parsing data field for tag: " + (String)tags.get(i) + " with data: " + new String(byteArray), e);
                }
            }
            if (this.permissive && this.conversionCheck1.length() > 1 && this.conversionCheck2.length() > 1 && this.conversionCheck3.length() > 1) {
                this.guessAndSelectCorrectNonUTF8Encoding();
            }
            if (inputrec.read() != 29) {
                record.addError("n/a", "n/a", 4, "Expected record terminator at end of record. Unable to continue.");
                throw new MarcException("expected record terminator");
            }
        }
        catch (IOException e) {
            record.addError("n/a", "n/a", 4, "Error reading from data file. Unable to continue.");
            throw new MarcException("an error occured reading input", e);
        }
    }

    @Override
    public void addError(int severity, String message) {
        this.record.addError(this.currentField, this.currentSubfield, severity, message);
    }

    private boolean isControlField(String tag) {
        boolean isControl;
        block2: {
            isControl = false;
            try {
                isControl = Verifier.isControlField(tag);
            }
            catch (NumberFormatException nfe) {
                if (!this.permissive) break block2;
                this.record.addError(tag, "n/a", 1, "Field tag contains non-numeric characters (" + tag + ").");
                isControl = false;
            }
        }
        return isControl;
    }

    private void guessAndSelectCorrectNonUTF8Encoding() {
        int defaultPart = 0;
        if (this.record.getVariableField("245") == null) {
            defaultPart = 1;
        }
        int partToUse = 0;
        int l1 = this.conversionCheck1.length();
        int l2 = this.conversionCheck2.length();
        int l3 = this.conversionCheck3.length();
        if (l1 < l3 && l2 == l3 && defaultPart == 0) {
            this.addError(0, "MARC8 translation shorter than ISO-8859-1, choosing MARC8.");
            partToUse = 0;
        } else if (l2 < l1 - 2 && l2 < l3 - 2) {
            this.addError(0, "Unimarc translation shortest, choosing it.");
            partToUse = 1;
        } else {
            int tst = this.onlyOneStartsWithUpperCase(this.conversionCheck1, this.conversionCheck2, this.conversionCheck3);
            if (tst != -1) {
                partToUse = tst;
            } else if (l2 < l1 && l2 < l3) {
                this.addError(0, "Unimarc translation shortest, choosing it.");
                partToUse = 1;
            } else if (this.conversionCheck2.equals(this.conversionCheck3) && !this.conversionCheck1.trim().contains(" ")) {
                this.addError(0, "Unimarc and ISO-8859-1 translations identical, choosing ISO-8859-1.");
                partToUse = 2;
            } else if (!this.specialCharIsBetweenLetters(this.conversionCheck1)) {
                this.addError(0, "To few letters in translations, choosing " + (defaultPart == 0 ? "MARC8" : "Unimarc"));
                partToUse = defaultPart;
            } else if (l2 == l3 && defaultPart == 1) {
                this.addError(0, "Unimarc and ISO-8859-1 translations equal length, choosing ISO-8859-1.");
                partToUse = 2;
            } else {
                this.addError(0, "No Determination made, defaulting to " + (defaultPart == 0 ? "MARC8" : "Unimarc"));
                partToUse = defaultPart;
            }
        }
        List<VariableField> fields2 = this.record.getVariableFields();
        for (VariableField field : fields2) {
            if (!(field instanceof DataField)) continue;
            DataField df = (DataField)field;
            List<Subfield> subf = df.getSubfields();
            for (Subfield sf : subf) {
                if (!sf.getData().contains("%%@%%")) continue;
                String[] parts = sf.getData().split("%%@%%", 3);
                sf.setData(parts[partToUse]);
            }
        }
    }

    private int onlyOneStartsWithUpperCase(String conversionCheck12, String conversionCheck22, String conversionCheck32) {
        if (this.conversionCheck1.length() == 0 || this.conversionCheck2.length() == 0 || this.conversionCheck3.length() == 0) {
            return -1;
        }
        String[] check1Parts = this.conversionCheck1.trim().split("[|]>");
        String[] check2Parts = this.conversionCheck2.trim().split("[|]>");
        String[] check3Parts = this.conversionCheck3.trim().split("[|]>");
        for (int i = 1; i < check1Parts.length && i < check2Parts.length && i < check3Parts.length; ++i) {
            boolean tst1 = Character.isUpperCase(check1Parts[i].charAt(0));
            boolean tst2 = Character.isUpperCase(check2Parts[i].charAt(0));
            boolean tst3 = Character.isUpperCase(check3Parts[i].charAt(0));
            if (tst1 && !tst2 && !tst3) {
                return 0;
            }
            if (!tst1 && tst2 && !tst3) {
                return -1;
            }
            if (tst1 || tst2 || !tst3) continue;
            return 2;
        }
        return -1;
    }

    private boolean specialCharIsBetweenLetters(String conversionCheck) {
        boolean bewteenLetters = true;
        for (int i = 0; i < conversionCheck.length(); ++i) {
            char charCode = conversionCheck.charAt(i);
            if (charCode <= '\u007f') continue;
            bewteenLetters = false;
            if ((i <= 0 || !Character.isLetter((int)conversionCheck.charAt(i - 1))) && (i >= conversionCheck.length() - 1 || !Character.isLetter((int)conversionCheck.charAt(i + 1)))) continue;
            bewteenLetters = true;
            break;
        }
        return bewteenLetters;
    }

    private int arrayContainsAt(byte[] byteArray, int ft) {
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] != (byte)ft) continue;
            return i;
        }
        return -1;
    }

    private DataField parseDataField(Record record, String tag, byte[] field) throws IOException {
        int readByte;
        if (this.permissive) {
            if (tag.equals("880")) {
                String fieldTag = new String(field);
                fieldTag = fieldTag.replaceFirst("^.*\\x1F6", "").replaceFirst("([-0-9]*).*", "$1");
                this.currentField = tag + "(" + fieldTag + ")";
            } else {
                this.currentField = tag;
            }
            this.currentSubfield = "n/a";
            this.cleanupBadFieldSeperators(field, record);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(field);
        char ind1 = (char)bais.read();
        char ind2 = (char)bais.read();
        DataField dataField = this.factory.newDataField();
        dataField.setTag(tag);
        dataField.setIndicator1(ind1);
        dataField.setIndicator2(ind2);
        while ((readByte = bais.read()) >= 0) {
            switch (readByte) {
                case 31: {
                    int code = bais.read();
                    if (code < 0) {
                        throw new IOException("unexpected end of data field");
                    }
                    if (code == 30) break;
                    int size = this.getSubfieldLength(bais);
                    if (size == 0) {
                        if (this.permissive) {
                            this.addError(2, "Subfield of zero length encountered, ignoring it.");
                            break;
                        }
                        throw new IOException("Subfield of zero length encountered");
                    }
                    byte[] data2 = new byte[size];
                    bais.read(data2);
                    Subfield subfield = this.factory.newSubfield();
                    if (this.permissive) {
                        this.currentSubfield = "" + (char)code;
                    }
                    String dataAsString = this.getDataAsString(data2);
                    if (this.permissive && code == 31) {
                        code = data2[0];
                        dataAsString = dataAsString.substring(1);
                        this.addError(3, "Subfield tag is a subfield separator, using first character of field as subfield tag.");
                    } else if (this.permissive && validSubfieldCodes.indexOf(code) == -1) {
                        if (code >= 65 && code <= 90) {
                            if (!Boolean.parseBoolean(System.getProperty(upperCaseSubfieldsProperty, "false"))) {
                                code = Character.toLowerCase(code);
                                this.addError(2, "Subfield tag is an invalid uppercase character, changing it to lower case.");
                            }
                        } else if (code > 127) {
                            code = data2[0];
                            dataAsString = dataAsString.substring(1);
                            this.addError(3, "Subfield tag is an invalid character greater than 0x7f, using first character of field as subfield tag.");
                        } else if (code == 91 && tag.equals("245")) {
                            code = 104;
                            dataAsString = '[' + dataAsString;
                            this.addError(3, "Subfield tag is an open bracket, generating a code 'h' and pushing the bracket to the data.");
                        } else if (code == 32) {
                            this.addError(3, "Subfield tag is a space which is an invalid character");
                        } else {
                            this.addError(3, "Subfield tag is an invalid character, [ " + (char)code + " ]");
                        }
                    }
                    subfield.setCode((char)code);
                    subfield.setData(dataAsString);
                    dataField.addSubfield(subfield);
                    break;
                }
            }
        }
        return dataField;
    }

    public void cleanupBadFieldSeperators(byte[] field, Record record) {
        if (conv == null) {
            conv = new AnselToUnicode(true);
        }
        boolean hasEsc = false;
        boolean inMultiByte = false;
        boolean justCleaned = false;
        int mbOffset = 0;
        boolean inCyrillic = false;
        int flen = 0;
        for (int i = 0; i < field.length - 1; ++i) {
            if (field[i] == 27) {
                hasEsc = true;
                if ("(,)-'".indexOf((char)field[i + 1]) != -1) {
                    inMultiByte = false;
                    inCyrillic = i + 2 < field.length && (char)field[i + 2] == 'N';
                } else if (i + 2 < field.length && field[i + 1] == 36 && field[i + 2] == 49) {
                    inMultiByte = true;
                    mbOffset = 3;
                } else if (!(i + 3 >= field.length || field[i + 1] != 36 && field[i + 2] != 36 || field[i + 2] != 49 && field[i + 3] != 49)) {
                    inMultiByte = true;
                    mbOffset = 4;
                }
            } else if (inMultiByte && field[i] != 32 && field[i] >= 0) {
                int n = mbOffset = mbOffset == 0 ? 2 : mbOffset - 1;
            }
            if (inMultiByte && mbOffset == 0 && i + 2 < field.length && field[i] > 0) {
                int f3;
                int f2;
                int f1 = field[i];
                char c = conv.getMBChar(conv.makeMultibyte((char)(f1 == 31 ? 124 : f1), (char)((f2 = field[i + 1] == 32 ? field[i + 2] : field[i + 1]) == 31 ? 124 : f2), (char)((f3 = field[i + 1] == 32 || field[i + 2] == 32 ? field[i + 3] : field[i + 2]) == 31 ? 124 : f3)));
                if (c == '\u0000' && !justCleaned) {
                    this.addError(3, "Bad Multibyte character found, reinterpreting data as non-multibyte data");
                    inMultiByte = false;
                } else if (c == '\u0000' && justCleaned) {
                    c = conv.getMBChar(conv.makeMultibyte('!', (char)(f2 == 31 ? 124 : f2), (char)(f3 == 31 ? 124 : f3)));
                    if (c == '\u0000') {
                        this.addError(3, "Bad Multibyte character found, reinterpreting data as non-multibyte data");
                        inMultiByte = false;
                    } else {
                        this.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to \"!\"");
                        field[i] = 33;
                    }
                }
            }
            justCleaned = false;
            if (field[i] == 31) {
                if (inMultiByte && mbOffset != 0) {
                    field[i] = 124;
                    this.addError(3, "Subfield separator found in middle of a multibyte character, changing it to a vertical bar, and continuing");
                    if (field[i + 1] == 48) {
                        if (field[i + 2] == 40 && field[i + 3] == 66) {
                            field[i + 1] = 27;
                            this.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to ESC");
                        } else {
                            field[i + 1] = 33;
                            this.addError(3, "Character after restored vertical bar character makes bad multibyte character, changing it to \"!\"");
                        }
                    }
                    justCleaned = true;
                } else if (hasEsc && inCyrillic) {
                    String prev = new String(field, i - (flen - 1), flen - 1);
                    if (field[i + 1] < 97 || field[i + 1] > 122) {
                        this.addError(2, "Subfield separator found in Cyrillic string, changing separator to a vertical bar, and continuing");
                        field[i] = 124;
                        justCleaned = true;
                    } else if (field[i + 1] >= 97 && field[i + 1] <= 122 && field.length > i + 3 && field[i + 2] >= 65 && field[i + 2] <= 90 && field[i + 3] >= 65 && field[i + 3] <= 90 || prev.equals("\u001b(N")) {
                        this.addError(2, "Subfield separator found in Cyrillic string, changing separator to a vertical bar, and changing subfield code character to uppercase");
                        field[i] = 124;
                        field[i + 1] = (byte)Character.toUpperCase(field[i + 1]);
                        justCleaned = true;
                    }
                } else if (!(!hasEsc || field[i + 1] >= 97 && field[i + 1] <= 122 || field[i + 1] >= 48 && field[i + 1] <= 57)) {
                    this.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    justCleaned = true;
                } else if (hasEsc && i < field.length - 3 && field[i + 1] == 48 && field[i + 2] == 40 && field[i + 3] == 66) {
                    this.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    field[i + 1] = 27;
                    justCleaned = true;
                } else if (hasEsc && field[i + 1] == 48) {
                    this.addError(3, "Subfield separator followed by invalid subfield tag, changing separator to a vertical bar, and continuing");
                    field[i] = 124;
                    field[i + 1] = 33;
                    justCleaned = true;
                } else if (field[i + 1] == 31 && field[i + 2] == 31) {
                    this.addError(3, "Three consecutive subfield separators, changing first two to vertical bars.");
                    field[i] = 124;
                    field[i + 1] = 124;
                    justCleaned = true;
                }
            }
            if (field[i] == 31) {
                flen = 0;
                continue;
            }
            ++flen;
        }
    }

    private int getFieldLength(DataInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    if (this.permissive) {
                        this.addError(2, "Field not terminated trying to continue");
                        return bytesRead;
                    }
                    throw new IOException("Field not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int getSubfieldLength(ByteArrayInputStream bais) throws IOException {
        bais.mark(9999);
        int bytesRead = 0;
        while (true) {
            switch (bais.read()) {
                case 30: {
                    bais.reset();
                    return bytesRead;
                }
                case 31: {
                    bais.reset();
                    return bytesRead;
                }
                case -1: {
                    bais.reset();
                    if (this.permissive) {
                        this.addError(2, "Subfield not terminated trying to continue");
                        return bytesRead;
                    }
                    throw new IOException("subfield not terminated");
                }
            }
            ++bytesRead;
        }
    }

    private int parseRecordLength(byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(leaderData));
        int length = -1;
        char[] tmp = new char[5];
        isr.read(tmp);
        try {
            length = Integer.parseInt(new String(tmp));
        }
        catch (NumberFormatException e) {
            this.addError(4, "Unable to parse record length, Unable to Continue");
            throw new MarcException("unable to parse record length", e);
        }
        return length;
    }

    private void parseLeader(Leader ldr, byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(leaderData), "ISO-8859-1");
        char[] tmp = new char[5];
        isr.read(tmp);
        ldr.setRecordStatus((char)isr.read());
        ldr.setTypeOfRecord((char)isr.read());
        tmp = new char[2];
        isr.read(tmp);
        ldr.setImplDefined1(tmp);
        ldr.setCharCodingScheme((char)isr.read());
        char indicatorCount = (char)isr.read();
        char subfieldCodeLength = (char)isr.read();
        char[] baseAddr = new char[5];
        isr.read(baseAddr);
        tmp = new char[3];
        isr.read(tmp);
        ldr.setImplDefined2(tmp);
        tmp = new char[4];
        isr.read(tmp);
        ldr.setEntryMap(tmp);
        isr.close();
        try {
            ldr.setIndicatorCount(Integer.parseInt(String.valueOf(indicatorCount)));
        }
        catch (NumberFormatException e) {
            if (this.permissive) {
                this.addError(1, "bogus indicator count - byte value =  " + Integer.toHexString(indicatorCount & 0xFF));
                ldr.setIndicatorCount(2);
            }
            throw new MarcException("unable to parse indicator count", e);
        }
        try {
            ldr.setSubfieldCodeLength(Integer.parseInt(String.valueOf(subfieldCodeLength)));
        }
        catch (NumberFormatException e) {
            if (this.permissive) {
                this.addError(1, "bogus subfield count - byte value =  " + Integer.toHexString(subfieldCodeLength & 0xFF));
                ldr.setSubfieldCodeLength(2);
            }
            throw new MarcException("unable to parse subfield code length", e);
        }
        try {
            ldr.setBaseAddressOfData(Integer.parseInt(new String(baseAddr)));
        }
        catch (NumberFormatException e) {
            throw new MarcException("unable to parse base address of data", e);
        }
    }

    private String getDataAsString(byte[] bytes) {
        String newdataElement;
        String dataElement = null;
        if (this.encoding.equals("UTF-8") || this.encoding.equals("UTF8")) {
            try {
                dataElement = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        if (this.encoding.equals("UTF8-Maybe")) {
            try {
                dataElement = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("unsupported encoding", e);
            }
        }
        if (this.encoding.equals("MARC-8") || this.encoding.equals("MARC8")) {
            dataElement = this.getMarc8Conversion(bytes);
        } else if (this.encoding.equalsIgnoreCase("Unimarc") || this.encoding.equals("IS05426")) {
            dataElement = this.getUnimarcConversion(bytes);
        } else if (this.encoding.equals("MARC8-Maybe")) {
            String dataElement1 = this.getMarc8Conversion(bytes);
            String dataElement2 = this.getUnimarcConversion(bytes);
            String dataElement3 = null;
            try {
                dataElement3 = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (dataElement1.equals(dataElement2) && dataElement1.equals(dataElement3)) {
                dataElement = dataElement1;
            } else {
                this.conversionCheck1 = this.conversionCheck1 + "|>" + Normalizer.normalize(dataElement1, Normalizer.Form.NFC);
                this.conversionCheck2 = this.conversionCheck2 + "|>" + dataElement2;
                this.conversionCheck3 = this.conversionCheck3 + "|>" + dataElement3;
                dataElement = dataElement1 + "%%@%%" + dataElement2 + "%%@%%" + dataElement3;
            }
        } else if (this.encoding.equals("MARC8-Broken")) {
            try {
                dataElement = new String(bytes, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            newdataElement = dataElement.replaceAll("&lt;", "<");
            newdataElement = newdataElement.replaceAll("&gt;", ">");
            newdataElement = newdataElement.replaceAll("&amp;", "&");
            newdataElement = newdataElement.replaceAll("&apos;", "'");
            newdataElement = newdataElement.replaceAll("&quot;", "\"");
            if (!newdataElement.equals(dataElement)) {
                dataElement = newdataElement;
                this.addError(1, "Subfield contains escaped html character entities, un-escaping them. ");
            }
            String rep1 = "\u001b\\$1$1";
            String rep2 = "\u001b\\(B";
            newdataElement = dataElement.replaceAll("\\$1(.)", "\u001b\\$1$1");
            if (!(newdataElement = newdataElement.replaceAll("\\(B", "\u001b\\(B")).equals(dataElement)) {
                dataElement = newdataElement;
                this.addError(3, "Subfield seems to be missing MARC8 escape sequences, trying to restore them.");
            }
            try {
                dataElement = this.getMarc8Conversion(dataElement.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            if (this.encoding.equals("ISO-8859-1") || this.encoding.equals("ISO8859_1")) {
                try {
                    dataElement = new String(bytes, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new MarcException("unsupported encoding", e);
                }
            }
            try {
                dataElement = new String(bytes, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MarcException("Unknown or unsupported Marc character encoding:" + this.encoding);
            }
        }
        if (this.record != null && dataElement.matches("[^&]*&[a-z]*;.*")) {
            newdataElement = dataElement.replaceAll("&lt;", "<");
            newdataElement = newdataElement.replaceAll("&gt;", ">");
            newdataElement = newdataElement.replaceAll("&amp;", "&");
            newdataElement = newdataElement.replaceAll("&apos;", "'");
            if (!(newdataElement = newdataElement.replaceAll("&quot;", "\"")).equals(dataElement)) {
                dataElement = newdataElement;
                this.addError(1, "Subfield contains escaped html character entities, un-escaping them. ");
            }
        }
        return dataElement;
    }

    private static boolean byteArrayContains(byte[] bytes, byte[] seq) {
        for (int i = 0; i < bytes.length - seq.length; ++i) {
            if (bytes[i] != seq[0]) continue;
            for (int j = 0; j < seq.length && bytes[i + j] == seq[j]; ++j) {
                if (j != seq.length - 1) continue;
                return true;
            }
        }
        return false;
    }

    public String getMarc8Conversion(byte[] bytes, AnselToUnicode conv, boolean permissive, Record record, boolean doNCR) {
        String dataElement = null;
        if (permissive && (MarcPermissiveStreamReader.byteArrayContains(bytes, badEsc) || MarcPermissiveStreamReader.byteArrayContains(bytes, overbar))) {
            String newDataElement = null;
            try {
                dataElement = new String(bytes, "ISO-8859-1");
                newDataElement = dataElement.replaceAll("(\\e)b-\\es([psb$()])", "$1$2");
                if (!newDataElement.equals(dataElement)) {
                    dataElement = newDataElement;
                    this.addError(2, "Subfield contains odd pattern of subscript or superscript escapes. ");
                }
                if (!(newDataElement = dataElement.replace('\u00af', '\u00e5')).equals(dataElement)) {
                    dataElement = newDataElement;
                    this.addError(1, "Subfield contains 0xaf overbar character, changing it to proper MARC8 representation ");
                }
                dataElement = conv.convert(dataElement);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            dataElement = conv.convert(bytes);
        }
        if (doNCR && permissive && dataElement.matches("[^&]*&#x[0-9A-Fa-f]+[^;].*")) {
            Pattern pattern = Pattern.compile("&#x([0-9A-Fa-f]+)(%x)?;?");
            Matcher matcher = pattern.matcher(dataElement);
            StringBuffer newElement = new StringBuffer();
            int prevEnd = 0;
            while (matcher.find()) {
                newElement.append(dataElement.substring(prevEnd, matcher.start()));
                newElement.append(MarcPermissiveStreamReader.getChar(matcher.group(1)));
                if (matcher.group(1).contains("%x") || !matcher.group(1).endsWith(";")) {
                    this.addError(2, "Subfield contains malformed Unicode Numeric Character Reference : " + matcher.group(0));
                }
                prevEnd = matcher.end();
            }
            newElement.append(dataElement.substring(prevEnd));
            dataElement = newElement.toString();
        }
        return dataElement;
    }

    private String getMarc8Conversion(byte[] bytes) {
        String dataElement = null;
        if (this.converterAnsel == null) {
            this.converterAnsel = new AnselToUnicode(this);
        }
        if (this.isTranslateLosslessUnicodeNumericCodeReferencesEnabled()) {
            AnselToUnicode anselConverter = this.converterAnsel;
            anselConverter.setTranslateNCR(this.isTranslateLosslessUnicodeNumericCodeReferencesEnabled());
        }
        dataElement = this.getMarc8Conversion(bytes, this.converterAnsel, this.permissive, this.record, this.translateLosslessUnicodeNumericCodeReferencesEnabled);
        return dataElement;
    }

    private String getUnimarcConversion(byte[] bytes) {
        if (this.converterUnimarc == null) {
            this.converterUnimarc = new Iso5426ToUnicode();
        }
        String dataElement = this.converterUnimarc.convert(bytes);
        dataElement = dataElement.replaceAll("\u0088", "");
        if ((dataElement = dataElement.replaceAll("\u0089", "")).matches("[^<]*<U[+][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]>.*")) {
            Pattern pattern = Pattern.compile("<U[+]([0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f])>");
            Matcher matcher = pattern.matcher(dataElement);
            StringBuffer newElement = new StringBuffer();
            int prevEnd = 0;
            while (matcher.find()) {
                newElement.append(dataElement.substring(prevEnd, matcher.start()));
                newElement.append(MarcPermissiveStreamReader.getChar(matcher.group(1)));
                prevEnd = matcher.end();
            }
            newElement.append(dataElement.substring(prevEnd));
            dataElement = newElement.toString();
        }
        return dataElement;
    }

    private static String getChar(String charCodePoint) {
        int charNum = Integer.parseInt(charCodePoint, 16);
        String result2 = "" + (char)charNum;
        return result2;
    }
}

