/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.util.JsonParser;

public class MarcJsonReader
implements MarcReader {
    MarcFactory factory;
    JsonParser parser;
    int parserLevel = 0;
    public static final int NO_ARRAY = 0;
    public static final int FIELDS_ARRAY = 1;
    public static final int SUBFIELDS_ARRAY = 2;
    public static final int CONTROLFIELD_ARRAY = 3;
    public static final int DATAFIELD_ARRAY = 4;
    public static final int SUBFIELD_ARRAY = 5;

    public MarcJsonReader(InputStream is) {
        this.parser = new JsonParser(0x40000011);
        this.parser.setInput("MarcInput", new InputStreamReader(is), false);
        this.factory = MarcFactory.newInstance();
    }

    public MarcJsonReader(Reader in) {
        this.parser = new JsonParser(0);
        this.parser.setInput("MarcInput", in, false);
        this.factory = MarcFactory.newInstance();
    }

    @Override
    public boolean hasNext() {
        int code = this.parser.getEventCode();
        if (code == 0 || code == 2) {
            code = this.parser.next();
        }
        if (code == 1) {
            return true;
        }
        if (code == 5) {
            return false;
        }
        throw new MarcException("Malformed JSON input");
    }

    @Override
    public Record next() {
        int code = this.parser.getEventCode();
        Record record = null;
        ControlField cf = null;
        DataField df = null;
        Subfield sf = null;
        int inArray = 0;
        while (true) {
            String mname = this.parser.getMemberName();
            switch (code) {
                case 1: {
                    if (this.parserLevel == 0) {
                        record = this.factory.newRecord();
                    } else if (inArray == 1 && mname.matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                        df = this.factory.newDataField();
                        df.setTag(mname);
                    }
                    ++this.parserLevel;
                    break;
                }
                case 2: {
                    --this.parserLevel;
                    if (this.parserLevel == 0) {
                        return record;
                    }
                    if (inArray == 1 && mname.matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                        record.addVariableField(df);
                        df = null;
                        break;
                    }
                    if (inArray != 4 || !mname.matches("datafield")) break;
                    record.addVariableField(df);
                    df = null;
                    break;
                }
                case 3: {
                    if (mname.equals("fields")) {
                        inArray = 1;
                        break;
                    }
                    if (mname.equals("subfields")) {
                        inArray = 2;
                        break;
                    }
                    if (mname.equals("controlfield")) {
                        inArray = 3;
                        break;
                    }
                    if (mname.equals("datafield")) {
                        inArray = 4;
                        break;
                    }
                    if (!mname.equals("subfield")) break;
                    inArray = 5;
                    break;
                }
                case 4: {
                    if (mname.equals("fields")) {
                        inArray = 0;
                        break;
                    }
                    if (mname.equals("subfields")) {
                        inArray = 1;
                        break;
                    }
                    if (mname.equals("controlfield")) {
                        inArray = 0;
                        break;
                    }
                    if (mname.equals("datafield")) {
                        inArray = 0;
                        break;
                    }
                    if (!mname.equals("subfield")) break;
                    inArray = 4;
                    break;
                }
                case 6: {
                    String value = this.parser.getMemberValue();
                    if (JsonParser.isQuoted(value)) {
                        value = JsonParser.stripQuotes(value);
                    }
                    value = value.replaceAll("\u2044", "/");
                    if (mname.equals("ind1")) {
                        df.setIndicator1(value.length() >= 1 ? value.charAt(0) : (char)' ');
                        break;
                    }
                    if (mname.equals("ind2")) {
                        df.setIndicator2(value.length() >= 1 ? value.charAt(0) : (char)' ');
                        break;
                    }
                    if (mname.equals("leader")) {
                        record.setLeader(this.factory.newLeader(value));
                        break;
                    }
                    if (inArray == 1 && mname.matches("[A-Z0-9][A-Z0-9][A-Z0-9]")) {
                        cf = this.factory.newControlField(mname, value);
                        record.addVariableField(cf);
                        break;
                    }
                    if (inArray == 2 && mname.matches("[a-z0-9]")) {
                        sf = this.factory.newSubfield(mname.charAt(0), value);
                        df.addSubfield(sf);
                        break;
                    }
                    if (inArray == 3 && mname.equals("tag")) {
                        cf = this.factory.newControlField();
                        cf.setTag(value);
                        break;
                    }
                    if (inArray == 3 && mname.equals("data")) {
                        cf.setData(value);
                        record.addVariableField(cf);
                        break;
                    }
                    if (inArray == 4 && mname.equals("tag")) {
                        df = this.factory.newDataField();
                        df.setTag(value);
                        break;
                    }
                    if (inArray == 4 && mname.equals("ind")) {
                        df.setIndicator1(value.length() >= 1 ? value.charAt(0) : (char)' ');
                        df.setIndicator2(value.length() > 1 ? value.charAt(1) : (char)' ');
                        break;
                    }
                    if (inArray == 5 && mname.equals("code")) {
                        sf = this.factory.newSubfield();
                        sf.setCode(value.charAt(0));
                        break;
                    }
                    if (inArray != 5 || !mname.equals("data")) break;
                    sf.setData(value);
                    df.addSubfield(sf);
                    break;
                }
                case 5: {
                    throw new MarcException("Premature end of input in JSON file");
                }
            }
            code = this.parser.next();
        }
    }
}

