/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;

public class MarcFilteredReader
implements MarcReader {
    final String[][] includeRecordIfFieldsPresent;
    final String includeRecordIfFieldContains;
    final String[][] includeRecordIfFieldsMissing;
    final String includeRecordIfFieldDoesntContain;
    Record currentRecord = null;
    final MarcReader reader;

    public MarcFilteredReader(MarcReader reader, String ifFieldPresent, String ifFieldMissing) {
        int i;
        String[] tagPlus;
        if (ifFieldPresent != null) {
            String[] present = ifFieldPresent.split("/", 2);
            tagPlus = present[0].split(":");
            this.includeRecordIfFieldsPresent = new String[tagPlus.length][2];
            for (i = 0; i < this.includeRecordIfFieldsPresent.length; ++i) {
                this.includeRecordIfFieldsPresent[i][0] = tagPlus[i].substring(0, 3);
                this.includeRecordIfFieldsPresent[i][1] = tagPlus[i].substring(3);
            }
            this.includeRecordIfFieldContains = present.length > 1 ? present[1] : null;
        } else {
            this.includeRecordIfFieldsPresent = null;
            this.includeRecordIfFieldContains = null;
        }
        if (ifFieldMissing != null) {
            String[] missing = ifFieldMissing.split("/", 2);
            tagPlus = missing[0].split(":");
            this.includeRecordIfFieldsMissing = new String[tagPlus.length][2];
            for (i = 0; i < this.includeRecordIfFieldsMissing.length; ++i) {
                this.includeRecordIfFieldsMissing[i][0] = tagPlus[i].substring(0, 3);
                this.includeRecordIfFieldsMissing[i][1] = tagPlus[i].substring(3);
            }
            this.includeRecordIfFieldDoesntContain = missing.length > 1 ? missing[1] : null;
        } else {
            this.includeRecordIfFieldsMissing = null;
            this.includeRecordIfFieldDoesntContain = null;
        }
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRecord == null) {
            this.currentRecord = this.next();
        }
        return this.currentRecord != null;
    }

    @Override
    public Record next() {
        if (this.currentRecord != null) {
            Record tmp = this.currentRecord;
            this.currentRecord = null;
            return tmp;
        }
        while (this.currentRecord == null) {
            if (!this.reader.hasNext()) {
                return null;
            }
            Record rec = null;
            rec = this.reader.next();
            if (rec != null && this.includeRecordIfFieldsPresent != null) {
                for (String[] tagAndSf : this.includeRecordIfFieldsPresent) {
                    List<VariableField> fields2 = rec.getVariableFields(tagAndSf[0]);
                    for (VariableField vf : fields2) {
                        if (vf instanceof ControlField) {
                            if (this.includeRecordIfFieldContains != null && (this.includeRecordIfFieldContains.startsWith("^") || !((ControlField)vf).getData().contains(this.includeRecordIfFieldContains)) && (!this.includeRecordIfFieldContains.startsWith("^") || !((ControlField)vf).getData().matches(this.includeRecordIfFieldContains))) continue;
                            this.currentRecord = rec;
                            break;
                        }
                        String subfieldVal = ((DataField)vf).getSubfieldsAsString(tagAndSf[1]);
                        if (subfieldVal == null) continue;
                        if (this.includeRecordIfFieldContains == null) {
                            this.currentRecord = rec;
                            break;
                        }
                        if ((this.includeRecordIfFieldContains.startsWith("^") || !subfieldVal.contains(this.includeRecordIfFieldContains)) && (!this.includeRecordIfFieldContains.startsWith("^") || !subfieldVal.matches(this.includeRecordIfFieldContains))) continue;
                        this.currentRecord = rec;
                        break;
                    }
                    if (this.currentRecord != null) break;
                }
            }
            if (rec != null && this.currentRecord == null && this.includeRecordIfFieldsMissing != null) {
                boolean useRecord = true;
                for (String[] tagAndSf : this.includeRecordIfFieldsMissing) {
                    List<VariableField> fields3 = rec.getVariableFields(tagAndSf[0]);
                    for (VariableField vf : fields3) {
                        if (vf instanceof ControlField) {
                            if (this.includeRecordIfFieldDoesntContain != null && (this.includeRecordIfFieldDoesntContain.startsWith("^") || !((ControlField)vf).getData().contains(this.includeRecordIfFieldDoesntContain)) && (!this.includeRecordIfFieldDoesntContain.startsWith("^") || !((ControlField)vf).getData().matches(this.includeRecordIfFieldDoesntContain))) continue;
                            useRecord = false;
                            break;
                        }
                        String subfieldVal = ((DataField)vf).getSubfieldsAsString(tagAndSf[1]);
                        if (this.includeRecordIfFieldDoesntContain != null && (this.includeRecordIfFieldDoesntContain.startsWith("^") || subfieldVal == null || !subfieldVal.contains(this.includeRecordIfFieldDoesntContain)) && (!this.includeRecordIfFieldDoesntContain.startsWith("^") || subfieldVal == null || !subfieldVal.matches(this.includeRecordIfFieldDoesntContain))) continue;
                        useRecord = false;
                        break;
                    }
                    if (!useRecord) break;
                }
                if (useRecord) {
                    this.currentRecord = rec;
                }
            }
            if (rec == null || this.includeRecordIfFieldsPresent != null || this.includeRecordIfFieldsMissing != null) continue;
            this.currentRecord = rec;
        }
        return this.currentRecord;
    }
}

