/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.util.Fields;

public class FormRequestContent
extends StringRequestContent {
    public FormRequestContent(Fields fields2) {
        this(fields2, StandardCharsets.UTF_8);
    }

    public FormRequestContent(Fields fields2, Charset charset) {
        super("application/x-www-form-urlencoded", FormRequestContent.convert(fields2, charset), charset);
    }

    public static String convert(Fields fields2) {
        return FormRequestContent.convert(fields2, StandardCharsets.UTF_8);
    }

    public static String convert(Fields fields2, Charset charset) {
        StringBuilder builder = new StringBuilder(fields2.getSize() * 32);
        for (Fields.Field field : fields2) {
            for (String value : field.getValues()) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(FormRequestContent.encode(field.getName(), charset)).append("=").append(FormRequestContent.encode(value, charset));
            }
        }
        return builder.toString();
    }

    private static String encode(String value, Charset charset) {
        return URLEncoder.encode(value, charset);
    }
}

