/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverHTTP
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverHTTP.class);
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;
    private final LongAdder outMessages = new LongAdder();

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSenderOverHTTP getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiverOverHTTP getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send(HttpExchange exchange) {
        this.outMessages.increment();
        this.sender.send(exchange);
    }

    @Override
    public void release() {
        this.connection.release();
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result2) {
        super.exchangeTerminated(exchange, result2);
        String method = exchange.getRequest().getMethod();
        Response response = result2.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        String closeReason = null;
        if (result2.isFailed()) {
            closeReason = "failure";
        } else if (this.receiver.isShutdown()) {
            closeReason = "server close";
        } else if (this.sender.isShutdown() && response.getStatus() != 101) {
            closeReason = "client close";
        }
        if (closeReason == null) {
            if (response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
                boolean keepAlive = responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                boolean connect = HttpMethod.CONNECT.is(method);
                if (!keepAlive && !connect) {
                    closeReason = "http/1.0";
                }
            } else if (responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                closeReason = "http/1.1";
            }
        }
        if (closeReason != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", (Object)closeReason, (Object)this.connection);
            }
            if (result2.isFailed()) {
                this.connection.close(result2.getFailure());
            } else {
                this.connection.close();
            }
        } else {
            int status = response.getStatus();
            if (status == 101 || this.isTunnel(method, status)) {
                this.connection.remove();
            } else {
                this.release();
            }
        }
    }

    protected long getMessagesIn() {
        return this.receiver.getMessagesIn();
    }

    protected long getMessagesOut() {
        return this.outMessages.longValue();
    }

    boolean isTunnel(String method, int status) {
        return MetaData.isTunnel(method, status);
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

