/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxy.class);

    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        this(address, secure, null, new Origin.Protocol(List.of("http/1.1"), false));
    }

    public HttpProxy(Origin.Address address, boolean secure, Origin.Protocol protocol) {
        this(address, secure, null, Objects.requireNonNull(protocol));
    }

    public HttpProxy(Origin.Address address, SslContextFactory.Client sslContextFactory) {
        this(address, true, sslContextFactory, new Origin.Protocol(List.of("http/1.1"), false));
    }

    public HttpProxy(Origin.Address address, SslContextFactory.Client sslContextFactory, Origin.Protocol protocol) {
        this(address, true, sslContextFactory, Objects.requireNonNull(protocol));
    }

    private HttpProxy(Origin.Address address, boolean secure, SslContextFactory.Client sslContextFactory, Origin.Protocol protocol) {
        super(address, secure, sslContextFactory, Objects.requireNonNull(protocol));
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        return URI.create(this.getOrigin().asString());
    }

    private class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        private HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
            Origin.Protocol serverProtocol = destination.getOrigin().getProtocol();
            boolean sameProtocol = this.proxySpeaksServerProtocol(serverProtocol);
            if (destination.isSecure() || !sameProtocol) {
                Promise promise;
                Promise wrapped = promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
                if (promise instanceof Promise.Wrapper) {
                    wrapped = ((Promise.Wrapper)promise).unwrap();
                }
                if (wrapped instanceof TunnelPromise) {
                    ((TunnelPromise)wrapped).setEndPoint(endPoint);
                    return this.connectionFactory.newConnection(endPoint, context);
                }
                return this.newProxyConnection(endPoint, context);
            }
            return this.connectionFactory.newConnection(endPoint, context);
        }

        private boolean proxySpeaksServerProtocol(Origin.Protocol serverProtocol) {
            return serverProtocol != null && HttpProxy.this.getProtocol().getProtocols().stream().anyMatch(p -> serverProtocol.getProtocols().stream().anyMatch(p::equalsIgnoreCase));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private org.eclipse.jetty.io.Connection newProxyConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
            CreateTunnelPromise tunnelPromise = new CreateTunnelPromise(this.connectionFactory, endPoint, promise, context);
            context.put("org.eclipse.jetty.client.connection.promise", tunnelPromise);
            HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
            HttpClient client = destination.getHttpClient();
            HttpDestination proxyDestination = client.resolveDestination(HttpProxy.this.getOrigin());
            context.put("org.eclipse.jetty.client.destination", proxyDestination);
            try {
                org.eclipse.jetty.io.Connection connection = this.connectionFactory.newConnection(endPoint, context);
                return connection;
            }
            finally {
                context.put("org.eclipse.jetty.client.destination", destination);
            }
        }
    }

    public static class TunnelRequest
    extends HttpRequest {
        private TunnelRequest(HttpClient client, Origin.Address address) {
            super(client, new HttpConversation(), URI.create("http://" + address.asString()));
        }
    }

    private static class TunnelPromise
    implements Promise<Connection> {
        private final Request request;
        private final Response.CompleteListener listener;
        private final Promise<Connection> promise;

        private TunnelPromise(Request request, Response.CompleteListener listener, Promise<Connection> promise) {
            this.request = request;
            this.listener = listener;
            this.promise = promise;
        }

        @Override
        public void succeeded(Connection connection) {
            connection.send(this.request, this.listener);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }

        private void setEndPoint(EndPoint endPoint) {
            HttpConversation conversation = ((HttpRequest)this.request).getConversation();
            conversation.setAttribute(EndPoint.class.getName(), endPoint);
        }
    }

    private static class ProxyConnection
    implements Connection,
    Attachable {
        private final Destination destination;
        private final Connection connection;
        private final Promise<Connection> promise;
        private Object attachment;

        private ProxyConnection(Destination destination, Connection connection, Promise<Connection> promise) {
            this.destination = destination;
            this.connection = connection;
            this.promise = promise;
        }

        @Override
        public void send(Request request, Response.CompleteListener listener) {
            if (this.connection.isClosed()) {
                this.destination.newConnection(new TunnelPromise(request, listener, this.promise));
            } else {
                this.connection.send(request, listener);
            }
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public void setAttachment(Object obj) {
            this.attachment = obj;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }
    }

    private static class CreateTunnelPromise
    implements Promise<Connection> {
        private final ClientConnectionFactory connectionFactory;
        private final EndPoint endPoint;
        private final Promise<Connection> promise;
        private final Map<String, Object> context;

        private CreateTunnelPromise(ClientConnectionFactory connectionFactory, EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
            this.connectionFactory = connectionFactory;
            this.endPoint = endPoint;
            this.promise = promise;
            this.context = context;
        }

        @Override
        public void succeeded(Connection connection) {
            this.context.put("org.eclipse.jetty.client.connection.promise", this.promise);
            HttpDestination destination = (HttpDestination)this.context.get("org.eclipse.jetty.client.destination");
            this.tunnel(destination, connection);
        }

        @Override
        public void failed(Throwable x) {
            this.tunnelFailed(this.endPoint, x);
        }

        private void tunnel(HttpDestination destination, Connection connection) {
            String target = destination.getOrigin().getAddress().asString();
            Origin.Address proxyAddress = destination.getConnectAddress();
            HttpClient httpClient = destination.getHttpClient();
            long connectTimeout = httpClient.getConnectTimeout();
            Request connect = new TunnelRequest(httpClient, proxyAddress).method(HttpMethod.CONNECT).path(target).headers(headers -> headers.put(HttpHeader.HOST, target)).timeout(connectTimeout, TimeUnit.MILLISECONDS);
            ProxyConfiguration.Proxy proxy = destination.getProxy();
            if (proxy.isSecure()) {
                connect.scheme(HttpScheme.HTTPS.asString());
            }
            connect.attribute(Connection.class.getName(), new ProxyConnection(destination, connection, this.promise));
            connection.send(connect, new TunnelListener(connect));
        }

        private void tunnelSucceeded(EndPoint endPoint) {
            try {
                HttpDestination destination = (HttpDestination)this.context.get("org.eclipse.jetty.client.destination");
                ClientConnectionFactory connectionFactory = this.connectionFactory;
                if (destination.isSecure()) {
                    InetSocketAddress address = InetSocketAddress.createUnresolved(destination.getHost(), destination.getPort());
                    this.context.put("org.eclipse.jetty.client.connector.remoteSocketAddress", address);
                    connectionFactory = destination.newSslClientConnectionFactory(null, connectionFactory);
                }
                org.eclipse.jetty.io.Connection oldConnection = endPoint.getConnection();
                org.eclipse.jetty.io.Connection newConnection = connectionFactory.newConnection(endPoint, this.context);
                endPoint.upgrade(newConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP tunnel established: {} over {}", (Object)oldConnection, (Object)newConnection);
                }
            }
            catch (Throwable x) {
                this.tunnelFailed(endPoint, x);
            }
        }

        private void tunnelFailed(EndPoint endPoint, Throwable failure) {
            endPoint.close(failure);
            this.promise.failed(failure);
        }

        private class TunnelListener
        extends Response.Listener.Adapter {
            private final HttpConversation conversation;

            private TunnelListener(Request request) {
                this.conversation = ((HttpRequest)request).getConversation();
            }

            @Override
            public void onHeaders(Response response) {
                EndPoint endPoint = (EndPoint)this.conversation.getAttribute(EndPoint.class.getName());
                if (response.getStatus() == 200) {
                    CreateTunnelPromise.this.tunnelSucceeded(endPoint);
                } else {
                    HttpResponseException failure = new HttpResponseException("Unexpected " + String.valueOf(response) + " for " + String.valueOf(response.getRequest()), response);
                    CreateTunnelPromise.this.tunnelFailed(endPoint, failure);
                }
            }

            @Override
            public void onComplete(Result result2) {
                if (result2.isFailed()) {
                    CreateTunnelPromise.this.tunnelFailed(CreateTunnelPromise.this.endPoint, result2.getFailure());
                }
            }
        }
    }
}

