/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Type;
import org.apache.solr.common.util.Validator;

class TypeValidator
extends Validator<Object> {
    private Set<Type> types = new HashSet<Type>(1);

    TypeValidator(Map<?, ?> schema, Object type2) {
        super(schema, type2);
        if (type2 instanceof List) {
            for (Object t : (List)type2) {
                this.types.add(this.getType(t.toString()));
            }
        } else {
            this.types.add(this.getType(type2.toString()));
        }
    }

    private Type getType(String typeStr) {
        try {
            return Type.valueOf(typeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown type " + typeStr);
        }
    }

    @Override
    boolean validate(Object o, List<String> errs) {
        for (Type type2 : this.types) {
            if (!type2.isValid(o)) continue;
            return true;
        }
        errs.add("Value is not valid, expected one of: " + this.types + ", found: " + o.getClass().getSimpleName());
        return false;
    }
}

