/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.List;
import java.util.Map;

enum Type {
    STRING(String.class),
    ARRAY(List.class),
    NUMBER(Number.class),
    INTEGER((Class)Long.class){

        @Override
        boolean isValid(Object o) {
            if (super.isValid(o)) {
                return true;
            }
            try {
                Long.parseLong(String.valueOf(o));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        boolean isValid(Object o) {
            if (super.isValid(o)) {
                return true;
            }
            try {
                Long.parseLong(String.valueOf(o));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        boolean isValid(Object o) {
            if (super.isValid(o)) {
                return true;
            }
            try {
                Boolean.parseBoolean(String.valueOf(o));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    ENUM(List.class),
    OBJECT(Map.class),
    NULL(null),
    UNKNOWN(Object.class);

    final Class<?> type;

    private Type(Class<?> type2) {
        this.type = type2;
    }

    boolean isValid(Object o) {
        if (this.type == null) {
            return o == null;
        }
        return this.type.isInstance(o);
    }
}

