/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void retryOnException(Class<? extends Exception> clazz, long timeoutms, long intervalms, RetryCmd cmd) throws Exception {
        RetryUtil.retryOnException(Collections.singleton(clazz), timeoutms, intervalms, cmd);
    }

    public static void retryOnException(Set<Class<? extends Exception>> classes2, long timeoutms, long intervalms, RetryCmd cmd) throws Exception {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        while (true) {
            try {
                cmd.execute();
            }
            catch (Exception t) {
                if (RetryUtil.isInstanceOf(classes2, t) && System.nanoTime() < timeout) {
                    if (log.isInfoEnabled()) {
                        log.info("Retry due to Exception, {} ", (Object)t.getClass().getName(), (Object)t);
                    }
                    Thread.sleep(intervalms);
                    continue;
                }
                throw t;
            }
            break;
        }
    }

    private static boolean isInstanceOf(Set<Class<? extends Exception>> classes2, Throwable t) {
        for (Class<? extends Exception> c : classes2) {
            if (!c.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static void retryUntil(String errorMessage2, int retries, long pauseTime, TimeUnit pauseUnit, BooleanRetryCmd cmd) throws InterruptedException {
        while (retries-- > 0) {
            if (cmd.execute()) {
                return;
            }
            pauseUnit.sleep(pauseTime);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errorMessage2);
    }

    public static void retryOnBoolean(long timeoutms, long intervalms, BooleanRetryCmd cmd) {
        boolean resp;
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        while (!(resp = cmd.execute()) && System.nanoTime() < timeout) {
        }
        if (System.nanoTime() >= timeout) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out while retrying operation");
        }
    }

    public static interface BooleanRetryCmd {
        public boolean execute();
    }

    public static interface RetryCmd {
        public void execute() throws Exception;
    }
}

