/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.solr.common.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReleaseTracker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> DEFAULT_STACK_FILTERS = Arrays.asList("org.junit.", "junit.framework.", "sun.", "java.lang.reflect.", "com.carrotsearch.randomizedtesting.");
    public static final Map<Object, Exception> OBJECTS = new ConcurrentHashMap<Object, Exception>();

    public static boolean track(Object object) {
        Throwable submitter = ExecutorUtil.submitter.get();
        OBJECTS.put(object, new ObjectTrackerException(object.getClass().getName(), submitter));
        return true;
    }

    public static boolean release(Object object) {
        OBJECTS.remove(object);
        return true;
    }

    public static void clear() {
        OBJECTS.clear();
    }

    public static String checkEmpty() {
        if (OBJECTS.isEmpty()) {
            return null;
        }
        StringBuilder error = new StringBuilder();
        error.append("ObjectTracker found ").append(OBJECTS.size()).append(" object(s) that were not released!!! ");
        ArrayList<String> objects = new ArrayList<String>(OBJECTS.size());
        for (Object object : OBJECTS.keySet()) {
            Class<?> clazz = object.getClass();
            objects.add(clazz.isAnonymousClass() ? clazz.getSuperclass().getSimpleName() : clazz.getSimpleName());
        }
        error.append(objects).append("\n");
        for (Map.Entry entry : OBJECTS.entrySet()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((Exception)entry.getValue()).printStackTrace(pw);
            error.append(entry.getKey().getClass().getName()).append(":");
            error.append(sw).append("\n");
        }
        return error.toString();
    }

    public static void tryClose() {
        for (Object object : OBJECTS.keySet()) {
            if (object instanceof Closeable) {
                try {
                    ((Closeable)object).close();
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                continue;
            }
            if (!(object instanceof ExecutorService)) continue;
            try {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)object);
            }
            catch (Throwable t) {
                log.error("", t);
            }
        }
    }

    public static String clearObjectTrackerAndCheckEmpty() {
        String result2 = ObjectReleaseTracker.checkEmpty();
        ObjectReleaseTracker.clear();
        return result2;
    }

    static class ObjectTrackerException
    extends RuntimeException {
        ObjectTrackerException(String msg, Throwable submitter) {
            super(msg, submitter);
        }
    }
}

