/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.solr.common.util.EnumValidator;
import org.apache.solr.common.util.ItemsValidator;
import org.apache.solr.common.util.OneOfValidator;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.PropertiesValidator;
import org.apache.solr.common.util.RequiredValidator;
import org.apache.solr.common.util.TypeValidator;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.Validator;

public class JsonSchemaValidator {
    private List<Validator<?>> validators = new ArrayList();
    private static Set<String> KNOWN_FNAMES = new HashSet<String>(Arrays.asList("description", "documentation", "default", "additionalProperties"));
    static final Map<String, Function<Pair<Map<?, ?>, ?>, Validator<?>>> VALIDATORS = new HashMap();

    public JsonSchemaValidator(String jsonString) {
        this((Map)Utils.fromJSONString(jsonString));
    }

    public JsonSchemaValidator(Map<?, ?> jsonSchema) {
        for (Map.Entry<?, ?> entry : jsonSchema.entrySet()) {
            Object fname = entry.getKey();
            if (KNOWN_FNAMES.contains(fname.toString())) continue;
            Function<Pair<Map<?, ?>, ?>, Validator<?>> initializeFunction = VALIDATORS.get(fname.toString());
            if (initializeFunction == null) {
                throw new RuntimeException("Unknown key : " + fname);
            }
            this.validators.add(initializeFunction.apply(new Pair(jsonSchema, entry.getValue())));
        }
    }

    private static void loadValidators() {
        VALIDATORS.put("items", pair -> new ItemsValidator((Map)pair.first(), (Map)pair.second()));
        VALIDATORS.put("enum", pair -> new EnumValidator((Map)pair.first(), (List)pair.second()));
        VALIDATORS.put("properties", pair -> new PropertiesValidator((Map)pair.first(), (Map)pair.second()));
        VALIDATORS.put("type", pair -> new TypeValidator((Map<?, ?>)((Map)pair.first()), pair.second()));
        VALIDATORS.put("required", pair -> new RequiredValidator((Map)pair.first(), (List)pair.second()));
        VALIDATORS.put("oneOf", pair -> new OneOfValidator((Map)pair.first(), (List)pair.second()));
    }

    public List<String> validateJson(Object data2) {
        ArrayList<String> errs = new ArrayList<String>();
        this.validate(data2, errs);
        return errs.isEmpty() ? null : errs;
    }

    boolean validate(Object data2, List<String> errs) {
        if (data2 == null) {
            return true;
        }
        for (Validator<?> validator : this.validators) {
            if (validator.validate(data2, errs)) continue;
            return false;
        }
        return true;
    }

    static {
        JsonSchemaValidator.loadValidators();
    }
}

