/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final ThreadLocal<Throwable> submitter = new ThreadLocal();
    private static volatile List<InheritableThreadLocalProvider> providers = new ArrayList<InheritableThreadLocalProvider>();
    private static final ThreadLocal<Boolean> isServerPool = new ThreadLocal();

    public static void resetThreadLocalProviders() {
        providers = new ArrayList<InheritableThreadLocalProvider>();
    }

    public static synchronized void addThreadLocalProvider(InheritableThreadLocalProvider provider) {
        for (InheritableThreadLocalProvider p : providers) {
            if (!p.getClass().equals(provider.getClass())) continue;
            return;
        }
        ArrayList<InheritableThreadLocalProvider> copy2 = new ArrayList<InheritableThreadLocalProvider>(providers);
        copy2.add(provider);
        providers = copy2;
    }

    public static boolean isShutdown(ExecutorService pool) {
        try {
            return pool.isShutdown();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static boolean isTerminated(ExecutorService pool) {
        try {
            return pool.isTerminated();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdown();
        ExecutorUtil.awaitTermination(pool);
    }

    public static void shutdownNowAndAwaitTermination(ExecutorService pool) {
        if (pool == null) {
            return;
        }
        pool.shutdownNow();
        ExecutorUtil.awaitTermination(pool);
    }

    public static void awaitTermination(ExecutorService pool) {
        ExecutorUtil.awaitTermination(pool, 60L, TimeUnit.SECONDS);
    }

    static void awaitTermination(ExecutorService pool, long timeout, TimeUnit unit) {
        try {
            if (!pool.awaitTermination(timeout, unit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, unit)) {
                    log.error("Threads from pool {} did not forcefully stop.", (Object)pool);
                    throw new RuntimeException("Timeout waiting for pool " + pool + " to shutdown.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ExecutorService newMDCAwareFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareSingleThreadExecutor(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareCachedThreadPool(String name) {
        return ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory(name));
    }

    public static ExecutorService newMDCAwareCachedThreadPool(ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newMDCAwareCachedThreadPool(int maxThreads, ThreadFactory threadFactory) {
        return new MDCAwareThreadPoolExecutor(0, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxThreads), threadFactory);
    }

    public static boolean isSolrServerThread() {
        return Boolean.TRUE.equals(isServerPool.get());
    }

    public static void setServerThreadFlag(Boolean flag) {
        if (flag == null) {
            isServerPool.remove();
        } else {
            isServerPool.set(flag);
        }
    }

    @SuppressForbidden(reason="class customizes ThreadPoolExecutor so it can be used instead")
    public static class MDCAwareThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final int MAX_THREAD_NAME_LEN = 512;
        private final boolean enableSubmitterStackTrace;

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            this.enableSubmitterStackTrace = true;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
            this.enableSubmitterStackTrace = true;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, true);
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, boolean enableSubmitterStackTrace) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.enableSubmitterStackTrace = enableSubmitterStackTrace;
        }

        public MDCAwareThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
            this.enableSubmitterStackTrace = true;
        }

        @Override
        public void execute(Runnable command) {
            ArrayList<AtomicReference<Object>> ctx;
            Exception submitterStackTrace;
            String ctxStr;
            String submitterContextStr;
            Map<String, String> submitterContext = MDC.getCopyOfContextMap();
            StringBuilder contextString = new StringBuilder();
            if (submitterContext != null) {
                Collection<String> values2 = submitterContext.values();
                for (String value : values2) {
                    contextString.append(value).append(' ');
                }
                if (contextString.length() > 1) {
                    contextString.setLength(contextString.length() - 1);
                }
            }
            String string = submitterContextStr = (ctxStr = contextString.toString().replace("/", "//")).length() <= 512 ? ctxStr : ctxStr.substring(0, 512);
            if (this.enableSubmitterStackTrace) {
                Throwable grandParentSubmitter = submitter.get();
                submitterStackTrace = new Exception("Submitter stack trace", grandParentSubmitter);
            } else {
                submitterStackTrace = null;
            }
            List<InheritableThreadLocalProvider> providersCopy = providers;
            ArrayList<AtomicReference<Object>> arrayList = ctx = providersCopy.isEmpty() ? null : new ArrayList<AtomicReference<Object>>(providersCopy.size());
            if (ctx != null) {
                for (int i = 0; i < providers.size(); ++i) {
                    AtomicReference<Object> reference = new AtomicReference<Object>();
                    ctx.add(reference);
                    providersCopy.get(i).store(reference);
                }
            }
            super.execute(() -> {
                isServerPool.set(Boolean.TRUE);
                if (ctx != null) {
                    for (int i = 0; i < providersCopy.size(); ++i) {
                        ((InheritableThreadLocalProvider)providersCopy.get(i)).set((AtomicReference)ctx.get(i));
                    }
                }
                Map<String, String> threadContext = MDC.getCopyOfContextMap();
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                if (submitterContext != null && !submitterContext.isEmpty()) {
                    MDC.setContextMap(submitterContext);
                    currentThread.setName(oldName + "-processing-" + submitterContextStr);
                } else {
                    MDC.clear();
                }
                if (this.enableSubmitterStackTrace) {
                    submitter.set(submitterStackTrace);
                }
                try {
                    command.run();
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError) {
                        throw t;
                    }
                    if (this.enableSubmitterStackTrace) {
                        log.error("Uncaught exception {} thrown by thread: {}", t, currentThread.getName(), submitterStackTrace);
                    } else {
                        log.error("Uncaught exception {} thrown by thread: {}", (Object)t, (Object)currentThread.getName());
                    }
                    throw t;
                }
                finally {
                    isServerPool.remove();
                    if (threadContext != null && !threadContext.isEmpty()) {
                        MDC.setContextMap(threadContext);
                    } else {
                        MDC.clear();
                    }
                    if (ctx != null) {
                        for (int i = 0; i < providersCopy.size(); ++i) {
                            ((InheritableThreadLocalProvider)providersCopy.get(i)).clean((AtomicReference)ctx.get(i));
                        }
                    }
                    currentThread.setName(oldName);
                }
            });
        }
    }

    public static interface InheritableThreadLocalProvider {
        public void store(AtomicReference<Object> var1);

        public void set(AtomicReference<Object> var1);

        public void clean(AtomicReference<Object> var1);
    }
}

