/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Comparator;
import org.apache.solr.common.cloud.Replica;

public class ReplicaPosition
implements Comparable<ReplicaPosition> {
    public final String collection;
    public final String shard;
    public final int index;
    public final Replica.Type type;
    public String node;
    private static final Comparator<ReplicaPosition> comparator = Comparator.comparing(rp -> rp.collection).thenComparing(rp -> rp.shard).thenComparing(rp -> rp.type).thenComparingInt(rp -> rp.index);

    public ReplicaPosition(String collection, String shard, int replicaIdx, Replica.Type type2) {
        this.collection = collection;
        this.shard = shard;
        this.index = replicaIdx;
        this.type = type2;
    }

    public ReplicaPosition(String collection, String shard, int replicaIdx, Replica.Type type2, String node) {
        this.collection = collection;
        this.shard = shard;
        this.index = replicaIdx;
        this.type = type2;
        this.node = node;
    }

    @Override
    public int compareTo(ReplicaPosition that) {
        return comparator.compare(this, that);
    }

    public String toString() {
        return this.shard + ":" + this.index + "[" + this.type + "] @" + this.node;
    }

    public ReplicaPosition setNode(String node) {
        this.node = node;
        return this;
    }
}

