/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;

public class NodesSysPropsCacher
implements NodesSysProps,
AutoCloseable {
    private volatile boolean isClosed = false;
    private final Map<String, Map<String, Object>> nodeVsTagsCache = new ConcurrentHashMap<String, Map<String, Object>>();
    private ZkStateReader zkStateReader;
    private final SolrClient solrClient;

    public NodesSysPropsCacher(SolrClient solrClient, ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.solrClient = solrClient;
        zkStateReader.registerLiveNodesListener((oldNodes, newNodes) -> {
            for (String n : oldNodes) {
                if (newNodes.contains(n)) continue;
                this.nodeVsTagsCache.remove(n);
            }
            return this.isClosed;
        });
    }

    @Override
    public Map<String, Object> getSysProps(String nodeName, Collection<String> tags) {
        LinkedHashMap<String, Object> cached = this.nodeVsTagsCache.computeIfAbsent(nodeName, s -> new LinkedHashMap());
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        for (String tag : tags) {
            if (!cached.containsKey(tag)) {
                Map<String, Object> props = this.fetchProps(nodeName, tags);
                cached = new LinkedHashMap<String, Object>(cached);
                cached.putAll(props);
                this.nodeVsTagsCache.put(nodeName, cached);
                return props;
            }
            result2.put(tag, cached.get(tag));
        }
        return result2;
    }

    private Map<String, Object> fetchProps(String nodeName, Collection<String> tags) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        msp.add("omitHeader", "true");
        LinkedHashMap<String, Object> keys2 = new LinkedHashMap<String, Object>();
        for (String tag2 : tags) {
            String metricsKey = "solr.jvm:system.properties:" + tag2;
            keys2.put(tag2, metricsKey);
            msp.add("key", metricsKey);
        }
        GenericSolrRequest req = new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/metrics", msp);
        req.setBasePath(this.zkStateReader.getBaseUrlForNodeName(nodeName));
        try {
            LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
            NamedList<Object> response = this.solrClient.request(req);
            NavigableObject metrics = (NavigableObject)response._get("metrics", (Object)MapWriter.EMPTY);
            keys2.forEach((tag, key) -> result2.put((String)tag, metrics._get((String)key, (Object)null)));
            return result2;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }
}

