/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocCollection
extends ZkNodeProps
implements Iterable<Slice> {
    public static final String COLLECTIONS_ZKNODE = "/collections";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int znodeVersion;
    private final String name;
    private final String configName;
    private final Map<String, Slice> slices;
    private final Map<String, Slice> activeSlices;
    private final Slice[] activeSlicesArr;
    private final Map<String, List<Replica>> nodeNameReplicas;
    private final Map<String, List<Replica>> nodeNameLeaderReplicas;
    private final DocRouter router;
    private final String znode;
    private final Integer replicationFactor;
    private final Integer numNrtReplicas;
    private final Integer numTlogReplicas;
    private final Integer numPullReplicas;
    private final Boolean readOnly;
    private final Boolean perReplicaState;
    private final Map<String, Replica> replicaMap = new HashMap<String, Replica>();
    private PrsSupplier prsSupplier;

    @Deprecated
    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router) {
        this(name, slices, props, router, Integer.MAX_VALUE, null);
    }

    @Deprecated
    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion) {
        this(name, slices, props, router, zkVersion, null);
    }

    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router, int zkVersion, PrsSupplier prsSupplier) {
        super(props);
        Boolean readOnly;
        this.znodeVersion = zkVersion == -1 ? Integer.MAX_VALUE : zkVersion;
        this.name = name;
        this.configName = (String)props.get("configName");
        this.slices = slices;
        this.activeSlices = new HashMap<String, Slice>();
        this.nodeNameLeaderReplicas = new HashMap<String, List<Replica>>();
        this.nodeNameReplicas = new HashMap<String, List<Replica>>();
        this.replicationFactor = (Integer)DocCollection.verifyProp(props, "replicationFactor");
        this.numNrtReplicas = (Integer)DocCollection.verifyProp(props, "nrtReplicas", 0);
        this.numTlogReplicas = (Integer)DocCollection.verifyProp(props, "tlogReplicas", 0);
        this.numPullReplicas = (Integer)DocCollection.verifyProp(props, "pullReplicas", 0);
        this.perReplicaState = (Boolean)DocCollection.verifyProp(props, "perReplicaState", Boolean.FALSE);
        if (this.perReplicaState.booleanValue()) {
            if (prsSupplier == null) {
                throw new RuntimeException("perReplicaState = true , but per-replica state supplier is not provided");
            }
            this.prsSupplier = prsSupplier;
            for (Slice s : this.slices.values()) {
                s.setPrsSupplier(prsSupplier);
            }
        }
        this.readOnly = (readOnly = (Boolean)DocCollection.verifyProp(props, "readOnly")) == null ? Boolean.FALSE : readOnly;
        for (Map.Entry<String, Slice> slice : slices.entrySet()) {
            if (slice.getValue().getState() == Slice.State.ACTIVE) {
                this.activeSlices.put(slice.getKey(), slice.getValue());
            }
            for (Replica replica : slice.getValue()) {
                this.addNodeNameReplica(replica);
                if (!this.perReplicaState.booleanValue()) continue;
                this.replicaMap.put(replica.getName(), replica);
            }
        }
        this.activeSlicesArr = this.activeSlices.values().toArray(new Slice[this.activeSlices.size()]);
        this.router = router;
        this.znode = DocCollection.getCollectionPath(name);
        assert (name != null && slices != null);
    }

    public static String getCollectionPath(String coll) {
        return DocCollection.getCollectionPathRoot(coll) + "/state.json";
    }

    public static String getCollectionPathRoot(String coll) {
        return "/collections/" + coll;
    }

    public DocCollection copyWith(PerReplicaStates newPerReplicaStates) {
        if (this.prsSupplier != null) {
            log.debug("In-place update of PRS: {}", (Object)newPerReplicaStates);
            this.prsSupplier.prs = newPerReplicaStates;
        }
        return this;
    }

    private void addNodeNameReplica(Replica replica) {
        List<Replica> replicas = this.nodeNameReplicas.get(replica.getNodeName());
        if (replicas == null) {
            replicas = new ArrayList<Replica>();
            this.nodeNameReplicas.put(replica.getNodeName(), replicas);
        }
        replicas.add(replica);
        if (replica.getStr("leader") != null) {
            List<Replica> leaderReplicas = this.nodeNameLeaderReplicas.get(replica.getNodeName());
            if (leaderReplicas == null) {
                leaderReplicas = new ArrayList<Replica>();
                this.nodeNameLeaderReplicas.put(replica.getNodeName(), leaderReplicas);
            }
            leaderReplicas.add(replica);
        }
    }

    public static Object verifyProp(Map<String, Object> props, String propName) {
        return DocCollection.verifyProp(props, propName, null);
    }

    public static Object verifyProp(Map<String, Object> props, String propName, Object def) {
        Object o = props.get(propName);
        if (o == null) {
            return def;
        }
        switch (propName) {
            case "replicationFactor": 
            case "nrtReplicas": 
            case "pullReplicas": 
            case "tlogReplicas": {
                return Integer.parseInt(o.toString());
            }
            case "perReplicaState": 
            case "readOnly": {
                return Boolean.parseBoolean(o.toString());
            }
        }
        return o;
    }

    public DocCollection copyWithSlices(Map<String, Slice> slices) {
        DocCollection result2 = new DocCollection(this.getName(), slices, this.propMap, this.router, this.znodeVersion, this.prsSupplier);
        return result2;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigName() {
        assert (this.configName != null);
        return this.configName;
    }

    public Slice getSlice(String sliceName) {
        return this.slices.get(sliceName);
    }

    public void forEachReplica(BiConsumer<String, Replica> consumer) {
        this.slices.forEach((? super K shard, ? super V slice) -> slice.getReplicasMap().forEach((? super K s, ? super V replica) -> consumer.accept((String)shard, (Replica)replica)));
    }

    public Collection<Slice> getSlices() {
        return this.slices.values();
    }

    public Collection<Slice> getActiveSlices() {
        return this.activeSlices.values();
    }

    public Slice[] getActiveSlicesArr() {
        return this.activeSlicesArr;
    }

    public Map<String, Slice> getSlicesMap() {
        return this.slices;
    }

    public Map<String, Slice> getActiveSlicesMap() {
        return this.activeSlices;
    }

    public List<Replica> getReplicas(String nodeName) {
        return this.nodeNameReplicas.get(nodeName);
    }

    public List<Replica> getLeaderReplicas(String nodeName) {
        return this.nodeNameLeaderReplicas.get(nodeName);
    }

    public int getZNodeVersion() {
        return this.znodeVersion;
    }

    public int getChildNodesVersion() {
        PerReplicaStates prs = this.prsSupplier == null ? null : this.prsSupplier.get();
        return prs == null ? 0 : prs.cversion;
    }

    public boolean isModified(int dataVersion, int childVersion) {
        if (dataVersion > this.znodeVersion) {
            return true;
        }
        return childVersion > this.getChildNodesVersion();
    }

    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getZNode() {
        return this.znode;
    }

    public DocRouter getRouter() {
        return this.router;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String toString() {
        return "DocCollection(" + this.name + "/" + this.getZNode() + "/" + this.znodeVersion + " " + (this.prsSupplier == null ? "" : this.prsSupplier.get()) + ")=" + Utils.toJSONString(this);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        LinkedHashMap<String, Map<String, Slice>> all = new LinkedHashMap<String, Map<String, Slice>>(this.slices.size() + 1);
        all.putAll(this.propMap);
        all.put("shards", this.slices);
        jsonWriter.write(all);
    }

    public Replica getReplica(String coreNodeName) {
        if (this.perReplicaState.booleanValue()) {
            return this.replicaMap.get(coreNodeName);
        }
        for (Slice slice : this.slices.values()) {
            Replica replica = slice.getReplica(coreNodeName);
            if (replica == null) continue;
            return replica;
        }
        return null;
    }

    public Replica getLeader(String sliceName) {
        Slice slice = this.getSlice(sliceName);
        if (slice == null) {
            return null;
        }
        return slice.getLeader();
    }

    public static boolean isFullyActive(Set<String> liveNodes, DocCollection collectionState, int expectedShards, int expectedReplicas) {
        Objects.requireNonNull(liveNodes);
        if (collectionState == null) {
            return false;
        }
        int activeShards = 0;
        for (Slice slice : collectionState) {
            int activeReplicas = 0;
            for (Replica replica : slice) {
                if (!replica.isActive(liveNodes)) {
                    return false;
                }
                ++activeReplicas;
            }
            if (activeReplicas != expectedReplicas) {
                return false;
            }
            ++activeShards;
        }
        return activeShards == expectedShards;
    }

    @Override
    public Iterator<Slice> iterator() {
        return this.slices.values().iterator();
    }

    public List<Replica> getReplicas() {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas());
        }
        return replicas;
    }

    public Replica getReplica(BiPredicate<String, Replica> predicate) {
        Replica[] result2 = new Replica[1];
        this.forEachReplica((s, replica) -> {
            if (result2[0] != null) {
                return;
            }
            if (predicate.test((String)s, (Replica)replica)) {
                result2[0] = replica;
            }
        });
        return result2[0];
    }

    public List<Replica> getReplicas(EnumSet<Replica.Type> s) {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Slice slice : this) {
            replicas.addAll(slice.getReplicas(s));
        }
        return replicas;
    }

    public String getShardId(String nodeName, String coreName) {
        for (Slice slice : this) {
            for (Replica replica : slice) {
                if (!Objects.equals(replica.getNodeName(), nodeName) || !Objects.equals(replica.getCoreName(), coreName)) continue;
                return slice.getName();
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof DocCollection)) {
            return false;
        }
        DocCollection other = (DocCollection)that;
        return super.equals(that) && Objects.equals(this.name, other.name) && this.znodeVersion == other.znodeVersion && this.getChildNodesVersion() == other.getChildNodesVersion();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.znodeVersion, this.getChildNodesVersion());
    }

    public Integer getNumNrtReplicas() {
        return this.numNrtReplicas;
    }

    public Integer getNumTlogReplicas() {
        return this.numTlogReplicas;
    }

    public Integer getNumPullReplicas() {
        return this.numPullReplicas;
    }

    public boolean isPerReplicaState() {
        return Boolean.TRUE.equals(this.perReplicaState);
    }

    public PerReplicaStates getPerReplicaStates() {
        return this.prsSupplier != null ? this.prsSupplier.get() : null;
    }

    public PrsSupplier getPrsSupplier() {
        return this.prsSupplier;
    }

    public int getExpectedReplicaCount(Replica.Type type2, int def) {
        Integer result2 = null;
        if (type2 == Replica.Type.NRT) {
            result2 = this.numNrtReplicas;
        }
        if (type2 == Replica.Type.PULL) {
            result2 = this.numPullReplicas;
        }
        if (type2 == Replica.Type.TLOG) {
            result2 = this.numTlogReplicas;
        }
        return result2 == null ? def : result2;
    }

    public static class PrsSupplier
    implements Supplier<PerReplicaStates> {
        private volatile PerReplicaStates prs;
        private Supplier<PerReplicaStates> supplier;

        public PrsSupplier(Supplier<PerReplicaStates> supplier) {
            this.supplier = supplier;
        }

        public PrsSupplier(PerReplicaStates prs) {
            this.prs = prs;
        }

        @Override
        public PerReplicaStates get() {
            if (this.prs == null) {
                this.prs = this.supplier.get();
            }
            return this.prs;
        }
    }

    public static interface CollectionStateProps {
        public static final String NRT_REPLICAS = "nrtReplicas";
        public static final String PULL_REPLICAS = "pullReplicas";
        public static final String TLOG_REPLICAS = "tlogReplicas";
        public static final String REPLICATION_FACTOR = "replicationFactor";
        public static final String READ_ONLY = "readOnly";
        public static final String CONFIGNAME = "configName";
        public static final String DOC_ROUTER = "router";
        public static final String SHARDS = "shards";
        public static final String PER_REPLICA_STATE = "perReplicaState";
    }
}

