/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class CollectionProperties {
    private final SolrZkClient client;

    public CollectionProperties(SolrZkClient client) {
        this.client = client;
    }

    public String getCollectionProperty(String collection, String key, String defaultValue) throws IOException {
        String value = this.getCollectionProperties(collection).get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> getCollectionProperties(String collection) throws IOException {
        try {
            return (Map)Utils.fromJSON(this.client.getData(ZkStateReader.getCollectionPropsPath(collection), null, new Stat(), true));
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading properties for collection " + collection, SolrZkClient.checkInterrupted(e));
        }
    }

    public void setCollectionProperty(String collection, String propertyName, String propertyValue) throws IOException {
        String znodePath = ZkStateReader.getCollectionPropsPath(collection);
        while (true) {
            Stat s = new Stat();
            try {
                if (this.client.exists(znodePath, true).booleanValue()) {
                    Map properties2 = (Map)Utils.fromJSON(this.client.getData(znodePath, null, s, true));
                    if (propertyValue == null) {
                        if (properties2.remove(propertyName) == null) break;
                        this.client.setData(znodePath, Utils.toJSON(properties2), s.getVersion(), true);
                        break;
                    }
                    if (propertyValue.equals(properties2.put(propertyName, propertyValue))) break;
                    this.client.setData(znodePath, Utils.toJSON(properties2), s.getVersion(), true);
                    break;
                }
                LinkedHashMap<String, String> properties3 = new LinkedHashMap<String, String>();
                properties3.put(propertyName, propertyValue);
                this.client.create(znodePath, Utils.toJSON(properties3), CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                continue;
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Error setting property for collection " + collection, SolrZkClient.checkInterrupted(e));
            }
            break;
        }
    }
}

