/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterProperties {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String EXT_PROPRTTY_PREFIX = "ext.";
    private final SolrZkClient client;

    public ClusterProperties(SolrZkClient client) {
        this.client = client;
    }

    public <T> T getClusterProperty(String key, T defaultValue) throws IOException {
        Object value = Utils.getObjectByPath(this.getClusterProperties(), false, key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> T getClusterProperty(List<String> key, T defaultValue) throws IOException {
        Object value = Utils.getObjectByPath(this.getClusterProperties(), false, key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Map<String, Object> getClusterProperties() throws IOException {
        try {
            Map properties2 = (Map)Utils.fromJSON(this.client.getData("/clusterprops.json", null, new Stat(), true));
            return ClusterProperties.convertCollectionDefaultsToNestedFormat(properties2);
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading cluster property", SolrZkClient.checkInterrupted(e));
        }
    }

    public void setClusterProperties(Map<String, Object> properties2) throws IOException, KeeperException, InterruptedException {
        this.client.atomicUpdate("/clusterprops.json", zkData -> {
            if (zkData == null) {
                return Utils.toJSON(ClusterProperties.convertCollectionDefaultsToNestedFormat(properties2));
            }
            Map<String, Object> zkJson = (Map<String, Object>)Utils.fromJSON(zkData);
            boolean modified = Utils.mergeJson(zkJson = ClusterProperties.convertCollectionDefaultsToNestedFormat(zkJson), ClusterProperties.convertCollectionDefaultsToNestedFormat(properties2));
            return modified ? Utils.toJSON(zkJson) : null;
        });
    }

    public void update(MapWriter obj, String ... path) throws KeeperException, InterruptedException {
        this.client.atomicUpdate("/clusterprops.json", bytes -> {
            Map zkJson = bytes == null ? new LinkedHashMap() : (Map)Utils.fromJSON(bytes);
            Utils.setObjectByPath(zkJson, Arrays.asList(path), (Object)obj);
            return Utils.toJSON(zkJson);
        });
    }

    static Map<String, Object> convertCollectionDefaultsToNestedFormat(Map<String, Object> properties2) {
        if (properties2.containsKey("collectionDefaults")) {
            Map values2 = (Map)properties2.remove("collectionDefaults");
            if (values2 != null) {
                properties2.putIfAbsent("defaults", new LinkedHashMap());
                Map defaults = (Map)properties2.get("defaults");
                defaults.compute("collection", (k, v) -> {
                    if (v == null) {
                        return values2;
                    }
                    ((Map)v).putAll(values2);
                    return v;
                });
            } else {
                properties2.putIfAbsent("defaults", new LinkedHashMap());
                Map defaults = (Map)properties2.get("defaults");
                defaults.put("collection", null);
            }
        }
        return properties2;
    }

    public void setClusterProperty(String propertyName, Object propertyValue) throws IOException {
        this.validatePropertyName(propertyName);
        while (true) {
            Stat s = new Stat();
            try {
                if (this.client.exists("/clusterprops.json", true).booleanValue()) {
                    Map properties2 = (Map)Utils.fromJSON(this.client.getData("/clusterprops.json", null, s, true));
                    if (propertyValue == null) {
                        if (properties2.get(propertyName) == null) break;
                        properties2.remove(propertyName);
                        this.client.setData("/clusterprops.json", Utils.toJSON(properties2), s.getVersion(), true);
                        break;
                    }
                    if (propertyValue.equals(properties2.get(propertyName))) break;
                    properties2.put(propertyName, propertyValue);
                    this.client.setData("/clusterprops.json", Utils.toJSON(properties2), s.getVersion(), true);
                    break;
                }
                LinkedHashMap<String, Object> properties3 = new LinkedHashMap<String, Object>();
                properties3.put(propertyName, propertyValue);
                this.client.create("/clusterprops.json", Utils.toJSON(properties3), CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                continue;
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Error setting cluster property", SolrZkClient.checkInterrupted(e));
            }
            break;
        }
    }

    private void validatePropertyName(String propertyName) {
        if (!ZkStateReader.KNOWN_CLUSTER_PROPS.contains(propertyName) && !propertyName.startsWith(EXT_PROPRTTY_PREFIX)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not a known cluster property or starts with prefix ext., propertyName: " + propertyName);
        }
    }
}

