/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.solr.common.MapWriter;

public class ConditionalKeyMapWriter
implements MapWriter {
    private final MapWriter delegate;
    private final Predicate<CharSequence> predicate;

    public ConditionalKeyMapWriter(MapWriter delegate, Predicate<CharSequence> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.delegate != null) {
            this.delegate.writeMap(new EntryWriterWrapper(ew, this.predicate));
        }
    }

    public static Predicate<CharSequence> dedupeKeyPredicate(Set<CharSequence> keys2) {
        return k -> keys2.add((CharSequence)k);
    }

    public static class EntryWriterWrapper
    implements MapWriter.EntryWriter {
        private final MapWriter.EntryWriter delegate;
        private final Predicate<CharSequence> predicate;

        public EntryWriterWrapper(MapWriter.EntryWriter delegate, Predicate<CharSequence> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, int v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, long v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, float v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, double v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, boolean v) throws IOException {
            if (this.predicate.test(k)) {
                this.delegate.put(k, v);
            }
            return this;
        }
    }
}

