/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String JVM_SPEC_VERSION = System.getProperty("java.specification.version");
    public static final boolean JRE_IS_MINIMUM_JAVA9 = true;
    public static final boolean JRE_IS_MINIMUM_JAVA11 = true;
    public static final boolean IS_IBM_JAVA = Constants.isIBMJava();

    private static boolean isIBMJava() {
        try {
            Class.forName("com.ibm.security.auth.module.Krb5LoginModule", false, Constants.class.getClassLoader());
            return true;
        }
        catch (SecurityException se) {
            log.warn("Unable to determine if IBM Java due to SecurityException. Assuming not IBM Java.", se);
            return false;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

