/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;

public class StreamingUpdateRequest
extends AbstractUpdateRequest {
    private final RequestWriter.ContentWriter contentWriter;

    public StreamingUpdateRequest(String path, RequestWriter.ContentWriter contentWriter) {
        super(SolrRequest.METHOD.POST, path);
        this.contentWriter = contentWriter;
    }

    public StreamingUpdateRequest(String path, final String content, final String contentType) {
        this(path, new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                os.write(content.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public String getContentType() {
                return contentType;
            }
        });
    }

    public StreamingUpdateRequest(String path, final Path data2, final String contentType) {
        this(path, new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                try (InputStream is = Files.newInputStream(data2, new OpenOption[0]);){
                    is.transferTo(os);
                }
            }

            @Override
            public String getContentType() {
                return contentType;
            }
        });
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        return this.contentWriter;
    }
}

