/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;

public class RequestWriter {
    public ContentWriter getContentWriter(SolrRequest<?> req) {
        if (req instanceof UpdateRequest) {
            final UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isEmpty(updateRequest)) {
                return null;
            }
            return new ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                    updateRequest.writeXML(writer);
                    writer.flush();
                }

                @Override
                public String getContentType() {
                    return "application/xml; charset=UTF-8";
                }
            };
        }
        return req.getContentWriter("application/xml; charset=UTF-8");
    }

    @Deprecated
    public Collection<ContentStream> getContentStreams(SolrRequest<?> req) throws IOException {
        if (req instanceof UpdateRequest) {
            return null;
        }
        return req.getContentStreams();
    }

    protected boolean isEmpty(UpdateRequest updateRequest) {
        return this.isNull(updateRequest.getDocuments()) && this.isNull(updateRequest.getDeleteByIdMap()) && this.isNull(updateRequest.getDeleteQuery()) && updateRequest.getDocIterator() == null;
    }

    public String getPath(SolrRequest<?> req) {
        return req.getPath();
    }

    public void write(SolrRequest<?> request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            updateRequest.writeXML(writer);
            writer.flush();
        }
    }

    public String getUpdateContentType() {
        return "application/xml; charset=UTF-8";
    }

    protected boolean isNull(List<?> l) {
        return l == null || l.isEmpty();
    }

    protected boolean isNull(Map<?, ?> l) {
        return l == null || l.isEmpty();
    }

    public static class StringPayloadContentWriter
    implements ContentWriter {
        public final String payload;
        public final String type;

        public StringPayloadContentWriter(String payload, String type2) {
            this.payload = payload;
            this.type = type2;
        }

        @Override
        public void write(OutputStream os) throws IOException {
            if (this.payload == null) {
                return;
            }
            os.write(this.payload.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public String getContentType() {
            return this.type;
        }
    }

    public static interface ContentWriter {
        public void write(OutputStream var1) throws IOException;

        public String getContentType();
    }
}

