/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.io.stream.expr.InjectedExpressionException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;

public class InjectionDefense {
    private static final Pattern STRING_PARAM = Pattern.compile("\\?\\$\\?");
    private static final Pattern NUMBER_PARAM = Pattern.compile("\\?#\\?");
    private static final Pattern EXPRESSION_PARAM = Pattern.compile("\\?\\(\\d+\\)\\?");
    private static final Pattern EXPRESSION_COUNT = Pattern.compile("\\d+");
    private static final Pattern ANY_PARAM = Pattern.compile("\\?(?:[$#]|(?:\\(\\d+\\)))\\?");
    private static final Pattern INT_OR_FLOAT = Pattern.compile("-?\\d+(?:\\.\\d+)?");
    private String exprString;
    private int expressionCount;
    private List<String> params = new ArrayList<String>();

    public InjectionDefense(String exprString) {
        this.exprString = exprString;
        this.checkExpression(exprString);
    }

    public static String stripComments(String exprString) {
        return StreamExpressionParser.stripComments(exprString);
    }

    public void addParameter(String param) {
        this.params.add(param);
    }

    public StreamExpression safeExpression() {
        String exprStr = this.buildExpression();
        StreamExpression parsed = StreamExpressionParser.parse(exprStr);
        int actual = this.countExpressions(parsed);
        if (actual != this.expressionCount) {
            throw new InjectedExpressionException("Expected Expression count (" + this.expressionCount + ") does not match actual final expression count (" + actual + ")! (possible injection attack?)");
        }
        return parsed;
    }

    public String safeExpressionString() {
        String exprStr = this.buildExpression();
        StreamExpression parsed = StreamExpressionParser.parse(exprStr);
        if (this.countExpressions(parsed) != this.expressionCount) {
            throw new InjectedExpressionException("Expected Expression count does not match Actual final expression count! (possible injection attack?)");
        }
        return exprStr;
    }

    String buildExpression() {
        Matcher anyParam = ANY_PARAM.matcher(this.exprString);
        StringBuffer buff = new StringBuffer();
        int pIdx = 0;
        while (anyParam.find()) {
            String found = anyParam.group();
            String p = this.params.get(pIdx++);
            if (found.contains("#") && !INT_OR_FLOAT.matcher(p).matches()) {
                throw new NumberFormatException("Argument " + pIdx + " (" + p + ") is not numeric!");
            }
            anyParam.appendReplacement(buff, p);
        }
        anyParam.appendTail(buff);
        String result2 = buff.toString().trim();
        String noComments = InjectionDefense.stripComments(result2).trim();
        if (!result2.equals(noComments)) {
            throw new IllegalStateException("Comments are not allowed in prepared expressions for security reasons please pre-process stripComments() first. If there were no comments, then they have been injected by a parameter value.");
        }
        return buff.toString().trim();
    }

    private void checkExpression(String exprString) {
        exprString = STRING_PARAM.matcher(exprString).replaceAll("foo");
        exprString = NUMBER_PARAM.matcher(exprString).replaceAll("0");
        Matcher eMatcher = EXPRESSION_PARAM.matcher(exprString);
        StringBuffer temp = new StringBuffer();
        while (eMatcher.find()) {
            Matcher counter = EXPRESSION_COUNT.matcher(eMatcher.group());
            eMatcher.appendReplacement(temp, "noop()");
            if (!counter.find()) continue;
            Integer subExprCount = Integer.valueOf(counter.group());
            if (subExprCount < 1) {
                throw new IllegalStateException("Expression Param must contribute at least 1 expression! ?(1)? is the minimum allowed ");
            }
            this.expressionCount += subExprCount - 1;
        }
        eMatcher.appendTail(temp);
        exprString = temp.toString();
        StreamExpression parsed = StreamExpressionParser.parse(exprString);
        if (parsed != null) {
            this.expressionCount += this.countExpressions(parsed);
        } else {
            throw new IllegalStateException("Invalid expression (parse returned null):" + exprString);
        }
    }

    private int countExpressions(StreamExpression expression) {
        int result2 = 0;
        ArrayList<StreamExpressionParameter> exprToCheck = new ArrayList<StreamExpressionParameter>();
        exprToCheck.add(expression);
        while (exprToCheck.size() > 0) {
            StreamExpressionParameter remove = (StreamExpressionParameter)exprToCheck.remove(0);
            if (remove instanceof StreamExpressionNamedParameter) {
                remove = ((StreamExpressionNamedParameter)remove).getParameter();
            }
            if (!(remove instanceof StreamExpression)) continue;
            ++result2;
            for (StreamExpressionParameter parameter : ((StreamExpression)remove).getParameters()) {
                if (parameter instanceof StreamExpressionNamedParameter) {
                    parameter = ((StreamExpressionNamedParameter)parameter).getParameter();
                }
                if (!(parameter instanceof StreamExpression)) continue;
                exprToCheck.add(parameter);
            }
        }
        return result2;
    }
}

