/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.SingleValueComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TupStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map<String, String> stringParams = new HashMap<String, String>();
    private Map<String, StreamEvaluator> evaluatorParams = new HashMap<String, StreamEvaluator>();
    private Map<String, TupleStream> streamParams = new HashMap<String, TupleStream>();
    private List<String> fieldNames = new ArrayList<String>();
    private Map<String, String> fieldLabels = new HashMap<String, String>();
    private Tuple tup = null;
    private Tuple unnestedTuple = null;
    private Iterator<Tuple> unnestedTuples = null;
    private boolean finished;

    public TupStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter np : namedParams) {
            String name = np.getName();
            this.fieldNames.add(name);
            this.fieldLabels.put(name, name);
            StreamExpressionParameter param = np.getParameter();
            if (param instanceof StreamExpressionValue) {
                this.stringParams.put(name, ((StreamExpressionValue)param).getValue());
                continue;
            }
            if (factory.isEvaluator((StreamExpression)param)) {
                StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
                this.evaluatorParams.put(name, evaluator);
                continue;
            }
            if (factory.isStream((StreamExpression)param)) {
                TupleStream tupleStream = factory.constructStream((StreamExpression)param);
                this.streamParams.put(name, tupleStream);
                continue;
            }
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - only string, evaluator, or stream named parameters are supported, but param %s is none of those", expression, name));
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (Map.Entry<String, String> entry : this.stringParams.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.evaluatorParams.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), ((StreamEvaluator)entry.getValue()).toExpression(factory)));
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (includeStreams) {
                expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), ((Expressible)entry.getValue()).toExpression(factory)));
                continue;
            }
            expression.addParameter(new StreamExpressionNamedParameter(entry.getKey(), "<stream>"));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        for (StreamEvaluator evaluator : this.evaluatorParams.values()) {
            evaluator.setStreamContext(context);
        }
        for (TupleStream stream : this.streamParams.values()) {
            stream.setStreamContext(context);
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.unnestedTuples == null) {
            if (this.finished) {
                return Tuple.EOF();
            }
            this.finished = true;
            if (this.unnestedTuple != null) {
                return this.unnestedTuple;
            }
            return this.tup;
        }
        if (this.unnestedTuples.hasNext()) {
            return this.unnestedTuples.next();
        }
        return Tuple.EOF();
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        HashMap<String, Object> values2 = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : this.stringParams.entrySet()) {
            if (this.streamContext.getLets().containsKey(entry.getValue())) {
                values2.put(entry.getKey(), this.streamContext.getLets().get(entry.getValue()));
                continue;
            }
            values2.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.evaluatorParams.entrySet()) {
            values2.put(entry.getKey(), ((StreamEvaluator)entry.getValue()).evaluateOverContext());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            try {
                ArrayList<Tuple> streamTuples = new ArrayList<Tuple>();
                ((TupleStream)entry.getValue()).open();
                Tuple streamTuple = ((TupleStream)entry.getValue()).read();
                while (!streamTuple.EOF) {
                    streamTuples.add(streamTuple);
                    streamTuple = ((TupleStream)entry.getValue()).read();
                }
                values2.put(entry.getKey(), streamTuples);
            }
            finally {
                ((TupleStream)entry.getValue()).close();
            }
        }
        if (values2.size() == 1) {
            for (Map.Entry<String, Object> entry : values2.values()) {
                List l;
                if (entry instanceof Tuple) {
                    this.unnestedTuple = (Tuple)((Object)entry);
                    continue;
                }
                if (!(entry instanceof List) || (l = (List)((Object)entry)).size() <= 0 || !(l.get(0) instanceof Tuple)) continue;
                List tl = l;
                this.unnestedTuples = tl.iterator();
            }
        }
        this.tup = new Tuple(values2);
        this.tup.setFieldNames(this.fieldNames);
        this.tup.setFieldLabels(this.fieldLabels);
    }

    @Override
    public StreamComparator getStreamSort() {
        return new SingleValueComparator();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

