/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.HashRollupStream;
import org.apache.solr.client.solrj.io.stream.ParallelListStream;
import org.apache.solr.client.solrj.io.stream.ParallelMetricsRollup;
import org.apache.solr.client.solrj.io.stream.SelectStream;
import org.apache.solr.client.solrj.io.stream.SortStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class FacetStream
extends TupleStream
implements Expressible,
ParallelMetricsRollup {
    private static final long serialVersionUID = 1L;
    static final boolean defaultTieredEnabled = Boolean.parseBoolean(System.getProperty("solr.facet.stream.tiered", "true"));
    static final String TIERED_PARAM = "tiered";
    private Bucket[] buckets;
    private Metric[] metrics;
    private int rows;
    private int offset;
    private int overfetch;
    private int bucketSizeLimit;
    private boolean refine;
    private String method;
    private FieldComparator[] bucketSorts;
    private List<Tuple> tuples = new ArrayList<Tuple>();
    private int index;
    private String zkHost;
    private ModifiableSolrParams params;
    private String collection;
    private boolean resortNeeded;
    private boolean serializeBucketSizeLimit;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    protected transient TupleStream parallelizedStream;
    protected transient StreamContext context;

    public FacetStream(String zkHost, String collection, SolrParams params, Bucket[] buckets, Metric[] metrics, FieldComparator[] bucketSorts, int bucketSizeLimit) throws IOException {
        if (bucketSizeLimit == -1) {
            bucketSizeLimit = Integer.MAX_VALUE;
        }
        this.init(collection, params, buckets, bucketSorts, metrics, bucketSizeLimit, 0, bucketSizeLimit, false, null, true, 0, zkHost);
    }

    public FacetStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String refineStr;
        int idx;
        String[] keys2;
        String collectionName = factory.getValueOperand(expression, 0);
        if (collectionName.indexOf(34) > -1) {
            collectionName = collectionName.replaceAll("\"", "").replaceAll(" ", "");
        }
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter bucketExpression = factory.getNamedOperand(expression, "buckets");
        StreamExpressionNamedParameter bucketSortExpression = factory.getNamedOperand(expression, "bucketSorts");
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        StreamExpressionNamedParameter bucketLimitExpression = factory.getNamedOperand(expression, "bucketSizeLimit");
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        StreamExpressionNamedParameter rowsExpression = factory.getNamedOperand(expression, "rows");
        StreamExpressionNamedParameter offsetExpression = factory.getNamedOperand(expression, "offset");
        StreamExpressionNamedParameter overfetchExpression = factory.getNamedOperand(expression, "overfetch");
        StreamExpressionNamedParameter refineExpression = factory.getNamedOperand(expression, "refine");
        StreamExpressionNamedParameter methodExpression = factory.getNamedOperand(expression, "method");
        if (expression.getParameters().size() != 1 + namedParams.size() + metricExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("buckets") || namedParam.getName().equals("bucketSorts") || namedParam.getName().equals("bucketSizeLimit") || namedParam.getName().equals("method") || namedParam.getName().equals("offset") || namedParam.getName().equals("rows") || namedParam.getName().equals("refine") || namedParam.getName().equals("overfetch")) continue;
            params.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        if (params.get("q") == null) {
            params.set("q", "*:*");
        }
        Bucket[] buckets = null;
        if (null != bucketExpression && bucketExpression.getParameter() instanceof StreamExpressionValue && 0 != (keys2 = ((StreamExpressionValue)bucketExpression.getParameter()).getValue().split(",")).length) {
            buckets = new Bucket[keys2.length];
            for (idx = 0; idx < keys2.length; ++idx) {
                buckets[idx] = new Bucket(keys2[idx].trim());
            }
        }
        if (null == buckets) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one bucket expected. eg. 'buckets=\"name\"'", expression));
        }
        Metric[] metrics = new Metric[metricExpressions.size()];
        for (idx = 0; idx < metricExpressions.size(); ++idx) {
            metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
        }
        if (metrics.length == 0) {
            metrics = new Metric[]{new CountMetric()};
        }
        Object bucketSortString = null;
        if (bucketSortExpression == null) {
            bucketSortString = metrics[0].getIdentifier() + " desc";
        } else {
            bucketSortString = ((StreamExpressionValue)bucketSortExpression.getParameter()).getValue();
            if (((String)bucketSortString).contains("(") && metricExpressions.size() == 0 && !((String)bucketSortString).equals("count(*) desc") && !((String)bucketSortString).equals("count(*) asc")) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - the bucketSort is being performed on a metric that is not being calculated.", expression));
            }
        }
        FieldComparator[] bucketSorts = this.parseBucketSorts((String)bucketSortString, buckets);
        if (null == bucketSorts || 0 == bucketSorts.length) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one bucket sort expected. eg. 'bucketSorts=\"name asc\"'", expression));
        }
        boolean refine2 = false;
        if (refineExpression != null && (refineStr = ((StreamExpressionValue)refineExpression.getParameter()).getValue()) != null) {
            refine2 = Boolean.parseBoolean(refineStr);
        }
        if (bucketLimitExpression != null && (rowsExpression != null || offsetExpression != null || overfetchExpression != null)) {
            throw new IOException("bucketSizeLimit is incompatible with rows, offset and overfetch.");
        }
        String methodStr = null;
        if (methodExpression != null) {
            methodStr = ((StreamExpressionValue)methodExpression.getParameter()).getValue();
        }
        int overfetchInt = 250;
        if (overfetchExpression != null) {
            String overfetchStr = ((StreamExpressionValue)overfetchExpression.getParameter()).getValue();
            overfetchInt = Integer.parseInt(overfetchStr);
        }
        int offsetInt = 0;
        if (offsetExpression != null) {
            String offsetStr = ((StreamExpressionValue)offsetExpression.getParameter()).getValue();
            offsetInt = Integer.parseInt(offsetStr);
        }
        int rowsInt = Integer.MIN_VALUE;
        int bucketLimit = Integer.MIN_VALUE;
        boolean bucketLimitSet = false;
        if (null != rowsExpression) {
            String rowsStr = ((StreamExpressionValue)rowsExpression.getParameter()).getValue();
            try {
                rowsInt = Integer.parseInt(rowsStr);
                if (rowsInt <= 0 && rowsInt != -1) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - limit '%s' must be greater than 0 or -1.", expression, rowsStr));
                }
                if (rowsInt == -1) {
                    rowsInt = Integer.MAX_VALUE;
                    bucketLimit = Integer.MAX_VALUE;
                } else {
                    bucketLimit = overfetchInt == -1 ? Integer.MAX_VALUE : offsetInt + overfetchInt + rowsInt;
                }
            }
            catch (NumberFormatException e) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - limit '%s' is not a valid integer.", expression, rowsStr));
            }
        }
        if (bucketLimitExpression != null) {
            String bucketLimitStr = ((StreamExpressionValue)bucketLimitExpression.getParameter()).getValue();
            try {
                bucketLimit = Integer.parseInt(bucketLimitStr);
                bucketLimitSet = true;
                if (bucketLimit <= 0 && bucketLimit != -1) {
                    throw new IOException(String.format(Locale.ROOT, "invalid expression %s - bucketSizeLimit '%s' must be greater than 0 or -1.", expression, bucketLimitStr));
                }
                if (bucketLimit == -1) {
                    bucketLimit = Integer.MAX_VALUE;
                    rowsInt = Integer.MAX_VALUE;
                } else {
                    rowsInt = bucketLimit;
                }
            }
            catch (NumberFormatException e) {
                throw new IOException(String.format(Locale.ROOT, "invalid expression %s - bucketSizeLimit '%s' is not a valid integer.", expression, bucketLimitStr));
            }
        }
        if (rowsExpression == null && bucketLimitExpression == null) {
            rowsInt = 10;
            bucketLimit = overfetchInt == -1 ? Integer.MAX_VALUE : offsetInt + overfetchInt + rowsInt;
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(collectionName, params, buckets, bucketSorts, metrics, rowsInt, offsetInt, bucketLimit, refine2, methodStr, bucketLimitSet, overfetchInt, zkHost);
    }

    private FacetStream() {
    }

    public int getBucketSizeLimit() {
        return this.bucketSizeLimit;
    }

    public int getRows() {
        return this.rows;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getOverfetch() {
        return this.overfetch;
    }

    public Bucket[] getBuckets() {
        return this.buckets;
    }

    public String getCollection() {
        return this.collection;
    }

    private FieldComparator[] parseBucketSorts(String bucketSortString, Bucket[] buckets) throws IOException {
        String[] sorts = this.parseSorts(bucketSortString);
        FieldComparator[] comps = new FieldComparator[sorts.length];
        for (int i = 0; i < sorts.length; ++i) {
            String s = sorts[i];
            String fieldName = null;
            String order = null;
            if (s.endsWith("asc") || s.endsWith("ASC")) {
                order = "asc";
                fieldName = s.substring(0, s.length() - 3).trim().replace(" ", "");
            } else if (s.endsWith("desc") || s.endsWith("DESC")) {
                order = "desc";
                fieldName = s.substring(0, s.length() - 4).trim().replace(" ", "");
            } else {
                throw new IOException(String.format(Locale.ROOT, "invalid expression - bad bucketSort '%s'.", bucketSortString));
            }
            comps[i] = new FieldComparator(fieldName, order.equalsIgnoreCase("asc") ? ComparatorOrder.ASCENDING : ComparatorOrder.DESCENDING);
        }
        return comps;
    }

    private String[] parseSorts(String sortString) {
        ArrayList<String> sorts = new ArrayList<String>();
        boolean inParam = false;
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < sortString.length(); ++i) {
            char c = sortString.charAt(i);
            if (c == '(') {
                inParam = true;
                buff.append(c);
                continue;
            }
            if (c == ')') {
                inParam = false;
                buff.append(c);
                continue;
            }
            if (c == ',' && !inParam) {
                sorts.add(buff.toString().trim());
                buff = new StringBuilder();
                continue;
            }
            buff.append(c);
        }
        if (buff.length() > 0) {
            sorts.add(buff.toString());
        }
        return sorts.toArray(new String[sorts.size()]);
    }

    private void init(String collection, SolrParams params, Bucket[] buckets, FieldComparator[] bucketSorts, Metric[] metrics, int rows, int offset, int bucketSizeLimit, boolean refine2, String method, boolean serializeBucketSizeLimit, int overfetch, String zkHost) throws IOException {
        this.zkHost = zkHost;
        this.params = new ModifiableSolrParams(params);
        this.buckets = buckets;
        this.metrics = metrics;
        this.rows = rows;
        this.offset = offset;
        this.refine = refine2;
        this.bucketSizeLimit = bucketSizeLimit;
        this.collection = collection;
        this.bucketSorts = bucketSorts;
        this.method = method;
        this.serializeBucketSizeLimit = serializeBucketSizeLimit;
        this.overfetch = overfetch;
        for (FieldComparator sort : bucketSorts) {
            if (!sort.hasDifferentFieldNames()) continue;
            throw new IOException("Invalid FacetStream - all sorts must be constructed with a single field name.");
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        int n;
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        for (Map.Entry<String, String[]> param : this.params.getMap().entrySet()) {
            String[] stringArray = param.getValue();
            n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String val = stringArray[i];
                expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), val));
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Bucket bucket : this.buckets) {
            if (0 != builder.length()) {
                builder.append(",");
            }
            builder.append(bucket.toString());
        }
        expression.addParameter(new StreamExpressionNamedParameter("buckets", builder.toString()));
        builder = new StringBuilder();
        Object[] objectArray = this.bucketSorts;
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object sort = objectArray[n];
            if (0 != builder.length()) {
                builder.append(",");
            }
            builder.append(((FieldComparator)sort).toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("bucketSorts", builder.toString()));
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        if (this.serializeBucketSizeLimit) {
            if (this.bucketSizeLimit == Integer.MAX_VALUE) {
                expression.addParameter(new StreamExpressionNamedParameter("bucketSizeLimit", Integer.toString(-1)));
            } else {
                expression.addParameter(new StreamExpressionNamedParameter("bucketSizeLimit", Integer.toString(this.bucketSizeLimit)));
            }
        } else {
            if (this.rows == Integer.MAX_VALUE) {
                expression.addParameter(new StreamExpressionNamedParameter("rows", Integer.toString(-1)));
            } else {
                expression.addParameter(new StreamExpressionNamedParameter("rows", Integer.toString(this.rows)));
            }
            expression.addParameter(new StreamExpressionNamedParameter("offset", Integer.toString(this.offset)));
            if (this.overfetch == Integer.MAX_VALUE) {
                expression.addParameter(new StreamExpressionNamedParameter("overfetch", Integer.toString(-1)));
            } else {
                expression.addParameter(new StreamExpressionNamedParameter("overfetch", Integer.toString(this.overfetch)));
            }
        }
        if (this.method != null) {
            expression.addParameter(new StreamExpressionNamedParameter("method", this.method));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.params.stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.context = context;
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public void open() throws IOException {
        if (this.cache != null) {
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
        } else {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add(this.zkHost);
            this.cloudSolrClient = ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder(hosts, Optional.empty()).withSocketTimeout(30000)).withConnectionTimeout(15000)).build();
        }
        if (this.params.getBool(TIERED_PARAM, defaultTieredEnabled)) {
            Optional<TupleStream> maybeParallelize;
            List<String> resolved;
            ClusterStateProvider clusterStateProvider = this.cloudSolrClient.getClusterStateProvider();
            List<String> list = resolved = clusterStateProvider != null ? clusterStateProvider.resolveAlias(this.collection) : null;
            if (resolved != null && resolved.size() > 1 && (maybeParallelize = this.openParallelStream(this.context, resolved, this.metrics)).isPresent()) {
                this.parallelizedStream = maybeParallelize.get();
                return;
            }
        }
        FieldComparator[] adjustedSorts = this.adjustSorts(this.buckets, this.bucketSorts);
        this.resortNeeded = this.resortNeeded(adjustedSorts);
        String json = this.getJsonFacetString(this.buckets, this.metrics, adjustedSorts, this.method, this.refine, this.bucketSizeLimit);
        assert (this.expectedJson(json));
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams(this.params);
        paramsLoc.set("json.facet", json);
        paramsLoc.set("rows", "0");
        QueryRequest request = new QueryRequest(paramsLoc, SolrRequest.METHOD.POST);
        if (paramsLoc.get("lb.proxy") != null) {
            request.setPath("/" + this.collection + "/select");
        }
        try {
            NamedList<Object> response = this.cloudSolrClient.request(request, this.collection);
            this.getTuples(response, this.buckets, this.metrics);
            if (this.resortNeeded) {
                this.tuples.sort(this.getStreamSort());
            }
            this.index = this.offset;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private boolean expectedJson(String json) {
        if (this.method != null && !json.contains("\"method\":\"" + this.method + "\"")) {
            return false;
        }
        if (this.refine && !json.contains("\"refine\":true")) {
            return false;
        }
        if (this.serializeBucketSizeLimit ? !json.contains("\"limit\":" + this.bucketSizeLimit) : !json.contains("\"limit\":" + (this.rows + this.offset + this.overfetch))) {
            return false;
        }
        for (Bucket bucket : this.buckets) {
            if (json.contains("\"" + bucket.toString() + "\":")) continue;
            return false;
        }
        for (Metric metric : this.metrics) {
            String func = metric.getFunctionName();
            if (func.equals("count") || func.equals("per") || func.equals("std") || func.equals("countDist") || json.contains(metric.getIdentifier())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.cache == null && this.cloudSolrClient != null) {
            this.cloudSolrClient.close();
        }
    }

    @Override
    public Tuple read() throws IOException {
        if (this.parallelizedStream != null) {
            return this.parallelizedStream.read();
        }
        if (this.index < this.tuples.size() && this.index < this.offset + this.rows) {
            Tuple tuple = this.tuples.get(this.index);
            ++this.index;
            return tuple;
        }
        Tuple tuple = Tuple.EOF();
        if (this.bucketSizeLimit == Integer.MAX_VALUE) {
            tuple.put("totalRows", this.tuples.size());
        }
        return tuple;
    }

    private String getJsonFacetString(Bucket[] _buckets, Metric[] _metrics, FieldComparator[] _sorts, String _method, boolean _refine, int _limit) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, _buckets, _metrics, _sorts, _limit, _method, _refine, 0);
        return "{" + buf.toString() + "}";
    }

    private FieldComparator[] adjustSorts(Bucket[] _buckets, FieldComparator[] _sorts) throws IOException {
        if (_buckets.length == _sorts.length) {
            return _sorts;
        }
        if (_sorts.length == 1) {
            FieldComparator[] adjustedSorts = new FieldComparator[_buckets.length];
            if (_sorts[0].getLeftFieldName().contains("(")) {
                for (int i = 0; i < adjustedSorts.length; ++i) {
                    adjustedSorts[i] = _sorts[0];
                }
            } else {
                for (int i = 0; i < adjustedSorts.length; ++i) {
                    adjustedSorts[i] = new FieldComparator(_buckets[i].toString(), _sorts[0].getOrder());
                }
            }
            return adjustedSorts;
        }
        throw new IOException("If multiple sorts are specified there must be a sort for each bucket.");
    }

    private boolean resortNeeded(FieldComparator[] fieldComparators) {
        for (FieldComparator fieldComparator : fieldComparators) {
            if (!fieldComparator.getLeftFieldName().contains("(")) continue;
            return true;
        }
        return false;
    }

    private void appendJson(StringBuilder buf, Bucket[] _buckets, Metric[] _metrics, FieldComparator[] _sorts, int _limit, String method, boolean refine2, int level) {
        buf.append('\"');
        buf.append(_buckets[level].toString());
        buf.append('\"');
        buf.append(":{");
        buf.append("\"type\":\"terms\"");
        buf.append(",\"field\":\"").append(_buckets[level].toString()).append('\"');
        buf.append(",\"limit\":").append(_limit);
        if (refine2) {
            buf.append(",\"refine\":true");
        }
        if (method != null) {
            buf.append(",\"method\":\"").append(method).append('\"');
        }
        String fsort = this.getFacetSort(_sorts[level].getLeftFieldName(), _metrics);
        buf.append(",\"sort\":{\"").append(fsort).append("\":\"").append((Object)_sorts[level].getOrder()).append("\"}");
        buf.append(",\"facet\":{");
        int metricCount = 0;
        ++level;
        boolean comma = false;
        for (Metric metric : _metrics) {
            String facetKey = "facet_" + metricCount;
            String identifier = metric.getIdentifier();
            if (identifier.startsWith("count(")) continue;
            if (comma) {
                buf.append(",");
            }
            if (level == _buckets.length || fsort.equals(facetKey)) {
                comma = true;
                if (identifier.startsWith("per(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("per", "percentile")).append('\"');
                } else if (identifier.startsWith("std(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("std", "stddev")).append('\"');
                } else if (identifier.startsWith("countDist(")) {
                    buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("countDist", "unique")).append('\"');
                } else {
                    buf.append('\"').append(facetKey).append("\":\"").append(identifier).append('\"');
                }
            }
            ++metricCount;
        }
        if (level < _buckets.length) {
            if (metricCount > 0) {
                buf.append(",");
            }
            this.appendJson(buf, _buckets, _metrics, _sorts, _limit, method, refine2, level);
        }
        buf.append("}}");
    }

    private String getFacetSort(String id, Metric[] _metrics) {
        int index = 0;
        int metricCount = 0;
        for (Metric metric : _metrics) {
            if (metric.getIdentifier().startsWith("count(")) {
                if (id.startsWith("count(")) {
                    return "count";
                }
                ++index;
                continue;
            }
            if (id.equals(_metrics[index].getIdentifier())) {
                return "facet_" + metricCount;
            }
            ++index;
            ++metricCount;
        }
        return "index";
    }

    private void getTuples(NamedList<?> response, Bucket[] buckets, Metric[] metrics) {
        Tuple tuple = new Tuple();
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuples(0, this.tuples, tuple, facets, buckets, metrics);
    }

    private void fillTuples(int level, List<Tuple> tuples, Tuple currentTuple, NamedList<?> facets, Bucket[] _buckets, Metric[] _metrics) {
        String bucketName = _buckets[level].toString();
        NamedList nl = (NamedList)facets.get(bucketName);
        if (nl == null) {
            return;
        }
        List allBuckets = (List)nl.get("buckets");
        for (int b = 0; b < allBuckets.size(); ++b) {
            NamedList bucket = (NamedList)allBuckets.get(b);
            Object val = bucket.get("val");
            if (val instanceof Integer) {
                val = ((Integer)val).longValue();
            }
            Tuple t = currentTuple.clone();
            t.put(bucketName, val);
            int nextLevel = level + 1;
            if (nextLevel < _buckets.length) {
                this.fillTuples(nextLevel, tuples, t.clone(), bucket, _buckets, _metrics);
                continue;
            }
            int m = 0;
            for (Metric metric : _metrics) {
                String identifier = metric.getIdentifier();
                if (!identifier.startsWith("count(")) {
                    Number d = (Number)bucket.get("facet_" + m);
                    if (metric.outputLong) {
                        if (d instanceof Long || d instanceof Integer) {
                            t.put(identifier, d.longValue());
                        } else {
                            t.put(identifier, Math.round(d.doubleValue()));
                        }
                    } else {
                        t.put(identifier, d.doubleValue());
                    }
                    ++m;
                    continue;
                }
                long l = ((Number)bucket.get("count")).longValue();
                t.put("count(*)", l);
            }
            tuples.add(t);
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        if (this.bucketSorts.length > 1) {
            return new MultipleFieldComparator(this.bucketSorts);
        }
        return this.bucketSorts[0];
    }

    List<Metric> getMetrics() {
        return Arrays.asList(this.metrics);
    }

    @Override
    public TupleStream[] parallelize(List<String> partitions) throws IOException {
        ModifiableSolrParams withoutTieredParam = new ModifiableSolrParams(this.params);
        withoutTieredParam.remove(TIERED_PARAM);
        TupleStream[] streams = new TupleStream[partitions.size()];
        for (int p = 0; p < streams.length; ++p) {
            FacetStream cloned = new FacetStream();
            cloned.init(partitions.get(p), withoutTieredParam, this.buckets, this.bucketSorts, this.metrics, this.rows, this.offset, this.bucketSizeLimit, this.refine, this.method, this.serializeBucketSizeLimit, this.overfetch, this.zkHost);
            streams[p] = cloned;
        }
        return streams;
    }

    @Override
    public TupleStream getSortedRollupStream(ParallelListStream plist, Metric[] rollupMetrics) throws IOException {
        HashRollupStream rollup = new HashRollupStream(plist, this.buckets, rollupMetrics);
        SelectStream select = new SelectStream((TupleStream)rollup, this.getRollupSelectFields(rollupMetrics));
        return new SortStream(select, this.getStreamSort());
    }

    protected Map<String, String> getRollupSelectFields(Metric[] rollupMetrics) {
        HashMap<String, String> map = new HashMap<String, String>(rollupMetrics.length * 2);
        for (Bucket b : this.buckets) {
            String key = b.toString();
            map.put(key, key);
        }
        for (Metric m : rollupMetrics) {
            String[] cols = m.getColumns();
            String col = cols != null && cols.length > 0 ? cols[0] : "*";
            map.put(m.getIdentifier(), col);
        }
        return map;
    }
}

