/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CsvStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String[] headers;
    private String currentFile;
    private int lineNumber;
    protected TupleStream originalStream;

    public CsvStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (expression.getParameters().size() != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.init(factory.constructStream(streamExpressions.get(0)));
    }

    private void init(TupleStream stream) throws IOException {
        this.originalStream = stream;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.originalStream instanceof Expressible)) throw new IOException("This CsvStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.originalStream)).toExpression(factory));
            return expression;
        } else {
            expression.addParameter("<stream>");
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.originalStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.originalStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.originalStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.originalStream.open();
    }

    @Override
    public void close() throws IOException {
        this.originalStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this.originalStream.read();
        ++this.lineNumber;
        if (tuple.EOF) {
            return tuple;
        }
        String file = this.formatFile(tuple.getString("file"));
        String line = tuple.getString("line");
        if (file.equals(this.currentFile)) {
            String[] fields2 = this.split(line);
            if (fields2.length != this.headers.length) {
                throw new IOException("Headers and lines must have the same number of fields [file:" + file + " line number:" + this.lineNumber + "]");
            }
            Tuple out = new Tuple();
            out.put("id", file + "_" + this.lineNumber);
            for (int i = 0; i < this.headers.length; ++i) {
                if (fields2[i] == null || fields2[i].length() <= 0) continue;
                out.put(this.headers[i], fields2[i]);
            }
            return out;
        }
        this.currentFile = file;
        this.headers = this.split(line);
        this.lineNumber = 1;
        return this.read();
    }

    private String formatFile(String file) {
        if (file.startsWith("./")) {
            return file.substring(2);
        }
        return file;
    }

    protected String[] split(String line) {
        String[] fields2 = line.split(",(?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", -1);
        for (int i = 0; i < fields2.length; ++i) {
            String f = fields2[i];
            if (!f.startsWith("\"") || !f.endsWith("\"")) continue;
            fields2[i] = f = f.substring(1, f.length() - 1);
        }
        return fields2;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.originalStream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

