/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;

public class ShortestPathStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String fromNode;
    private String toNode;
    private String fromField;
    private String toField;
    private int joinBatchSize;
    private int maxDepth;
    private String zkHost;
    private String collection;
    private final Deque<Tuple> shortestPaths = new ArrayDeque<Tuple>();
    private boolean found;
    private StreamContext streamContext;
    private int threads;
    private SolrParams queryParams;

    public ShortestPathStream(String zkHost, String collection, String fromNode, String toNode, String fromField, String toField, SolrParams queryParams, int joinBatchSize, int threads, int maxDepth) {
        this.init(zkHost, collection, fromNode, toNode, fromField, toField, queryParams, joinBatchSize, threads, maxDepth);
    }

    public ShortestPathStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        String fromNode = null;
        StreamExpressionNamedParameter fromExpression = factory.getNamedOperand(expression, "from");
        if (fromExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - from param is required", expression));
        }
        fromNode = ((StreamExpressionValue)fromExpression.getParameter()).getValue();
        String toNode = null;
        StreamExpressionNamedParameter toExpression = factory.getNamedOperand(expression, "to");
        if (toExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - to param is required", expression));
        }
        toNode = ((StreamExpressionValue)toExpression.getParameter()).getValue();
        String fromField = null;
        String toField = null;
        StreamExpressionNamedParameter edgeExpression = factory.getNamedOperand(expression, "edge");
        if (edgeExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - edge param is required", expression));
        }
        String edge = ((StreamExpressionValue)edgeExpression.getParameter()).getValue();
        String[] fields2 = edge.split("=");
        if (fields2.length != 2) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - edge param separated by and = and must contain two fields", expression));
        }
        fromField = fields2[0].trim();
        toField = fields2[1].trim();
        int threads = 6;
        StreamExpressionNamedParameter threadsExpression = factory.getNamedOperand(expression, "threads");
        if (threadsExpression != null) {
            threads = Integer.parseInt(((StreamExpressionValue)threadsExpression.getParameter()).getValue());
        }
        int partitionSize = 250;
        StreamExpressionNamedParameter partitionExpression = factory.getNamedOperand(expression, "partitionSize");
        if (partitionExpression != null) {
            partitionSize = Integer.parseInt(((StreamExpressionValue)partitionExpression.getParameter()).getValue());
        }
        int maxDepth = 0;
        StreamExpressionNamedParameter depthExpression = factory.getNamedOperand(expression, "maxDepth");
        if (depthExpression == null) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - maxDepth param is required", expression));
        }
        maxDepth = Integer.parseInt(((StreamExpressionValue)depthExpression.getParameter()).getValue());
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("to") || namedParam.getName().equals("from") || namedParam.getName().equals("edge") || namedParam.getName().equals("maxDepth") || namedParam.getName().equals("threads") || namedParam.getName().equals("partitionSize")) continue;
            params.set(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, collectionName, fromNode, toNode, fromField, toField, params, partitionSize, threads, maxDepth);
    }

    private void init(String zkHost, String collection, String fromNode, String toNode, String fromField, String toField, SolrParams queryParams, int joinBatchSize, int threads, int maxDepth) {
        this.zkHost = zkHost;
        this.collection = collection;
        this.fromNode = fromNode;
        this.toNode = toNode;
        this.fromField = fromField;
        this.toField = toField;
        this.queryParams = queryParams;
        this.joinBatchSize = joinBatchSize;
        this.threads = threads;
        this.maxDepth = maxDepth;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.queryParams);
        for (Map.Entry<String, String[]> param : mParams.getMap().entrySet()) {
            String value = String.join((CharSequence)",", param.getValue());
            value = value.replace("\"", "\\\"");
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey().toString(), value));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("maxDepth", Integer.toString(this.maxDepth)));
        expression.addParameter(new StreamExpressionNamedParameter("threads", Integer.toString(this.threads)));
        expression.addParameter(new StreamExpressionNamedParameter("partitionSize", Integer.toString(this.joinBatchSize)));
        expression.addParameter(new StreamExpressionNamedParameter("from", this.fromNode));
        expression.addParameter(new StreamExpressionNamedParameter("to", this.toNode));
        expression.addParameter(new StreamExpressionNamedParameter("edge", this.fromField + "=" + this.toField));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("graph-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName("solr (graph)");
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.queryParams);
        child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        List<String> parents;
        ArrayList<Map<String, List<String>>> allVisited = new ArrayList<Map<String, List<String>>>();
        HashMap visited = new HashMap();
        visited.put(this.fromNode, null);
        allVisited.add(visited);
        HashMap nextVisited = null;
        ArrayList<Edge> targets = new ArrayList<Edge>();
        ExecutorService threadPool = null;
        try {
            threadPool = ExecutorUtil.newMDCAwareFixedThreadPool(this.threads, new SolrNamedThreadFactory("ShortestPathStream"));
            for (int depth = 0; targets.size() == 0 && depth < this.maxDepth; ++depth) {
                Set nodes = visited.keySet();
                Iterator it = nodes.iterator();
                nextVisited = new HashMap();
                int batchCount = 0;
                ArrayList<String> queryNodes = new ArrayList<String>();
                ArrayList<Future<List<Edge>>> futures = new ArrayList<Future<List<Edge>>>();
                while (it.hasNext()) {
                    String node = (String)it.next();
                    queryNodes.add(node);
                    if (++batchCount != this.joinBatchSize && it.hasNext()) continue;
                    try {
                        JoinRunner joinRunner = new JoinRunner(queryNodes);
                        Future<List<Edge>> future = threadPool.submit(joinRunner);
                        futures.add(future);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    batchCount = 0;
                    queryNodes = new ArrayList();
                }
                try {
                    for (Future future : futures) {
                        List edges = (List)future.get();
                        for (Edge edge : edges) {
                            if (this.toNode.equals(edge.to)) {
                                targets.add(edge);
                                if (nextVisited.containsKey(edge.to)) {
                                    parents = (List)nextVisited.get(edge.to);
                                    parents.add(edge.from);
                                    continue;
                                }
                                parents = new ArrayList<String>();
                                parents.add(edge.from);
                                nextVisited.put(edge.to, parents);
                                continue;
                            }
                            if (this.cycle(edge.to, allVisited)) continue;
                            if (nextVisited.containsKey(edge.to)) {
                                parents = (List)nextVisited.get(edge.to);
                                parents.add(edge.from);
                                continue;
                            }
                            parents = new ArrayList();
                            parents.add(edge.from);
                            nextVisited.put(edge.to, parents);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                allVisited.add(nextVisited);
                visited = nextVisited;
            }
        }
        finally {
            threadPool.shutdown();
        }
        HashSet<String> finalPaths = new HashSet<String>();
        if (targets.size() > 0) {
            for (Edge edge : targets) {
                ArrayList paths = new ArrayList();
                ArrayDeque<String> path = new ArrayDeque<String>();
                path.addFirst(edge.to);
                paths.add(path);
                for (int i = allVisited.size() - 1; i >= 0; --i) {
                    Map map = (Map)allVisited.get(i);
                    Iterator it = paths.iterator();
                    ArrayList newPaths = new ArrayList();
                    while (it.hasNext()) {
                        Deque p = (Deque)it.next();
                        parents = (ArrayList<String>)map.get(p.peekFirst());
                        if (parents == null) continue;
                        for (String parent : parents) {
                            ArrayDeque<String> newPath = new ArrayDeque<String>(p);
                            newPath.addFirst(parent);
                            newPaths.add(newPath);
                        }
                        paths = newPaths;
                    }
                }
                for (Deque deque : paths) {
                    String s = deque.toString();
                    if (finalPaths.contains(s)) continue;
                    Tuple shortestPath = new Tuple("path", deque);
                    this.shortestPaths.add(shortestPath);
                    finalPaths.add(s);
                }
            }
        }
    }

    private boolean cycle(String node, List<Map<String, List<String>>> allVisited) {
        for (Map<String, List<String>> visited : allVisited) {
            if (!visited.containsKey(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.found = false;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.shortestPaths.size() > 0) {
            this.found = true;
            Tuple t = this.shortestPaths.removeFirst();
            return t;
        }
        Tuple tuple = Tuple.EOF();
        if (!this.found) {
            tuple.put("sorry", "No path found");
        }
        return tuple;
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    private static class Edge {
        private String from;
        private String to;

        public Edge(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    private class JoinRunner
    implements Callable<List<Edge>> {
        private List<String> nodes;
        private List<Edge> edges = new ArrayList<Edge>();

        public JoinRunner(List<String> nodes) {
            this.nodes = nodes;
        }

        @Override
        public List<Edge> call() {
            ModifiableSolrParams joinParams = new ModifiableSolrParams(ShortestPathStream.this.queryParams);
            String fl = ShortestPathStream.this.fromField + "," + ShortestPathStream.this.toField;
            joinParams.set("fl", fl);
            joinParams.set("qt", "/export");
            joinParams.set("sort", ShortestPathStream.this.toField + " asc," + ShortestPathStream.this.fromField + " asc");
            StringBuilder nodeQuery = new StringBuilder();
            for (String node : this.nodes) {
                nodeQuery.append(node).append(" ");
            }
            String q = ShortestPathStream.this.fromField + ":(" + nodeQuery.toString().trim() + ")";
            joinParams.set("q", q);
            TupleStream stream = null;
            try {
                stream = new UniqueStream(new CloudSolrStream(ShortestPathStream.this.zkHost, ShortestPathStream.this.collection, joinParams), new MultipleFieldEqualitor(new FieldEqualitor(ShortestPathStream.this.toField), new FieldEqualitor(ShortestPathStream.this.fromField)));
                stream.setStreamContext(ShortestPathStream.this.streamContext);
                stream.open();
                while (true) {
                    Tuple tuple = stream.read();
                    if (tuple.EOF) {
                        break;
                    }
                    String _toNode = tuple.getString(ShortestPathStream.this.toField);
                    String _fromNode = tuple.getString(ShortestPathStream.this.fromField);
                    Edge edge = new Edge(_fromNode, _toNode);
                    this.edges.add(edge);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception ce) {
                    throw new RuntimeException(ce);
                }
            }
            return this.edges;
        }
    }
}

