/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ValueAtEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public ValueAtEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2[0] instanceof List) {
            List c = (List)values2[0];
            int index = -1;
            if (values2.length == 2) {
                index = ((Number)values2[1]).intValue();
                if (index >= c.size()) {
                    throw new IOException("Index out of bounds: " + index);
                }
            } else {
                throw new IOException("The valueAt function expects an array and array index as parameters.");
            }
            return c.get(index);
        }
        if (values2[0] instanceof Matrix) {
            Matrix c = (Matrix)values2[0];
            double[][] data2 = c.getData();
            int row = -1;
            int col = -1;
            if (values2.length == 3) {
                row = ((Number)values2[1]).intValue();
                if (row >= data2.length) {
                    throw new IOException("Row index out of bounds: " + row);
                }
                col = ((Number)values2[2]).intValue();
                if (col >= data2[0].length) {
                    throw new IOException("Column index out of bounds: " + col);
                }
            } else {
                throw new IOException("The valueAt function expects a matrix and row and column indexes");
            }
            return data2[row][col];
        }
        throw new IOException("The valueAt function expects a numeric array or matrix as the first parameter");
    }
}

