/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TTestEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public TTestEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() != 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two parameters but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        TTest tTest = new TTest();
        Tuple tuple = new Tuple();
        if (value1 instanceof Number) {
            double mean = ((Number)value1).doubleValue();
            if (value2 instanceof List) {
                List values2 = (List)value2;
                double[] samples = new double[values2.size()];
                for (int i = 0; i < samples.length; ++i) {
                    samples[i] = ((Number)values2.get(i)).doubleValue();
                }
                double tstat = tTest.t(mean, samples);
                double pval = tTest.tTest(mean, samples);
                tuple.put("t-statistic", tstat);
                tuple.put("p-value", pval);
                return tuple;
            }
            throw new IOException("Second parameter for ttest must be a double array");
        }
        if (value1 instanceof List) {
            List values1 = (List)value1;
            double[] samples1 = new double[values1.size()];
            for (int i = 0; i < samples1.length; ++i) {
                samples1[i] = ((Number)values1.get(i)).doubleValue();
            }
            if (value2 instanceof List) {
                List values2 = (List)value2;
                double[] samples2 = new double[values2.size()];
                for (int i = 0; i < samples2.length; ++i) {
                    samples2[i] = ((Number)values2.get(i)).doubleValue();
                }
                double tstat = tTest.t(samples1, samples2);
                double pval = tTest.tTest(samples1, samples2);
                tuple.put("t-statistic", tstat);
                tuple.put("p-value", pval);
                return tuple;
            }
            throw new IOException("Second parameter for ttest must be a double array");
        }
        throw new IOException("First parameter for ttest must be either a double our double array");
    }
}

