/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ScalarAddEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public ScalarAddEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expects exactly 2 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        double d = ((Number)value1).doubleValue();
        if (value2 instanceof List) {
            List nums = (List)value2;
            ArrayList<Double> out = new ArrayList<Double>();
            for (Number num : nums) {
                out.add(this.operate(num.doubleValue(), d));
            }
            return out;
        }
        if (value2 instanceof Matrix) {
            Matrix matrix = (Matrix)value2;
            double[][] data2 = matrix.getData();
            double[][] newData = new double[data2.length][];
            for (int i = 0; i < data2.length; ++i) {
                double[] row = data2[i];
                double[] newRow = new double[row.length];
                for (int j = 0; j < row.length; ++j) {
                    newRow[j] = this.operate(row[j], d);
                }
                newData[i] = newRow;
            }
            return new Matrix(newData);
        }
        throw new IOException("scalar add, subtract, multiply and divide operate on numeric arrays and matrices only.");
    }

    protected double operate(double value, double d) {
        return value + d;
    }
}

