/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RemoveCacheEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public RemoveCacheEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 3 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (values2.length == 2) {
            String space = (String)values2[0];
            String key = (String)values2[1];
            space = space.replace("\"", "");
            key = key.replace("\"", "");
            ConcurrentMap<String, ConcurrentMap<String, Object>> objectCache = this.streamContext.getObjectCache();
            ConcurrentMap spaceCache = (ConcurrentMap)objectCache.get(space);
            if (spaceCache != null) {
                return spaceCache.remove(key);
            }
            return false;
        }
        throw new IOException("The removeCache function requires two parameters: workspace and key");
    }
}

