/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.SourceEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class RawValueEvaluator
extends SourceEvaluator {
    private static final long serialVersionUID = 1L;
    private Object value;

    public RawValueEvaluator(Object value) {
        this.init(value);
    }

    public RawValueEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionParameter> parameters2 = factory.getOperandsOfType(expression, StreamExpressionValue.class);
        if (expression.getParameters().size() != parameters2.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found - expecting only raw values", expression));
        }
        if (1 != parameters2.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - only 1 value can exist in a %s(...) evaluator", expression, factory.getFunctionName(this.getClass())));
        }
        this.init(factory.constructPrimitiveObject(((StreamExpressionValue)parameters2.get(0)).getValue()));
    }

    private void init(Object value) {
        this.value = value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : (value instanceof Float ? Double.valueOf(((Float)value).doubleValue()) : value);
    }

    @Override
    public Object evaluate(Tuple tuple) {
        return this.value;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionValue(this.value.toString()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

