/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.math3.primes.Primes;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PrimesEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public PrimesEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (2 != values2.length) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with 2 values but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values2.length));
        }
        int sizeNum = ((Number)values2[0]).intValue();
        int startNum = ((Number)values2[1]).intValue();
        ArrayList<Integer> primes = new ArrayList<Integer>();
        for (int i = 0; i < sizeNum; ++i) {
            int prime = Primes.nextPrime((int)startNum);
            primes.add(prime);
            startNum = prime;
            ++startNum;
        }
        return primes;
    }
}

