/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PowerEvaluator
extends RecursiveNumericEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PowerEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object first, Object second) throws IOException {
        if (null == first || null == second) {
            return null;
        }
        if (first instanceof Number) {
            Number value = (Number)first;
            if (second instanceof Number) {
                Number exponent = (Number)second;
                return Math.pow(value.doubleValue(), exponent.doubleValue());
            }
            if (second instanceof List) {
                List exponents = (List)second;
                ArrayList<Double> pows = new ArrayList<Double>();
                for (Number exponent : exponents) {
                    pows.add(Math.pow(value.doubleValue(), exponent.doubleValue()));
                }
                return pows;
            }
            throw new IOException("The second parameter to the pow function must either be a scalar or list of scalars");
        }
        if (first instanceof List) {
            List values2 = (List)first;
            if (second instanceof Number) {
                Number exponent = (Number)second;
                ArrayList<Double> out = new ArrayList<Double>(values2.size());
                for (Number value : values2) {
                    out.add(Math.pow(value.doubleValue(), exponent.doubleValue()));
                }
                return out;
            }
            if (second instanceof List) {
                ArrayList<Double> out = new ArrayList<Double>(values2.size());
                List exponents = (List)second;
                if (values2.size() != exponents.size()) {
                    throw new IOException("The pow function requires vectors of equal size if two vectors are provided.");
                }
                for (int i = 0; i < exponents.size(); ++i) {
                    out.add(Math.pow(((Number)values2.get(i)).doubleValue(), ((Number)exponents.get(i)).doubleValue()));
                }
                return out;
            }
            throw new IOException("The second parameter to the pow function must either be a scalar or list of scalars");
        }
        throw new IOException("The first parameter to the pow function must either be a scalar or list of scalars");
    }
}

