/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluatorException;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultiplyEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public MultiplyEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values2) throws IOException {
        if (Arrays.stream(values2).anyMatch(item -> null == item)) {
            return null;
        }
        if (0 == values2.length) {
            return null;
        }
        BigDecimal result2 = BigDecimal.ONE;
        for (Object value : values2) {
            result2 = this.multiply(result2, value);
        }
        return result2;
    }

    private BigDecimal multiply(BigDecimal left, Object right) throws IOException {
        if (null == left || null == right) {
            return null;
        }
        if (right instanceof BigDecimal) {
            return left.multiply((BigDecimal)right);
        }
        if (right instanceof Number) {
            return this.multiply(left, new BigDecimal(right.toString()));
        }
        if (right instanceof List) {
            return this.multiply(left, this.doWork(((List)right).toArray()));
        }
        throw new StreamEvaluatorException("Numeric value expected but found type %s for value %s", right.getClass().getName(), right.toString());
    }
}

